/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.CollectionFormat;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterDescriptionReader")
@Order(value=-2147482648)
public class ApiParamParameterBuilder
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public ApiParamParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    @Override
    public void apply(ParameterContext context) {
        Optional<ApiParam> apiParam = context.resolvedMethodParameter().findAnnotation(ApiParam.class);
        AllowableValues allowedValues = this.allowableValues(context.alternateFor(context.resolvedMethodParameter().getParameterType()), apiParam.map(ApiParam::allowableValues).orElse(""));
        context.parameterBuilder().allowableValues(allowedValues);
        if (allowedValues instanceof AllowableListValues) {
            context.requestParameterBuilder().query(q -> q.enumerationFacet(e -> e.allowedValues(allowedValues)));
        } else if (allowedValues instanceof AllowableRangeValues) {
            context.requestParameterBuilder().query(q -> q.numericFacet(n -> n.from((AllowableRangeValues)allowedValues)));
        }
        if (apiParam.isPresent()) {
            ApiParam annotation = apiParam.get();
            Example example = null;
            if (annotation.example().length() > 0) {
                example = new ExampleBuilder().value(annotation.example()).build();
            }
            Optional<ScalarType> scalarType = ScalarType.from(annotation.type(), annotation.format());
            context.parameterBuilder().name(annotation.name()).description(this.descriptions.resolve(annotation.value())).parameterAccess(annotation.access()).defaultValue(annotation.defaultValue()).allowMultiple(annotation.allowMultiple()).allowEmptyValue(annotation.allowEmptyValue()).required(annotation.required()).scalarExample(example).complexExamples(Examples.examples(annotation.examples())).hidden(annotation.hidden()).collectionFormat(annotation.collectionFormat()).order(-2147482648);
            context.requestParameterBuilder().name(annotation.name()).description(this.descriptions.resolve(annotation.value())).required(annotation.required()).hidden(annotation.hidden()).precedence(-2147482648).query(q -> q.model(m -> scalarType.ifPresent(m::maybeConvertToScalar)).collectionFormat(CollectionFormat.convert(annotation.collectionFormat()).orElse(null)).defaultValue(annotation.defaultValue()).allowEmptyValue(annotation.allowEmptyValue())).example(example).examples(Examples.allExamples(annotation.examples()));
        }
    }

    private AllowableValues allowableValues(ResolvedType parameterType, String allowableValueString) {
        AllowableValues allowableValues = null;
        if (!StringUtils.isEmpty((Object)allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString(allowableValueString);
        } else {
            if (this.enumTypeDeterminer.isEnum(parameterType.getErasedType())) {
                allowableValues = Enums.allowableValues(parameterType.getErasedType());
            }
            if (Collections.isContainerType(parameterType)) {
                allowableValues = Enums.allowableValues(Collections.collectionElementType(parameterType).getErasedType());
            }
        }
        return allowableValues;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

