/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spring.web.DescriptionResolver;

public final class ApiModelProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiModelProperties.class);
    private static final Pattern RANGE_PATTERN = Pattern.compile("range([\\[(])(.*),(.*)([])])$");

    private ApiModelProperties() {
        throw new UnsupportedOperationException();
    }

    static Function<ApiModelProperty, AllowableValues> toAllowableValues() {
        return annotation -> ApiModelProperties.allowableValueFromString(annotation.allowableValues());
    }

    public static AllowableValues allowableValueFromString(String allowableValueString) {
        AllowableValues allowableValues = new AllowableListValues(new ArrayList<String>(), "LIST");
        String trimmed = allowableValueString.trim();
        Matcher matcher = RANGE_PATTERN.matcher(trimmed.replaceAll(" ", ""));
        if (matcher.matches()) {
            if (matcher.groupCount() != 4) {
                LOGGER.warn("Unable to parse range specified {} correctly", (Object)trimmed);
            } else {
                allowableValues = new AllowableRangeValues(matcher.group(2).contains("infinity") ? null : matcher.group(2), matcher.group(1).equals("("), matcher.group(3).contains("infinity") ? null : matcher.group(3), matcher.group(4).equals(")"));
            }
        } else if (trimmed.contains(",")) {
            List<String> split = Stream.of(trimmed.split(",")).map(String::trim).filter(item -> !item.isEmpty()).collect(Collectors.toList());
            allowableValues = new AllowableListValues(split, "LIST");
        } else if (StringUtils.hasText((String)trimmed)) {
            List<String> singleVal = Collections.singletonList(trimmed);
            allowableValues = new AllowableListValues(singleVal, "LIST");
        }
        return allowableValues;
    }

    static Function<ApiModelProperty, String> toDescription(DescriptionResolver descriptions) {
        return annotation -> {
            String description = "";
            if (!StringUtils.isEmpty((Object)annotation.value())) {
                description = annotation.value();
            } else if (!StringUtils.isEmpty((Object)annotation.notes())) {
                description = annotation.notes();
            }
            return descriptions.resolve(description);
        };
    }

    static Function<ApiModelProperty, ResolvedType> toType(TypeResolver resolver) {
        return annotation -> {
            try {
                return resolver.resolve(Class.forName(annotation.dataType()), new Type[0]);
            }
            catch (ClassNotFoundException e) {
                return resolver.resolve(Object.class, new Type[0]);
            }
        };
    }

    public static Optional<ApiModelProperty> findApiModePropertyAnnotation(AnnotatedElement annotated) {
        Optional<ApiModelProperty> annotation = Optional.empty();
        if (annotated instanceof Method) {
            annotation = Optional.ofNullable((ApiModelProperty)AnnotationUtils.findAnnotation((Method)((Method)annotated), ApiModelProperty.class));
        }
        return annotation.map(Optional::of).orElse(Optional.ofNullable((ApiModelProperty)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiModelProperty.class)));
    }

    static Function<ApiModelProperty, String> toExample() {
        return annotation -> {
            String example = "";
            if (!StringUtils.isEmpty((Object)annotation.example())) {
                example = annotation.example();
            }
            return example;
        };
    }
}

