/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.asynctask.MetadataRestoreTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.reponse.MetadataBackupResponse;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.tool.CancelHook;
import org.apache.kylin.tool.FavoriteRuleTool;
import org.apache.kylin.tool.JobInfoTool;
import org.apache.kylin.tool.QueryHistoryOffsetTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="opsService")
public class OpsService {
    public static final Logger log = LoggerFactory.getLogger(OpsService.class);
    public static final String META_BACKUP_DIR = "_metadata_backup";
    public static final String SYSTEM_LEVEL_METADATA_BACKUP_DIR_NAME = "_system_level_metadata_backup";
    public static final String PROJECT_LEVEL_METADATA_BACKUP_DIR_NAME = "_project_level_metadata_backup";
    public static final String BACKUP_STATUS = "_backup_status";
    private static final String PATH_SEP = "/";
    public static final String META_BACKUP_PATH = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "_metadata_backup";
    public static final String GLOBAL_METADATA_BACKUP_PATH = META_BACKUP_PATH + "/" + "_system_level_metadata_backup";
    public static final String PROJECT_METADATA_BACKUP_PATH = META_BACKUP_PATH + "/" + "_project_level_metadata_backup";
    private static int defaultStatusReadRetryTime = 5;

    public static void resetStatusReadRetryTime(int times) {
        defaultStatusReadRetryTime = times;
    }

    public static String getMetaBackupStoreDir(String project) {
        if (project == null || project.equals("_global")) {
            return GLOBAL_METADATA_BACKUP_PATH;
        }
        return PROJECT_METADATA_BACKUP_PATH + PATH_SEP + project;
    }

    public String backupMetadata(String project) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String username = AclPermissionUtil.getCurrentUsername();
        MetadataBackup metadataBackup = new MetadataBackup(OpsService.getMetaBackupStoreDir(project), fs, username, project);
        return metadataBackup.startBackup();
    }

    public static List<MetadataBackupResponse> getMetadataBackupList(String project) throws IOException {
        String pathStr = OpsService.getMetaBackupStoreDir(project);
        Path path = new Path(pathStr);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        ArrayList res = Lists.newArrayList();
        if (!fs.exists(path)) {
            return res;
        }
        for (FileStatus fileStatu : fs.listStatus(path)) {
            if (!fileStatu.isDirectory()) continue;
            Path statusPath = new Path(fileStatu.getPath().toString() + PATH_SEP + BACKUP_STATUS);
            MetadataBackupResponse response = new MetadataBackupResponse();
            response.setPath(fileStatu.getPath().toUri().toString());
            if (fs.exists(statusPath)) {
                MetadataBackupStatusInfo backupStatuInfo = OpsService.getMetadataStatusInfoWithRetry(statusPath, fs, defaultStatusReadRetryTime);
                response.setStatus(backupStatuInfo.getStatus());
                response.setSize(backupStatuInfo.getSize());
                response.setOwner(backupStatuInfo.getOwner());
            }
            res.add(response);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetadataBackupStatusInfo getMetadataStatusInfoWithRetry(Path statusPath, FileSystem fs, int retryTime) {
        MetadataBackupStatusInfo metadataBackupStatusInfo = new MetadataBackupStatusInfo();
        while (true) {
            try (FSDataInputStream fis = fs.open(statusPath);){
                String value = fis.readUTF();
                MetadataBackupStatusInfo metadataBackupStatusInfo2 = metadataBackupStatusInfo = (MetadataBackupStatusInfo)JsonUtil.readValue((String)value, MetadataBackupStatusInfo.class);
                return metadataBackupStatusInfo2;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                metadataBackupStatusInfo.setStatus(MetadataBackupStatus.UNKNOWN);
                if (--retryTime < 0) continue;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException ex) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (retryTime >= 0) continue;
                return metadataBackupStatusInfo;
            }
            break;
        }
    }

    public static String deleteMetadataBackup(List<String> pathStrs, String project) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String pathStr : pathStrs) {
            String response = OpsService.deleteMetadataBackup(pathStr, project);
            if (sb.length() == 0) {
                sb.append(response);
                continue;
            }
            sb.append(" : ");
            sb.append(response);
        }
        return sb.toString();
    }

    public static String deleteMetadataBackup(String pathStr, String project) throws IOException {
        if (pathStr != null) {
            Path path = new Path(pathStr);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (fs.exists(path)) {
                if (!pathStr.startsWith(META_BACKUP_PATH)) {
                    return "can not delete path not in metadata backup dir " + META_BACKUP_PATH;
                }
                String rootPath = OpsService.getMetaBackupStoreDir(project);
                if (!pathStr.startsWith(rootPath) || pathStr.equals(rootPath)) {
                    return "can not delete path not in metadata backup dir " + rootPath;
                }
                fs.delete(path, true);
                log.info("Delete metadata backup {} succeed.", (Object)path.toUri());
                if (fs.listStatus(path.getParent()).length == 0) {
                    fs.delete(path.getParent(), true);
                    log.info("Delete project path {} for no metadata backup exist.", (Object)path.getParent().toUri());
                }
                return path + " delete succeed.";
            }
        }
        return pathStr + " path not exist";
    }

    public void cancelAndDeleteMetadataBackup(String rootPath, String project) throws IOException {
        MetadataBackup.cancelAndAsyncDeleteBackup(rootPath, project);
    }

    public String restoreMetadata(String path, String project, boolean afterTruncate) {
        if (project == null) {
            project = "_global";
        }
        MetadataRestore metadataRestore = new MetadataRestore(path, project, afterTruncate);
        return MetadataRestore.submitMetadataRestore(metadataRestore);
    }

    public MetadataRestoreTask.MetadataRestoreStatus getMetadataRestoreStatus(String uuid, String project) {
        if (uuid == null) {
            return null;
        }
        AsyncTaskManager taskManager = AsyncTaskManager.getInstance((String)project);
        AbstractAsyncTask asyncTask = taskManager.get("metadata_recover_task", uuid);
        if (asyncTask == null) {
            return null;
        }
        return ((MetadataRestoreTask)asyncTask).getStatus();
    }

    public static enum MetadataBackupStatus {
        IN_PROGRESS,
        SUCCEED,
        FAILED,
        CANCELED,
        UNKNOWN;

    }

    public static class MetadataBackupStatusInfo {
        private String path;
        private MetadataBackupStatus status;
        private String size;
        private String owner;
        private List<String> projects;

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public MetadataBackupStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getSize() {
            return this.size;
        }

        @Generated
        public String getOwner() {
            return this.owner;
        }

        @Generated
        public List<String> getProjects() {
            return this.projects;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }

        @Generated
        public void setStatus(MetadataBackupStatus status) {
            this.status = status;
        }

        @Generated
        public void setSize(String size) {
            this.size = size;
        }

        @Generated
        public void setOwner(String owner) {
            this.owner = owner;
        }

        @Generated
        public void setProjects(List<String> projects) {
            this.projects = projects;
        }
    }

    public static class MetadataRestore {
        public static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
        private static Future runningTask;
        private final boolean afterTruncate;
        private final String project;
        private final String path;
        private final String uuid;
        private QueryHistoryOffsetTool queryHistoryOffsetTool;
        private FavoriteRuleTool favoriteRuleTool;
        private JobInfoTool jobInfoTool;

        public MetadataRestore(String path, String project, boolean afterTruncate) {
            this.path = path;
            this.afterTruncate = afterTruncate;
            this.uuid = UUID.randomUUID().toString();
            this.project = project;
            this.init();
        }

        public static synchronized boolean hasMetadataRestoreRunning() {
            return runningTask != null;
        }

        public static String submitMetadataRestore(MetadataRestore metadataRestore) {
            if (MetadataRestore.hasMetadataRestoreRunning()) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeTool.SYSTEM_IN_METADATA_RECOVER, new Object[0]);
            }
            runningTask = EXECUTOR_SERVICE.submit(metadataRestore::doRestore);
            return metadataRestore.uuid;
        }

        public void init() {
            this.queryHistoryOffsetTool = new QueryHistoryOffsetTool();
            this.favoriteRuleTool = new FavoriteRuleTool();
            this.jobInfoTool = new JobInfoTool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRestore() {
            Class<MetadataRestore> clazz = MetadataRestore.class;
            synchronized (MetadataRestore.class) {
                AsyncTaskManager asyncTaskManager = AsyncTaskManager.getInstance((String)this.project);
                MetadataRestoreTask metadataRestoreTask = MetadataRestoreTask.newTask((String)this.uuid);
                metadataRestoreTask.setTaskAttributes((AbstractAsyncTask.TaskAttributes)new MetadataRestoreTask.MetadataRestoreTaskAttributes());
                metadataRestoreTask.setStatus(MetadataRestoreTask.MetadataRestoreStatus.IN_PROGRESS);
                metadataRestoreTask.setProject(this.project);
                asyncTaskManager.save((AbstractAsyncTask)metadataRestoreTask);
                try {
                    log.info("start to restore metadata from {}.", (Object)this.path);
                    KylinConfig config = KylinConfig.getInstanceFromEnv();
                    if ("_global".equals(this.project)) {
                        MetadataBackupStatusInfo backupStatusInfo = OpsService.getMetadataStatusInfoWithRetry(new Path(this.path + OpsService.PATH_SEP + OpsService.BACKUP_STATUS), HadoopUtil.getWorkingFileSystem(), 1);
                        backupStatusInfo.projects.forEach(relProject -> this.restoreProject((String)relProject, config, false));
                        new MetadataToolHelper().restore(config, "_global", this.path + OpsService.PATH_SEP + "core_meta", this.afterTruncate, true);
                    } else {
                        this.restoreProject(this.project, config, true);
                    }
                    log.info("restore metadata from {} succeed.", (Object)this.path);
                    metadataRestoreTask.setStatus(MetadataRestoreTask.MetadataRestoreStatus.SUCCEED);
                }
                catch (Exception e) {
                    metadataRestoreTask.setStatus(MetadataRestoreTask.MetadataRestoreStatus.FAILED);
                    log.error("restore metadata {} failed.", (Object)this.path);
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    asyncTaskManager.save((AbstractAsyncTask)metadataRestoreTask);
                    MetadataRestore.setRunningTask(null);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public void restoreProject(String realProject, KylinConfig config, boolean backup) {
            log.info("start to restore metadata for {} project.", (Object)realProject);
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().processor(() -> {
                new MetadataToolHelper().restore(config, realProject, this.path + OpsService.PATH_SEP + "core_meta", this.afterTruncate, backup);
                UnitOfWork.get().doAfterUpdate(() -> {
                    this.queryHistoryOffsetTool.restoreProject(this.path, realProject, this.afterTruncate);
                    this.favoriteRuleTool.restoreProject(this.path, realProject, this.afterTruncate);
                    this.jobInfoTool.restoreProject(this.path, realProject, this.afterTruncate);
                });
                return null;
            }).useProjectLock(true).unitName("_global").all(true).build());
            log.info("restore metadata for {} project succeed.", (Object)realProject);
        }

        @Generated
        public boolean isAfterTruncate() {
            return this.afterTruncate;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getUuid() {
            return this.uuid;
        }

        @Generated
        public QueryHistoryOffsetTool getQueryHistoryOffsetTool() {
            return this.queryHistoryOffsetTool;
        }

        @Generated
        public FavoriteRuleTool getFavoriteRuleTool() {
            return this.favoriteRuleTool;
        }

        @Generated
        public JobInfoTool getJobInfoTool() {
            return this.jobInfoTool;
        }

        @Generated
        public static Future getRunningTask() {
            return runningTask;
        }

        @Generated
        public static void setRunningTask(Future runningTask) {
            MetadataRestore.runningTask = runningTask;
        }

        @Generated
        public void setJobInfoTool(JobInfoTool jobInfoTool) {
            this.jobInfoTool = jobInfoTool;
        }
    }

    public static class MetadataBackup {
        public static final Logger log = LoggerFactory.getLogger(MetadataBackup.class);
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
        protected static final Map<String, Pair<Future, MetadataBackup>> runningTask = new ConcurrentHashMap<String, Pair<Future, MetadataBackup>>();
        private final FileSystem fs;
        private final String rootPath;
        private final Path statusPath;
        private final MetadataBackupStatusInfo statusInfo;
        private final String project;
        private String projectMetadataBackupKey;
        private MetadataToolHelper coreMetadataTool;
        private JobInfoTool jobInfoTool;
        private QueryHistoryOffsetTool queryHistoryOffsetTool;
        private FavoriteRuleTool favoriteRuleTool;

        public MetadataBackup(String dir, FileSystem fs, String user, String project) {
            this.projectMetadataBackupKey = dir;
            this.rootPath = dir + OpsService.PATH_SEP + System.currentTimeMillis();
            this.fs = fs;
            this.statusInfo = new MetadataBackupStatusInfo();
            this.statusPath = new Path(this.rootPath + OpsService.PATH_SEP + OpsService.BACKUP_STATUS);
            this.project = project;
            this.statusInfo.setOwner(user);
            this.statusInfo.setPath(this.rootPath);
            this.init();
        }

        public MetadataBackup(MetadataBackupResponse response, String project) {
            this.rootPath = response.getPath();
            this.project = project;
            this.fs = HadoopUtil.getWorkingFileSystem();
            this.statusPath = new Path(this.rootPath + OpsService.PATH_SEP + OpsService.BACKUP_STATUS);
            this.statusInfo = new MetadataBackupStatusInfo();
            this.statusInfo.setOwner(response.getOwner());
            this.statusInfo.setPath(this.rootPath);
            this.init();
        }

        private void init() {
            CancelHook hook = () -> runningTask.containsKey(this.projectMetadataBackupKey);
            this.coreMetadataTool = new MetadataToolHelper();
            this.coreMetadataTool.setHook(hook);
            this.queryHistoryOffsetTool = new QueryHistoryOffsetTool();
            this.queryHistoryOffsetTool.setHook(hook);
            this.favoriteRuleTool = new FavoriteRuleTool();
            this.favoriteRuleTool.setHook(hook);
            this.jobInfoTool = new JobInfoTool();
            this.jobInfoTool.setHook(hook);
            if (this.project == null || this.project.equals("_global")) {
                List<String> projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
                this.statusInfo.setProjects(projects);
            } else {
                this.statusInfo.setProjects(Lists.newArrayList((Object[])new String[]{this.project}));
            }
        }

        public static synchronized void cancelAndAsyncDeleteBackup(String rootPath, String project) throws IOException {
            String key = MetadataBackup.getProjectMetadataKeyFromRootPath(rootPath);
            if (runningTask.containsKey(key)) {
                Future future = (Future)runningTask.get(key).getFirst();
                MetadataBackup.cancelBackup(key);
                EXECUTOR.submit(() -> {
                    try {
                        future.get();
                        OpsService.deleteMetadataBackup(rootPath, project);
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }

        public static void cancelBackup(String projectMetadataBackupKey) throws IOException {
            Pair<Future, MetadataBackup> pair = runningTask.remove(projectMetadataBackupKey);
            ((MetadataBackup)pair.getSecond()).markCanceled();
        }

        public static String getProjectMetadataKeyFromRootPath(String rootPath) {
            return rootPath.substring(0, rootPath.lastIndexOf(47));
        }

        public void doBackupMetadata() throws Exception {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            if (this.project == null || this.project.equals("_global")) {
                List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
                this.coreMetadataTool.backupToDirectPath(config, this.rootPath + OpsService.PATH_SEP + "core_meta");
                for (ProjectInstance projectInstance : projects) {
                    this.queryHistoryOffsetTool.backup(this.rootPath, projectInstance.getName());
                    this.favoriteRuleTool.backup(this.rootPath, projectInstance.getName());
                    this.jobInfoTool.backup(this.rootPath, projectInstance.getName());
                }
            } else {
                this.coreMetadataTool.backupToDirectPath(config, this.rootPath + OpsService.PATH_SEP + "core_meta", this.project);
                this.queryHistoryOffsetTool.backup(this.rootPath, this.project);
                this.favoriteRuleTool.backup(this.rootPath, this.project);
                this.jobInfoTool.backup(this.rootPath, this.project);
            }
        }

        public long getSize() throws IOException {
            long size = 0L;
            for (FileStatus status : this.fs.listStatus(new Path(this.rootPath))) {
                if (status.isDirectory()) {
                    for (FileStatus subStatus : this.fs.listStatus(status.getPath())) {
                        size += subStatus.getLen();
                    }
                }
                size += status.getLen();
            }
            return size;
        }

        public void updateStatus() throws IOException {
            try (FSDataOutputStream fos = this.fs.create(this.statusPath, true);){
                String value = JsonUtil.writeValueAsString((Object)this.statusInfo);
                fos.writeUTF(value);
            }
        }

        public void markCanceled() throws IOException {
            this.statusInfo.setStatus(MetadataBackupStatus.CANCELED);
            this.updateStatus();
        }

        public void markInProgress() throws IOException {
            this.statusInfo.setStatus(MetadataBackupStatus.IN_PROGRESS);
            this.updateStatus();
        }

        public void markSuccess(long size) throws IOException {
            this.statusInfo.setStatus(MetadataBackupStatus.SUCCEED);
            this.statusInfo.setSize(String.valueOf(size));
            this.updateStatus();
        }

        public void markFail() {
            try {
                this.statusInfo.setStatus(MetadataBackupStatus.FAILED);
                this.updateStatus();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                log.error("mark metadata backup {} failed failed.", (Object)this.statusPath);
            }
        }

        public String startBackup() {
            if (runningTask.containsKey(this.projectMetadataBackupKey)) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeTool.METADATA_BACKUP_IS_IN_PROGRESS, new Object[0]);
            }
            Future<?> submit = EXECUTOR.submit(() -> {
                try {
                    this.markInProgress();
                    this.doBackupMetadata();
                    long size = this.getSize();
                    this.markSuccess(size);
                }
                catch (Exception e) {
                    log.error("Backup metadata to {} failed", (Object)this.rootPath);
                    log.error(e.getMessage(), (Throwable)e);
                    this.markFail();
                }
                finally {
                    runningTask.remove(this.projectMetadataBackupKey);
                }
            });
            runningTask.put(this.projectMetadataBackupKey, (Pair<Future, MetadataBackup>)new Pair(submit, (Object)this));
            return this.rootPath;
        }

        public FileSystem getFs() {
            return this.fs;
        }

        @Generated
        public String getRootPath() {
            return this.rootPath;
        }

        @Generated
        public Path getStatusPath() {
            return this.statusPath;
        }

        @Generated
        public MetadataBackupStatusInfo getStatusInfo() {
            return this.statusInfo;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getProjectMetadataBackupKey() {
            return this.projectMetadataBackupKey;
        }

        @Generated
        public MetadataToolHelper getCoreMetadataTool() {
            return this.coreMetadataTool;
        }

        @Generated
        public JobInfoTool getJobInfoTool() {
            return this.jobInfoTool;
        }

        @Generated
        public QueryHistoryOffsetTool getQueryHistoryOffsetTool() {
            return this.queryHistoryOffsetTool;
        }

        @Generated
        public FavoriteRuleTool getFavoriteRuleTool() {
            return this.favoriteRuleTool;
        }

        @Generated
        public static Map<String, Pair<Future, MetadataBackup>> getRunningTask() {
            return runningTask;
        }

        @Generated
        public void setQueryHistoryOffsetTool(QueryHistoryOffsetTool queryHistoryOffsetTool) {
            this.queryHistoryOffsetTool = queryHistoryOffsetTool;
        }
    }
}

