/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.util.Strings;

public final class InstantFormatter {
    private static final FormatterFactory[] FORMATTER_FACTORIES = new FormatterFactory[]{new Log4jFixedFormatterFactory(), new Log4jFastFormatterFactory(), new JavaDateTimeFormatterFactory()};
    private final Formatter formatter = Arrays.stream(FORMATTER_FACTORIES).map(formatterFactory -> formatterFactory.createIfSupported(builder.getPattern(), builder.getLocale(), builder.getTimeZone())).filter(Objects::nonNull).findFirst().orElseThrow(() -> new AssertionError((Object)"could not find a matching formatter"));

    private InstantFormatter(Builder builder) {
    }

    public String format(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        StringBuilder stringBuilder = new StringBuilder();
        this.formatter.format(instant, stringBuilder);
        return stringBuilder.toString();
    }

    public void format(Instant instant, StringBuilder stringBuilder) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(stringBuilder, "stringBuilder");
        this.formatter.format(instant, stringBuilder);
    }

    public boolean isInstantMatching(Instant instant1, Instant instant2) {
        return this.formatter.isInstantMatching(instant1, instant2);
    }

    public Class<?> getInternalImplementationClass() {
        return this.formatter.getInternalImplementationClass();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean patternSupported(String pattern, Locale locale, TimeZone timeZone, Formatter formatter) {
        DateTimeFormatter javaFormatter = DateTimeFormatter.ofPattern(pattern).withLocale(locale).withZone(timeZone.toZoneId());
        MutableInstant instant = new MutableInstant();
        instant.initFromEpochSecond(1621280470L, 123456789);
        String expectedFormat = javaFormatter.format((TemporalAccessor)instant);
        StringBuilder stringBuilder = new StringBuilder();
        formatter.format((Instant)instant, stringBuilder);
        String actualFormat = stringBuilder.toString();
        return expectedFormat.equals(actualFormat);
    }

    private static final class Log4jFixedFormatter
    implements Formatter {
        private final FixedDateFormat formatter;
        private final char[] buffer;

        private Log4jFixedFormatter(FixedDateFormat formatter) {
            this.formatter = formatter;
            this.buffer = new char[formatter.getFormat().length()];
        }

        @Override
        public Class<?> getInternalImplementationClass() {
            return FixedDateFormat.class;
        }

        @Override
        public void format(Instant instant, StringBuilder stringBuilder) {
            int length = this.formatter.formatInstant(instant, this.buffer, 0);
            stringBuilder.append(this.buffer, 0, length);
        }

        @Override
        public boolean isInstantMatching(Instant instant1, Instant instant2) {
            return this.formatter.isEquivalent(instant1.getEpochSecond(), instant1.getNanoOfSecond(), instant2.getEpochSecond(), instant2.getNanoOfSecond());
        }
    }

    private static final class Log4jFixedFormatterFactory
    implements FormatterFactory {
        private Log4jFixedFormatterFactory() {
        }

        @Override
        public Formatter createIfSupported(String pattern, Locale locale, TimeZone timeZone) {
            FixedDateFormat internalFormatter = FixedDateFormat.createIfSupported((String[])new String[]{pattern, timeZone.getID()});
            if (internalFormatter == null) {
                return null;
            }
            Log4jFixedFormatter formatter = new Log4jFixedFormatter(internalFormatter);
            boolean patternSupported = InstantFormatter.patternSupported(pattern, locale, timeZone, formatter);
            return patternSupported ? formatter : null;
        }
    }

    private static final class Log4jFastFormatter
    implements Formatter {
        private final FastDateFormat formatter;
        private final Calendar calendar;

        private Log4jFastFormatter(String pattern, Locale locale, TimeZone timeZone) {
            this.formatter = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            this.calendar = Calendar.getInstance(timeZone, locale);
        }

        @Override
        public Class<?> getInternalImplementationClass() {
            return FastDateFormat.class;
        }

        @Override
        public void format(Instant instant, StringBuilder stringBuilder) {
            this.calendar.setTimeInMillis(instant.getEpochMillisecond());
            this.formatter.format(this.calendar, (Appendable)stringBuilder);
        }

        @Override
        public boolean isInstantMatching(Instant instant1, Instant instant2) {
            return instant1.getEpochMillisecond() == instant2.getEpochMillisecond();
        }
    }

    private static final class Log4jFastFormatterFactory
    implements FormatterFactory {
        private Log4jFastFormatterFactory() {
        }

        @Override
        public Formatter createIfSupported(String pattern, Locale locale, TimeZone timeZone) {
            Log4jFastFormatter formatter = new Log4jFastFormatter(pattern, locale, timeZone);
            boolean patternSupported = InstantFormatter.patternSupported(pattern, locale, timeZone, formatter);
            return patternSupported ? formatter : null;
        }
    }

    private static final class JavaDateTimeFormatter
    implements Formatter {
        private final DateTimeFormatter formatter;
        private final MutableInstant mutableInstant;

        private JavaDateTimeFormatter(String pattern, Locale locale, TimeZone timeZone) {
            this.formatter = DateTimeFormatter.ofPattern(pattern).withLocale(locale).withZone(timeZone.toZoneId());
            this.mutableInstant = new MutableInstant();
        }

        @Override
        public Class<?> getInternalImplementationClass() {
            return DateTimeFormatter.class;
        }

        @Override
        public void format(Instant instant, StringBuilder stringBuilder) {
            if (instant instanceof MutableInstant) {
                this.formatMutableInstant((MutableInstant)instant, stringBuilder);
            } else {
                this.formatInstant(instant, stringBuilder);
            }
        }

        private void formatMutableInstant(MutableInstant instant, StringBuilder stringBuilder) {
            this.formatter.formatTo((TemporalAccessor)instant, stringBuilder);
        }

        private void formatInstant(Instant instant, StringBuilder stringBuilder) {
            this.mutableInstant.initFrom(instant);
            this.formatMutableInstant(this.mutableInstant, stringBuilder);
        }

        @Override
        public boolean isInstantMatching(Instant instant1, Instant instant2) {
            return instant1.getEpochSecond() == instant2.getEpochSecond() && instant1.getNanoOfSecond() == instant2.getNanoOfSecond();
        }
    }

    private static final class JavaDateTimeFormatterFactory
    implements FormatterFactory {
        private JavaDateTimeFormatterFactory() {
        }

        @Override
        public Formatter createIfSupported(String pattern, Locale locale, TimeZone timeZone) {
            return new JavaDateTimeFormatter(pattern, locale, timeZone);
        }
    }

    private static interface Formatter {
        public Class<?> getInternalImplementationClass();

        public void format(Instant var1, StringBuilder var2);

        public boolean isInstantMatching(Instant var1, Instant var2);
    }

    private static interface FormatterFactory {
        public Formatter createIfSupported(String var1, Locale var2, TimeZone var3);
    }

    public static final class Builder {
        private String pattern;
        private Locale locale = Locale.getDefault();
        private TimeZone timeZone = TimeZone.getDefault();

        private Builder() {
        }

        public String getPattern() {
            return this.pattern;
        }

        public Builder setPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public Builder setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public InstantFormatter build() {
            this.validate();
            return new InstantFormatter(this);
        }

        private void validate() {
            if (Strings.isBlank((String)this.pattern)) {
                throw new IllegalArgumentException("blank pattern");
            }
            Objects.requireNonNull(this.locale, "locale");
            Objects.requireNonNull(this.timeZone, "timeZone");
        }
    }
}

