/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import java.io.Serializable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.util.UnsupportedSparkFunctionException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.KapFunctions$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BitmapUuidToArray;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IntersectCountByCol;
import org.apache.spark.sql.catalyst.expressions.SubtractBitmapAllValues;
import org.apache.spark.sql.catalyst.expressions.SubtractBitmapCount;
import org.apache.spark.sql.catalyst.expressions.SubtractBitmapUUID;
import org.apache.spark.sql.catalyst.expressions.SubtractBitmapValue;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SparderTypeUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ExpressionConverter$ {
    public static ExpressionConverter$ MODULE$;
    private final HashSet<String> sparkUdfSet;
    private final HashSet<String> bitmapUDF;

    static {
        new ExpressionConverter$();
    }

    private HashSet<String> sparkUdfSet() {
        return this.sparkUdfSet;
    }

    private HashSet<String> bitmapUDF() {
        return this.bitmapUDF;
    }

    public Object convert(SqlTypeName sqlTypeName, RelDataType relDataType, SqlKind op, String opName, Seq<Object> children) {
        Column column;
        SqlKind sqlKind = op;
        if (SqlKind.IS_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = KapFunctions$.MODULE$.k_lit(children.head()).isNull();
        } else if (SqlKind.IS_NOT_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = KapFunctions$.MODULE$.k_lit(children.head()).isNotNull();
        } else if (SqlKind.LIKE.equals(sqlKind)) {
            Column column2;
            if (children.length() == 3) {
                if (!(children.last() instanceof String) || ((String)children.last()).length() != 1) {
                    throw new UnsupportedOperationException("Invalid paramters for LIKE ESCAPE, expecting a single char for ESCAPE");
                }
                char escapeChar = ((String)children.last()).charAt(0);
                column2 = KapFunctions$.MODULE$.k_like(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(children.apply(1)), escapeChar);
            } else if (children.length() == 2) {
                column2 = KapFunctions$.MODULE$.k_like(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(children.last()), KapFunctions$.MODULE$.k_like$default$3());
            } else {
                throw new UnsupportedOperationException("Invalid paramters for LIKE, expecting LIKE ... , LIKE ... ESCAPE ... ");
            }
            column = column2;
        } else if (SqlKind.SIMILAR.equals(sqlKind)) {
            Column column3;
            if (children.size() == 2) {
                column3 = KapFunctions$.MODULE$.k_similar(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(children.last()));
            } else if (children.size() == 3) {
                Object object;
                if (!(children.last() instanceof String) || ((String)children.last()).length() != 1) {
                    throw new UnsupportedOperationException("Invalid paramters for SIMILAR TO ESCAPE, expecting a single char for ESCAPE");
                }
                char escapeChar = ((String)children.last()).charAt(0);
                if (!new StringOps(Predef$.MODULE$.augmentString((String)children.apply(1))).contains((Object)BoxesRunTime.boxToCharacter((char)escapeChar))) {
                    object = children.apply(1);
                } else {
                    char[] charArray = ((String)children.apply(1)).toCharArray();
                    BooleanRef escapeCharReplaced = BooleanRef.create((boolean)false);
                    StringBuilder stringDeletedEscape = new StringBuilder();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), charArray.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        if (charArray[i] != escapeChar) {
                            stringDeletedEscape.append(charArray[i]);
                            escapeCharReplaced$1.elem = false;
                        } else if (!escapeCharReplaced$1.elem) {
                            stringDeletedEscape.append("\\");
                            escapeCharReplaced$1.elem = true;
                        } else {
                            stringDeletedEscape.append(escapeChar);
                            escapeCharReplaced$1.elem = false;
                        }
                    });
                    object = stringDeletedEscape.toString();
                }
                Object stringReplacedWithEscapeChar = object;
                column3 = KapFunctions$.MODULE$.k_similar(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(stringReplacedWithEscapeChar));
            } else {
                throw new UnsupportedOperationException("Invalid paramters for SIMILAR TO, expecting SIMILAR TO ... , SIMILAR TO ... ESCAPE ... ");
            }
            column = column3;
        } else if (SqlKind.MINUS_PREFIX.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            column = functions$.MODULE$.negate(KapFunctions$.MODULE$.k_lit(children.head()));
        } else if (SqlKind.IN.equals(sqlKind)) {
            Column column4;
            Tuple2 tuple2 = ((TraversableLike)children.map((Function1 & Serializable & scala.Serializable)c -> KapFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$3(x0$1)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq columns = (Seq)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)columns, (Object)values);
            Tuple2 tuple23 = tuple22;
            Seq columns2 = (Seq)tuple23._1();
            Seq values2 = (Seq)tuple23._2();
            if (columns2.size() > 1) {
                column4 = KapFunctions$.MODULE$.in((Expression)CreateStruct$.MODULE$.apply(columns2), (Seq<Expression>)values2);
            } else {
                Seq values3 = (Seq)((TraversableLike)children.drop(1)).map((Function1 & Serializable & scala.Serializable)c -> KapFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom());
                column4 = KapFunctions$.MODULE$.in(KapFunctions$.MODULE$.k_lit(children.head()).expr(), (Seq<Expression>)values3);
            }
            column = column4;
        } else if (SqlKind.NOT_IN.equals(sqlKind)) {
            Column column5;
            Tuple2 tuple2 = ((TraversableLike)children.map((Function1 & Serializable & scala.Serializable)c -> KapFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$6(x0$2)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq columns = (Seq)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)columns, (Object)values);
            Tuple2 tuple25 = tuple24;
            Seq columns3 = (Seq)tuple25._1();
            Seq values4 = (Seq)tuple25._2();
            if (columns3.size() > 1) {
                column5 = functions$.MODULE$.not(KapFunctions$.MODULE$.in((Expression)CreateStruct$.MODULE$.apply(columns3), (Seq<Expression>)values4));
            } else {
                Seq values5 = (Seq)((TraversableLike)children.drop(1)).map((Function1 & Serializable & scala.Serializable)c -> KapFunctions$.MODULE$.k_lit(c).expr(), Seq$.MODULE$.canBuildFrom());
                column5 = functions$.MODULE$.not(KapFunctions$.MODULE$.in(KapFunctions$.MODULE$.k_lit(children.head()).expr(), (Seq<Expression>)values5));
            }
            column = column5;
        } else if (SqlKind.DIVIDE.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 2);
            column = KapFunctions$.MODULE$.k_lit(children.head()).divide((Object)KapFunctions$.MODULE$.k_lit(children.last()));
        } else if (SqlKind.CASE.equals(sqlKind)) {
            Seq evens = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$8(p)))).map((Function1 & Serializable & scala.Serializable)p -> KapFunctions$.MODULE$.k_lit(p._1()), Seq$.MODULE$.canBuildFrom());
            Seq odds = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExpressionConverter$.$anonfun$convert$10(p)))).map((Function1 & Serializable & scala.Serializable)p -> KapFunctions$.MODULE$.k_lit(p._1()), Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(evens.length() == odds.length() + 1);
            Seq zip = (Seq)evens.zip((GenIterable)odds, Seq$.MODULE$.canBuildFrom());
            ObjectRef column6 = ObjectRef.create(null);
            if (zip.nonEmpty()) {
                column6.elem = functions$.MODULE$.when((Column)((Tuple2)zip.head())._1(), ((Tuple2)zip.head())._2());
                ((IterableLike)zip.drop(1)).foreach((Function1 & Serializable & scala.Serializable)p -> {
                    column6.elem = ((Column)column6.elem).when((Column)p._1(), p._2());
                    return BoxedUnit.UNIT;
                });
            }
            column = ((Column)column6.elem).otherwise(evens.last());
        } else if (SqlKind.EXTRACT.equals(sqlKind)) {
            Column column7;
            String timeUnit = (String)children.head();
            Object inputAsTS = children.apply(1);
            String string = timeUnit;
            if ("YEAR".equals(string)) {
                column7 = functions$.MODULE$.year(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("QUARTER".equals(string)) {
                column7 = functions$.MODULE$.quarter(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("MONTH".equals(string)) {
                column7 = functions$.MODULE$.month(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("WEEK".equals(string)) {
                column7 = functions$.MODULE$.weekofyear(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DOY".equals(string)) {
                column7 = functions$.MODULE$.dayofyear(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DAY".equals(string)) {
                column7 = functions$.MODULE$.dayofmonth(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("DOW".equals(string)) {
                column7 = functions$.MODULE$.dayofweek(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("HOUR".equals(string)) {
                column7 = functions$.MODULE$.hour(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("MINUTE".equals(string)) {
                column7 = functions$.MODULE$.minute(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else if ("SECOND".equals(string)) {
                column7 = functions$.MODULE$.second(KapFunctions$.MODULE$.k_lit(inputAsTS));
            } else {
                throw new UnsupportedSparkFunctionException(new java.lang.StringBuilder(21).append("Unsupported function ").append(timeUnit).toString());
            }
            column = column7;
        } else if (SqlKind.REINTERPRET.equals(sqlKind)) {
            column = KapFunctions$.MODULE$.k_lit(children.head());
        } else if (SqlKind.CAST.equals(sqlKind)) {
            DataType goalType = SparderTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType);
            column = KapFunctions$.MODULE$.k_lit(children.head()).cast(goalType);
        } else if (SqlKind.TRIM.equals(sqlKind)) {
            Column column8;
            if (children.length() == 3) {
                Column column9;
                Object object = children.head();
                if ("TRAILING".equals(object)) {
                    column9 = functions$.MODULE$.rtrim(KapFunctions$.MODULE$.k_lit(children.apply(2)), (String)children.apply(1));
                } else if ("LEADING".equals(object)) {
                    column9 = functions$.MODULE$.ltrim(KapFunctions$.MODULE$.k_lit(children.apply(2)), (String)children.apply(1));
                } else if ("BOTH".equals(object)) {
                    column9 = functions$.MODULE$.trim(KapFunctions$.MODULE$.k_lit(children.apply(2)), (String)children.apply(1));
                } else {
                    throw new MatchError(object);
                }
                column8 = column9;
            } else {
                column8 = functions$.MODULE$.trim(KapFunctions$.MODULE$.k_lit(children.head()));
            }
            column = column8;
        } else if (SqlKind.OTHER.equals(sqlKind)) {
            String funcName = opName.toLowerCase();
            String string = funcName;
            if (!"||".equals(string)) {
                throw new UnsupportedOperationException(new java.lang.StringBuilder(21).append("Unsupported function ").append(funcName).toString());
            }
            Column column10 = functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(children.apply(1))}));
            column = column10;
        } else if (SqlKind.OTHER_FUNCTION.equals(sqlKind)) {
            Column column11;
            String funcName = opName.toLowerCase();
            String string = funcName;
            if ("abs".equals(string)) {
                column11 = functions$.MODULE$.abs(KapFunctions$.MODULE$.k_lit(children.head()).cast(SparderTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType)));
            } else if ("truncate".equals(string)) {
                column11 = children.size() == 1 ? KapFunctions$.MODULE$.k_truncate(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)0))) : KapFunctions$.MODULE$.k_truncate(KapFunctions$.MODULE$.k_lit(children.head()), KapFunctions$.MODULE$.k_lit(children.apply(1)));
            } else {
                boolean bl = "to_char".equals(string) ? true : "date_format".equals(string);
                if (bl) {
                    String string2 = KapFunctions$.MODULE$.k_lit(children.apply(1)).toString().toUpperCase();
                    String string3 = "YEAR".equals(string2) ? "y" : ("MONTH".equals(string2) ? "M" : ("DAY".equals(string2) ? "d" : ("HOUR".equals(string2) ? "h" : ("MINUTE".equals(string2) ? "m" : ("MINUTES".equals(string2) ? "m" : ("SECOND".equals(string2) ? "s" : ("SECONDS".equals(string2) ? "s" : KapFunctions$.MODULE$.k_lit(children.apply(1)).toString())))))));
                    String part = string3;
                    column11 = functions$.MODULE$.date_format(KapFunctions$.MODULE$.k_lit(children.head()), part);
                } else if (this.sparkUdfSet().contains((Object)string)) {
                    column11 = functions$.MODULE$.call_udf(string, (Seq)children.map((Function1 & Serializable & scala.Serializable)literal -> KapFunctions$.MODULE$.k_lit(literal), Seq$.MODULE$.canBuildFrom()));
                } else if (this.bitmapUDF().contains((Object)string)) {
                    Column column12;
                    String string4 = string;
                    if ("intersect_count_by_col".equals(string4)) {
                        column12 = new Column((Expression)new IntersectCountByCol((Seq<Expression>)((Column)children.head()).expr().children()));
                    } else {
                        boolean bl2 = "subtract_bitmap_value".equals(string4) ? true : "subtract_bitmap_uuid_value_all".equals(string4);
                        if (bl2) {
                            column12 = new Column((Expression)new SubtractBitmapAllValues(((Column)children.head()).expr(), ((Column)children.last()).expr(), KylinConfig.getInstanceFromEnv().getBitmapValuesUpperBound()));
                        } else {
                            boolean bl3 = "subtract_bitmap_uuid".equals(string4) ? true : "subtract_bitmap_uuid_distinct".equals(string4);
                            if (bl3) {
                                column12 = new Column((Expression)new SubtractBitmapUUID(((Column)children.head()).expr(), ((Column)children.last()).expr()));
                            } else if ("subtract_bitmap_uuid_count".equals(string4)) {
                                column12 = new Column((Expression)new SubtractBitmapCount(((Column)children.head()).expr(), ((Column)children.last()).expr()));
                            } else if ("subtract_bitmap_uuid_value".equals(string4)) {
                                Expression left = ((Column)children.head()).expr();
                                Expression right = ((Column)ImplicitConversions$.MODULE$.seq$u0020AsJavaList(children).get(1)).expr();
                                Object limitArg = ImplicitConversions$.MODULE$.seq$u0020AsJavaList(children).get(2);
                                Object offsetArg = ImplicitConversions$.MODULE$.seq$u0020AsJavaList(children).get(3);
                                int limit = new StringOps(Predef$.MODULE$.augmentString(limitArg.toString())).toInt();
                                int offset = new StringOps(Predef$.MODULE$.augmentString(offsetArg.toString())).toInt();
                                if (limit < 0 || offset < 0) {
                                    throw new UnsupportedOperationException("both limit and offset must be >= 0");
                                }
                                column12 = new Column((Expression)new SubtractBitmapValue(left, right, limit, offset, KylinConfig.getInstanceFromEnv().getBitmapValuesUpperBound()));
                            } else if ("bitmap_uuid_to_array".equals(string4)) {
                                column12 = new Column((Expression)new BitmapUuidToArray(((Column)children.head()).expr()));
                            } else {
                                throw new MatchError((Object)string4);
                            }
                        }
                    }
                    column11 = column12;
                } else {
                    throw new UnsupportedOperationException(new java.lang.StringBuilder(21).append("Unsupported function ").append(funcName).toString());
                }
            }
            column = column11;
        } else if (SqlKind.CEIL.equals(sqlKind)) {
            Column column13;
            if (children.length() == 1) {
                column13 = functions$.MODULE$.ceil(KapFunctions$.MODULE$.k_lit(children.head()));
            } else if (children.length() == 2) {
                column13 = functions$.MODULE$.call_udf("ceil_datetime", (Seq)children.map((Function1 & Serializable & scala.Serializable)literal -> KapFunctions$.MODULE$.k_lit(literal), Seq$.MODULE$.canBuildFrom()));
            } else {
                throw new UnsupportedOperationException("ceil must provide one or two parameters under sparder");
            }
            column = column13;
        } else if (SqlKind.FLOOR.equals(sqlKind)) {
            Column column14;
            if (children.length() == 1) {
                column14 = functions$.MODULE$.floor(KapFunctions$.MODULE$.k_lit(children.head()));
            } else if (children.length() == 2) {
                column14 = functions$.MODULE$.date_trunc(children.apply(1).toString(), KapFunctions$.MODULE$.k_lit(children.head()));
            } else {
                throw new UnsupportedOperationException("floor must provide one or two parameters under sparder");
            }
            column = column14;
        } else if (SqlKind.ARRAY_VALUE_CONSTRUCTOR.equals(sqlKind)) {
            column = functions$.MODULE$.array((Seq)children.map((Function1 & Serializable & scala.Serializable)child -> KapFunctions$.MODULE$.k_lit(child), Seq$.MODULE$.canBuildFrom()));
        } else if (SqlKind.ROW.equals(sqlKind)) {
            column = functions$.MODULE$.call_udf("named_struct", (Seq)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object child = tuple2._1();
                int i = tuple2._2$mcI$sp();
                Seq seq = (Seq)new .colon.colon((Object)functions$.MODULE$.lit((Object)new java.lang.StringBuilder(3).append("col").append(i + 1).toString()), (List)new .colon.colon((Object)KapFunctions$.MODULE$.k_lit(child), (List)Nil$.MODULE$));
                return seq;
            }, Seq$.MODULE$.canBuildFrom()));
        } else if (SqlKind.IS_NOT_DISTINCT_FROM.equals(sqlKind)) {
            column = KapFunctions$.MODULE$.k_lit(children.head()).eqNullSafe((Object)KapFunctions$.MODULE$.k_lit(children.apply(1)));
        } else if (SqlKind.IS_TRUE.equals(sqlKind)) {
            Column col = KapFunctions$.MODULE$.k_lit(children.head());
            column = col.isNotNull().$amp$amp((Object)col);
        } else if (SqlKind.IS_NOT_TRUE.equals(sqlKind)) {
            Column col = KapFunctions$.MODULE$.k_lit(children.head());
            column = col.isNull().$bar$bar((Object)col.unary_$bang());
        } else if (SqlKind.IS_FALSE.equals(sqlKind)) {
            Column col = KapFunctions$.MODULE$.k_lit(children.head());
            column = col.isNotNull().$amp$amp((Object)col.unary_$bang());
        } else if (SqlKind.IS_NOT_FALSE.equals(sqlKind)) {
            Column col = KapFunctions$.MODULE$.k_lit(children.head());
            column = col.isNull().$bar$bar((Object)col);
        } else if (SqlKind.POSITION.equals(sqlKind)) {
            column = functions$.MODULE$.call_udf("position", (Seq)children.map((Function1 & Serializable & scala.Serializable)literal -> KapFunctions$.MODULE$.k_lit(literal), Seq$.MODULE$.canBuildFrom()));
        } else if (SqlKind.ITEM.equals(sqlKind)) {
            column = functions$.MODULE$.element_at(KapFunctions$.MODULE$.k_lit(children.head()), (Object)KapFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)children.apply(1)) + 1))));
        } else if (SqlKind.IF.equals(sqlKind)) {
            column = functions$.MODULE$.call_udf("if", (Seq)children.map((Function1 & Serializable & scala.Serializable)literal -> KapFunctions$.MODULE$.k_lit(literal), Seq$.MODULE$.canBuildFrom()));
        } else if (SqlKind.NVL.equals(sqlKind)) {
            column = functions$.MODULE$.call_udf("ifnull", (Seq)children.map((Function1 & Serializable & scala.Serializable)literal -> KapFunctions$.MODULE$.k_lit(literal), Seq$.MODULE$.canBuildFrom()));
        } else {
            throw new UnsupportedOperationException(sqlKind.toString());
        }
        return column;
    }

    public static final /* synthetic */ boolean $anonfun$convert$3(Expression x0$1) {
        Expression expression = x0$1;
        boolean bl = expression instanceof AttributeReference ? true : expression instanceof UnresolvedAttribute;
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$convert$6(Expression x0$2) {
        Expression expression = x0$2;
        boolean bl = expression instanceof AttributeReference ? true : expression instanceof UnresolvedAttribute;
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$convert$8(Tuple2 p) {
        return p._2$mcI$sp() % 2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$convert$10(Tuple2 p) {
        return p._2$mcI$sp() % 2 == 1;
    }

    private ExpressionConverter$() {
        MODULE$ = this;
        this.sparkUdfSet = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ascii", "base64", "btrim", "chr", "char", "char_length", "character_length", "concat_ws", "decode", "encode", "find_in_set", "initcap", "initcapb", "instr", "lcase", "length", "left", "levenshtein", "locate", "lower", "lpad", "ltrim", "overlay", "replace", "regexp_extract", "regexp_like", "right", "rlike", "rpad", "repeat", "rtrim", "sentences", "space", "split", "split_part", "strpos", "substring_index", "substring", "substr", "ucase", "unbase64", "upper", "add_months", "current_date", "current_timestamp", "date_add", "datediff", "date_format", "date_part", "date_sub", "date_trunc", "from_utc_timestamp", "from_unixtime", "months_between", "to_date", "to_timestamp", "to_utc_timestamp", "trunc", "unix_timestamp", "weekofyear", "_ymdint_between", "acos", "asin", "atan", "atan2", "bround", "cbrt", "cos", "cosh", "cot", "conv", "degrees", "exp", "expm1", "factorial", "hypot", "ln", "log", "log1p", "log10", "log2", "pi", "power", "pow", "radians", "rint", "round", "sign", "sin", "sinh", "tan", "tanh", "current_database", "input_file_block_length", "input_file_block_start", "input_file_name", "monotonically_increasing_id", "now", "spark_partition_id", "uuid", "crc32", "explode", "if", "ifnull", "isnull", "md5", "nvl", "sha", "sha1", "sha2", "concat", "size"}));
        this.bitmapUDF = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intersect_count_by_col", "subtract_bitmap_value", "subtract_bitmap_uuid", "bitmap_uuid_to_array", "subtract_bitmap_uuid_count", "subtract_bitmap_uuid_distinct", "subtract_bitmap_uuid_value_all", "subtract_bitmap_uuid_value"}));
    }
}

