/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.kylin.common.KylinConfig;
import org.apache.spark.CleanerListener;
import org.apache.spark.ContextCleaner;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.resource.ResourceProfileManager;
import org.apache.spark.scheduler.ContainerInitializeListener$;
import org.apache.spark.scheduler.ContainerSchedulerManager$;
import org.apache.spark.scheduler.ExecutorListener;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u0016,\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!A!\u0002\u00139\u0006\"B/\u0001\t\u0003q\u0006bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007_\u0002\u0001\u000b\u0011B4\t\u000fA\u0004!\u0019!C\u0005c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0003x\u0011\u0019i\b\u0001)A\u0005q\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\t\u0001\u0001\u0006I!!\u0001\t\u0011\u0005M\u0001A1A\u0005\n}D\u0001\"!\u0006\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033A\u0001\"!\u000f\u0001A\u0003%\u00111\u0004\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"!\u0012\u0001A\u0003%\u0011q\b\u0005\t\u0003\u000f\u0002!\u0019!C\u0005o\"9\u0011\u0011\n\u0001!\u0002\u0013A\b\u0002CA&\u0001\t\u0007I\u0011B<\t\u000f\u00055\u0003\u0001)A\u0005q\"9\u0011q\n\u0001\u0005\u0002\u0005u\u0002\u0002CA)\u0001\t\u0007I\u0011B<\t\u000f\u0005M\u0003\u0001)A\u0005q\"1\u0011Q\u000b\u0001\u0005\u0002]Dq!a\u0016\u0001\t\u0003\tI\u0006\u0003\u0004\u0002b\u0001!\ta\u001e\u0005\b\u0003G\u0002A\u0011AA\u001f\u0011\u0019\t)\u0007\u0001C\u0001o\"9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003#\u0003A\u0011AAJ\u000f%\t)jKA\u0001\u0012\u0003\t9J\u0002\u0005+W\u0005\u0005\t\u0012AAM\u0011\u0019iv\u0005\"\u0001\u0002\u001c\"I\u0011QT\u0014\u0012\u0002\u0013\u0005\u0011q\u0014\u0002\u001a\u0007>tG/Y5oKJ\u001c6\r[3ek2,'/T1oC\u001e,'O\u0003\u0002-[\u0005I1o\u00195fIVdWM\u001d\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011c\u0001\u00016wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P \u000e\u0003uR!AP\u0017\u0002\u0011%tG/\u001a:oC2L!\u0001Q\u001f\u0003\u000f1{wmZ5oO\u000611\r\\5f]R\u0004\"a\u0011#\u000e\u00035J!!R\u0017\u00031\u0015CXmY;u_J\fE\u000e\\8dCRLwN\\\"mS\u0016tG/A\u0006mSN$XM\\3s\u0005V\u001c\bC\u0001%J\u001b\u0005Y\u0013B\u0001&,\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\u0018\u0001B2p]\u001a\u0004\"aQ'\n\u00059k#!C*qCJ\\7i\u001c8g\u0003\u001d\u0019G.Z1oKJ\u00042AN)T\u0013\t\u0011vG\u0001\u0004PaRLwN\u001c\t\u0003\u0007RK!!V\u0017\u0003\u001d\r{g\u000e^3yi\u000ecW-\u00198fe\u00061\"/Z:pkJ\u001cW\r\u0015:pM&dW-T1oC\u001e,'\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[[\u0005A!/Z:pkJ\u001cW-\u0003\u0002]3\n1\"+Z:pkJ\u001cW\r\u0015:pM&dW-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0007?\u0002\f'm\u00193\u0011\u0005!\u0003\u0001\"B!\u0007\u0001\u0004\u0011\u0005\"\u0002$\u0007\u0001\u00049\u0005\"B&\u0007\u0001\u0004a\u0005bB(\u0007!\u0003\u0005\r\u0001\u0015\u0005\u0006-\u001a\u0001\raV\u0001\fWfd\u0017N\\\"p]\u001aLw-F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0004d_6lwN\u001c\u0006\u0003Y>\nQa[=mS:L!A\\5\u0003\u0017-KH.\u001b8D_:4\u0017nZ\u0001\rWfd\u0017N\\\"p]\u001aLw\rI\u0001\u0011Kb,7-\u001e;pe2K7\u000f^3oKJ,\u0012A\u001d\t\u0003\u0011NL!\u0001^\u0016\u0003!\u0015CXmY;u_Jd\u0015n\u001d;f]\u0016\u0014\u0018!E3yK\u000e,Ho\u001c:MSN$XM\\3sA\u0005\u0001\u0012N\\5uS\u0006dW\t_3dkR|'o]\u000b\u0002qB\u0011a'_\u0005\u0003u^\u00121!\u00138u\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000fI\u0001\u0011I\u00164\u0017-\u001e7u!J|g-\u001b7f\u0013\u0012\f\u0011\u0003Z3gCVdG\u000f\u0015:pM&dW-\u00133!\u0003\u0019rW/\\#yK\u000e,Ho\u001c:t)\u0006\u0014x-\u001a;QKJ\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0017\nZ\u000b\u0003\u0003\u0003\u0001b!a\u0001\u0002\u000eaDXBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u000f5,H/\u00192mK*\u0019\u00111B\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0005\u0015!a\u0002%bg\"l\u0015\r]\u0001(]VlW\t_3dkR|'o\u001d+be\u001e,G\u000fU3s%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&#\u0007%A\u0015ok6dunY1mSRL\u0018i^1sKR\u000b7o[:QKJ\u0014Vm]8ve\u000e,\u0007K]8gS2,\u0017\nZ\u0001+]VlGj\\2bY&$\u00180Q<be\u0016$\u0016m]6t!\u0016\u0014(+Z:pkJ\u001cW\r\u0015:pM&dW-\u00133!\u0003i\u0011\b/\u00133U_\"{7\u000f\u001e+p\u0019>\u001c\u0017\r\u001c+bg.\u001cu.\u001e8u+\t\tY\u0002E\u0004\u0002\u001e\u0005-\u00020!\r\u000f\t\u0005}\u0011q\u0005\t\u0004\u0003C9TBAA\u0012\u0015\r\t)cM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%r'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyCA\u0002NCBT1!!\u000b8!\u001d\ti\"a\u000b\u00024a\u0004B!!\b\u00026%!\u0011qGA\u0018\u0005\u0019\u0019FO]5oO\u0006Y\"\u000f]%e)>Dun\u001d;U_2{7-\u00197UCN\\7i\\;oi\u0002\na\"\u001a=fGV$xN]'f[>\u0014\u00180\u0006\u0002\u0002@A\u0019a'!\u0011\n\u0007\u0005\rsG\u0001\u0003M_:<\u0017aD3yK\u000e,Ho\u001c:NK6|'/\u001f\u0011\u0002+\u0015DXmY;u_J|eM\u001a%fCBlU-\\8ss\u00061R\r_3dkR|'o\u00144g\u0011\u0016\f\u0007/T3n_JL\b%\u0001\ffq\u0016\u001cW\u000f^8s\u001b\u0016lwN]=Pm\u0016\u0014\b.Z1e\u0003])\u00070Z2vi>\u0014X*Z7pef|e/\u001a:iK\u0006$\u0007%A\thKR,\u00050Z2vi>\u0014X*Z7pef\fQ\"\u001a=fGV$xN]\"pe\u0016\u001c\u0018AD3yK\u000e,Ho\u001c:D_J,7\u000fI\u0001\u0011O\u0016$X\t_3dkR|'oQ8sKN\fQa\u001d;beR$\"!a\u0017\u0011\u0007Y\ni&C\u0002\u0002`]\u0012A!\u00168ji\u0006\u0019r-\u001a;BY2,\u00050Z2vi>\u00148i\u001c:fg\u0006!r-\u001a;BY2,\u00050Z2vi>\u0014X*Z7pef\f\u0001cZ3u\u000bb,7-\u001e;pe\u000e{WO\u001c;\u0002\u001fI,\u0017/^3ti\u0016CXmY;u_J$B!a\u001b\u0002rA\u0019a'!\u001c\n\u0007\u0005=tGA\u0004C_>dW-\u00198\t\r\u0005M4\u00051\u0001y\u0003\rqW/\\\u0001\u0010e\u0016dW-Y:f\u000bb,7-\u001e;peR1\u0011\u0011PAF\u0003\u001b\u0003b!a\u001f\u0002\u0006\u0006Mb\u0002BA?\u0003\u0003sA!!\t\u0002\u0000%\t\u0001(C\u0002\u0002\u0004^\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0006%%aA*fc*\u0019\u00111Q\u001c\t\r\u0005MD\u00051\u0001y\u0011\u001d\ty\t\na\u0001\u0003W\nQAZ8sG\u0016\fAbZ3u#V,W/\u001a(b[\u0016,\"!a\r\u00023\r{g\u000e^1j]\u0016\u00148k\u00195fIVdWM]'b]\u0006<WM\u001d\t\u0003\u0011\u001e\u001a\"aJ\u001b\u0015\u0005\u0005]\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\"*\u001a\u0001+a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,8\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ContainerSchedulerManager
implements Logging {
    private final ExecutorAllocationClient client;
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final Option<ContextCleaner> cleaner;
    private final KylinConfig kylinConfig;
    private final ExecutorListener executorListener;
    private final int initialExecutors;
    private final int defaultProfileId;
    private final HashMap<Object, Object> numExecutorsTargetPerResourceProfileId;
    private final HashMap<Object, Object> numLocalityAwareTasksPerResourceProfileId;
    private final Map<Object, Map<String, Object>> rpIdToHostToLocalTaskCount;
    private final long executorMemory;
    private final int executorOffHeapMemory;
    private final int executorMemoryOverhead;
    private final int executorCores;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<ContextCleaner> $lessinit$greater$default$4() {
        return ContainerSchedulerManager$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private KylinConfig kylinConfig() {
        return this.kylinConfig;
    }

    private ExecutorListener executorListener() {
        return this.executorListener;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private int defaultProfileId() {
        return this.defaultProfileId;
    }

    private HashMap<Object, Object> numExecutorsTargetPerResourceProfileId() {
        return this.numExecutorsTargetPerResourceProfileId;
    }

    private HashMap<Object, Object> numLocalityAwareTasksPerResourceProfileId() {
        return this.numLocalityAwareTasksPerResourceProfileId;
    }

    private Map<Object, Map<String, Object>> rpIdToHostToLocalTaskCount() {
        return this.rpIdToHostToLocalTaskCount;
    }

    private long executorMemory() {
        return this.executorMemory;
    }

    private int executorOffHeapMemory() {
        return this.executorOffHeapMemory;
    }

    private int executorMemoryOverhead() {
        return this.executorMemoryOverhead;
    }

    public long getExecutorMemory() {
        return package$.MODULE$.max(this.executorMemory() + (long)this.executorMemoryOverhead() + (long)this.executorOffHeapMemory(), this.kylinConfig().getContainerMinMB());
    }

    private int executorCores() {
        return this.executorCores;
    }

    public int getExecutorCores() {
        return package$.MODULE$.max(this.executorCores(), this.kylinConfig().getContainerMinCore());
    }

    public void start() {
        this.listenerBus.addToManagementQueue((SparkListenerInterface)this.executorListener());
        this.cleaner.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.attachListener((CleanerListener)this.executorListener());
            return BoxedUnit.UNIT;
        });
        ContainerInitializeListener$.MODULE$.executorIds().foreach((Function1 & Serializable & scala.Serializable)id -> this.executorListener().ensureExecutorIsTracked((String)id));
        ContainerInitializeListener$.MODULE$.stop();
    }

    public int getAllExecutorCores() {
        return this.executorCores() * this.executorListener().executorCount();
    }

    public long getAllExecutorMemory() {
        return this.getExecutorMemory() * (long)this.executorListener().executorCount();
    }

    public int getExecutorCount() {
        return this.executorListener().executorCount();
    }

    public boolean requestExecutor(int num) {
        ContainerSchedulerManager containerSchedulerManager = this;
        synchronized (containerSchedulerManager) {
            int numExisting = BoxesRunTime.unboxToInt((Object)this.numExecutorsTargetPerResourceProfileId().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            this.numExecutorsTargetPerResourceProfileId().update((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Object)BoxesRunTime.boxToInteger((int)(numExisting + num)));
        }
        return this.client.requestTotalExecutors(this.numExecutorsTargetPerResourceProfileId().toMap(Predef$.MODULE$.$conforms()), this.numLocalityAwareTasksPerResourceProfileId().toMap(Predef$.MODULE$.$conforms()), this.rpIdToHostToLocalTaskCount());
    }

    public Seq<String> releaseExecutor(int num, boolean force) {
        Seq<String> executors = force ? this.executorListener().noPendingRemovalExecutors() : this.executorListener().timedOutExecutors();
        ArrayBuffer executorIdsToBeRemoved = new ArrayBuffer();
        BooleanRef flag = BooleanRef.create((boolean)true);
        executors.withFilter((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)flag.elem)).foreach((Function1 & Serializable & scala.Serializable)executor -> {
            ContainerSchedulerManager.$anonfun$releaseExecutor$2(executorIdsToBeRemoved, num, flag, executor);
            return BoxedUnit.UNIT;
        });
        if (executorIdsToBeRemoved.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq rs = this.client.killExecutors((Seq)executorIdsToBeRemoved, false, false, this.client.killExecutors$default$4());
        ContainerSchedulerManager containerSchedulerManager = this;
        synchronized (containerSchedulerManager) {
            int numExisting = BoxesRunTime.unboxToInt((Object)this.numExecutorsTargetPerResourceProfileId().getOrElse((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            this.numExecutorsTargetPerResourceProfileId().update((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Object)BoxesRunTime.boxToInteger((int)(numExisting - rs.size())));
        }
        this.client.requestTotalExecutors(this.numExecutorsTargetPerResourceProfileId().toMap(Predef$.MODULE$.$conforms()), this.numLocalityAwareTasksPerResourceProfileId().toMap(Predef$.MODULE$.$conforms()), this.rpIdToHostToLocalTaskCount());
        this.executorListener().executorsKilled((Seq<String>)rs);
        return rs;
    }

    /*
     * WARNING - void declaration
     */
    public String getQueueName() {
        void var1_1;
        block1: {
            String queue = this.conf.get("spark.kubernetes.executor.annotation.scheduling.kyligence.io.default-queue", null);
            if (queue == null) {
                queue = this.conf.get("spark.kubernetes.executor.annotation.scheduling.volcano.sh/queue-name", null);
            }
            if (queue != null) break block1;
            queue = this.conf.get("spark.yarn.queue", "default");
        }
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$releaseExecutor$2(ArrayBuffer executorIdsToBeRemoved$1, int num$1, BooleanRef flag$1, String executor) {
        block0: {
            executorIdsToBeRemoved$1.$plus$eq((Object)executor);
            if (executorIdsToBeRemoved$1.size() != num$1) break block0;
            flag$1.elem = false;
        }
    }

    public ContainerSchedulerManager(ExecutorAllocationClient client, LiveListenerBus listenerBus, SparkConf conf, Option<ContextCleaner> cleaner, ResourceProfileManager resourceProfileManager) {
        this.client = client;
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.cleaner = cleaner;
        Logging.$init$((Logging)this);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.executorListener = new ExecutorListener(this.kylinConfig(), client, listenerBus, (Clock)new SystemClock());
        this.initialExecutors = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.defaultProfileId = resourceProfileManager.defaultResourceProfile().id();
        this.numExecutorsTargetPerResourceProfileId = new HashMap();
        this.numExecutorsTargetPerResourceProfileId().update((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()));
        this.numLocalityAwareTasksPerResourceProfileId = new HashMap();
        this.numLocalityAwareTasksPerResourceProfileId().update((Object)BoxesRunTime.boxToInteger((int)this.defaultProfileId()), (Object)BoxesRunTime.boxToInteger((int)0));
        this.rpIdToHostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.executorMemory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        this.executorOffHeapMemory = Utils$.MODULE$.executorOffHeapMemorySizeAsMb(conf);
        this.executorMemoryOverhead = (int)BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)(BoxesRunTime.unboxToDouble((Object)$this.conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD_FACTOR())) * (double)this.executorMemory()), ResourceProfile$.MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
        this.executorCores = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()));
    }
}

