/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.udf;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.KapDateTimeUtils$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;

public final class TimestampAddImpl$ {
    public static TimestampAddImpl$ MODULE$;
    private final ThreadLocal<Calendar> localCalendar;
    private final Set<String> TIME_UNIT;

    static {
        new TimestampAddImpl$();
    }

    private ThreadLocal<Calendar> localCalendar() {
        return this.localCalendar;
    }

    private Calendar calendar() {
        return this.localCalendar().get();
    }

    public Set<String> TIME_UNIT() {
        return this.TIME_UNIT;
    }

    public int evaluateDays(String unit, int increment, int time) {
        this.calendar().clear();
        this.calendar().add(5, time);
        this.addTime(unit, increment, this.calendar());
        return KapDateTimeUtils$.MODULE$.millisToDaysLegacy(this.calendar().getTimeInMillis(), TimeZone.getTimeZone(ZoneId.systemDefault()));
    }

    public long evaluateTimestamp(String unit, int increment, int time) {
        this.calendar().clear();
        this.calendar().add(5, time);
        this.addTime(unit, increment, this.calendar());
        return this.fromMillis(this.calendar().getTimeInMillis());
    }

    public long fromMillis(long millis) {
        return millis * 1000L;
    }

    public int evaluateDays(String unit, long increment, int time) {
        if (increment > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Increment(").append(increment).append(") is greater than Int.MaxValue").toString());
        }
        return this.evaluateDays(unit, (int)increment, time);
    }

    public long evaluateTimestamp(String unit, long increment, int time) {
        if (increment > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Increment(").append(increment).append(") is greater than Int.MaxValue").toString());
        }
        return this.evaluateTimestamp(unit, (int)increment, time);
    }

    public long evaluateTimestamp(String unit, int increment, long time) {
        this.calendar().clear();
        this.calendar().setTimeInMillis(time / 1000L);
        this.addTime(unit, increment, this.calendar());
        return this.calendar().getTimeInMillis() * 1000L;
    }

    public long evaluateTimestamp(String unit, long increment, long time) {
        if (increment > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(40).append("Increment(").append(increment).append(") is greater than Int.MaxValue").toString());
        }
        return this.evaluateTimestamp(unit, (int)increment, time);
    }

    private void addTime(String unit, int increment, Calendar cal) {
        String string = unit.toUpperCase(Locale.ROOT);
        boolean bl = "FRAC_SECOND".equals(string) ? true : "SQL_TSI_FRAC_SECOND".equals(string);
        if (bl) {
            cal.add(14, increment);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl2 = "SECOND".equals(string) ? true : "SQL_TSI_SECOND".equals(string);
            if (bl2) {
                cal.add(13, increment);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl3 = "MINUTE".equals(string) ? true : "SQL_TSI_MINUTE".equals(string);
                if (bl3) {
                    cal.add(12, increment);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl4 = "HOUR".equals(string) ? true : "SQL_TSI_HOUR".equals(string);
                    if (bl4) {
                        cal.add(10, increment);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean bl5 = "DAY".equals(string) ? true : "SQL_TSI_DAY".equals(string);
                        if (bl5) {
                            cal.add(10, increment * 24);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boolean bl6 = "WEEK".equals(string) ? true : "SQL_TSI_WEEK".equals(string);
                            if (bl6) {
                                cal.add(10, increment * 24 * 7);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boolean bl7 = "MONTH".equals(string) ? true : "SQL_TSI_MONTH".equals(string);
                                if (bl7) {
                                    cal.setTimeInMillis(KapDateTimeUtils$.MODULE$.addMonths(cal.getTimeInMillis() * 1000L, increment) / 1000L);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boolean bl8 = "QUARTER".equals(string) ? true : "SQL_TSI_QUARTER".equals(string);
                                    if (bl8) {
                                        cal.setTimeInMillis(KapDateTimeUtils$.MODULE$.addMonths(cal.getTimeInMillis() * 1000L, increment * (int)KapDateTimeUtils$.MODULE$.MONTHS_PER_QUARTER()) / 1000L);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boolean bl9 = "YEAR".equals(string) ? true : "SQL_TSI_YEAR".equals(string);
                                        if (bl9) {
                                            cal.add(1, increment);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            throw new IllegalArgumentException(new StringBuilder(246).append("Illegal unit: ").append(unit).append(",").append(" only support [YEAR, SQL_TSI_YEAR, QUARTER, SQL_TSI_QUARTER, MONTH, SQL_TSI_MONTH, WEEK, SQL_TSI_WEEK, DAY, SQL_TSI_DAY,").append(" HOUR, SQL_TSI_HOUR, MINUTE, SQL_TSI_MINUTE, SECOND, SQL_TSI_SECOND, FRAC_SECOND, SQL_TSI_FRAC_SECOND] for now.").toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private TimestampAddImpl$() {
        MODULE$ = this;
        this.localCalendar = new ThreadLocal<Calendar>(){

            public Calendar initialValue() {
                return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
            }
        };
        this.TIME_UNIT = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HOUR", "MINUTE", "SECOND", "MILLISECOND", "MICROSECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR", "SQL_TSI_MICROSECOND", "FRAC_SECOND", "SQL_TSI_FRAC_SECOND"}));
    }
}

