/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBuildJobUtil
extends ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexBuildJobUtil.class);

    @Override
    public void computeLayout(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getIndexPlan(jobParam.getModel());
        LinkedHashSet toBeProcessedLayouts = Sets.newLinkedHashSet();
        LinkedHashSet toBeDeletedLayouts = Sets.newLinkedHashSet();
        Segments readySegs = new Segments((List)df.getSegments(jobParam.getTargetSegments()));
        if (readySegs.isEmpty()) {
            log.warn("JobParam {} is no longer valid because no ready segment exists in target index_plan {}", (Object)jobParam, (Object)jobParam.getModel());
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_SEGMENT_READY_FAIL, new Object[0]);
        }
        Set<Long> mixLayouts = SegmentUtil.intersectionLayouts((Segments<NDataSegment>)readySegs);
        List allLayouts = indexPlan.getAllLayouts();
        Set<Long> targetLayouts = jobParam.getTargetLayouts();
        if (targetLayouts.isEmpty()) {
            jobParam.setLayoutsDeletableAfterBuild(true);
            allLayouts.forEach(layout -> {
                if (!layout.isToBeDeleted() && !mixLayouts.contains(layout.getId())) {
                    toBeProcessedLayouts.add(layout);
                }
            });
            toBeDeletedLayouts.addAll(IndexBuildJobUtil.pruneTBDelLayouts(allLayouts.stream().filter(LayoutEntity::isToBeDeleted).collect(Collectors.toCollection(LinkedHashSet::new)), toBeProcessedLayouts, df, indexPlan, (List<NDataSegment>)readySegs));
        } else {
            jobParam.setLayoutsDeletableAfterBuild(false);
            allLayouts.forEach(layout -> {
                long layoutId = layout.getId();
                if (targetLayouts.contains(layoutId) && !mixLayouts.contains(layoutId)) {
                    toBeProcessedLayouts.add(layout);
                }
            });
        }
        jobParam.setProcessLayouts(this.filterTobeDelete(toBeProcessedLayouts));
        jobParam.setDeleteLayouts(toBeDeletedLayouts);
        log.info("toBeProcessedLayouts: {}, toBeDeletedLayouts: {}", jobParam.getProcessLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toList()), jobParam.getDeleteLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toList()));
    }

    @Override
    public void computePartitions(JobParam jobParam) {
        NDataflowManager dfm = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject());
        NDataflow df = dfm.getDataflow(jobParam.getModel());
        Segments segments = df.getSegments(jobParam.getTargetSegments());
        HashSet partitionIds = Sets.newHashSet();
        segments.forEach(segment -> {
            if (CollectionUtils.isEmpty((Collection)segment.getAllPartitionIds())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_EMPTY, new Object[0]);
            }
            partitionIds.addAll(segment.getAllPartitionIds());
        });
        jobParam.setTargetPartitions(partitionIds);
    }

    public static Set<LayoutEntity> pruneTBDelLayouts(Set<LayoutEntity> tbDelLayouts, Set<LayoutEntity> tbProLayouts, NDataflow df, IndexPlan indexPlan, List<NDataSegment> readySegs) {
        LinkedHashSet newTBDelLayouts = Sets.newLinkedHashSet();
        if (tbDelLayouts.isEmpty()) {
            return newTBDelLayouts;
        }
        for (LayoutEntity layout : tbDelLayouts.stream().filter(LayoutEntity::isBaseIndex).collect(Collectors.toList())) {
            if (!IndexBuildJobUtil.baseLayoutDeletable(layout, tbProLayouts, df, readySegs)) continue;
            newTBDelLayouts.add(layout);
        }
        List allLayouts = indexPlan.getAllLayouts();
        boolean regularLayoutDeletable = true;
        Set<LayoutEntity> tbDelBaseLayouts = Collections.unmodifiableSet(newTBDelLayouts);
        for (LayoutEntity layout : tbDelLayouts.stream().filter(le -> !le.isBaseIndex()).collect(Collectors.toList())) {
            if (!regularLayoutDeletable) continue;
            for (NDataSegment segment : df.getSegments()) {
                if (!IndexBuildJobUtil.segmentLayoutsNotFull(segment, tbDelBaseLayouts, tbProLayouts, allLayouts, readySegs)) continue;
                regularLayoutDeletable = false;
                break;
            }
            if (!regularLayoutDeletable) continue;
            newTBDelLayouts.add(layout);
        }
        return newTBDelLayouts;
    }

    private static boolean baseLayoutDeletable(LayoutEntity layout, Set<LayoutEntity> tbProLayouts, NDataflow df, List<NDataSegment> readySegs) {
        List segmentsHaveTheTBDel = df.getSegments().stream().filter(segment -> segment.getLayoutIds().contains(layout.getId())).collect(Collectors.toList());
        LayoutEntity newBaseLayout = tbProLayouts.stream().filter(LayoutEntity::isBaseIndex).filter(lay -> IndexBuildJobUtil.filterSameTypeLayout(lay, layout)).findFirst().orElse(null);
        if (newBaseLayout != null) {
            Set segmentsHaveTheTBPro = df.getSegments().stream().filter(segment -> segment.getLayoutIds().contains(newBaseLayout.getId())).collect(Collectors.toSet());
            segmentsHaveTheTBPro.addAll(readySegs);
            return segmentsHaveTheTBDel.stream().allMatch(segTBDLayout -> segmentsHaveTheTBPro.stream().anyMatch(segTBPLayout -> segTBPLayout.getId().equals(segTBDLayout.getId())));
        }
        return false;
    }

    private static boolean filterSameTypeLayout(LayoutEntity target, LayoutEntity refer) {
        return IndexEntity.isTableIndex((long)refer.getId()) ? IndexEntity.isTableIndex((long)target.getId()) : IndexEntity.isAggIndex((long)target.getId());
    }

    private static boolean segmentLayoutsNotFull(NDataSegment segment, Set<LayoutEntity> tbDelBaseLayouts, Set<LayoutEntity> tbProLayouts, List<LayoutEntity> allLayouts, List<NDataSegment> readySegs) {
        if (segment.getLayoutIds().size() != allLayouts.size()) {
            HashSet segmentLayouts = Sets.newHashSet((Iterable)segment.getLayoutIds());
            segmentLayouts.removeAll(tbDelBaseLayouts.stream().map(LayoutEntity::getId).collect(Collectors.toSet()));
            if (readySegs.stream().anyMatch(seg -> seg.getId().equals(segment.getId()))) {
                segmentLayouts.addAll(tbProLayouts.stream().map(LayoutEntity::getId).collect(Collectors.toSet()));
            }
            return segmentLayouts.size() != allLayouts.size() - tbDelBaseLayouts.size();
        }
        return false;
    }

    static {
        IndexBuildJobUtil.registerImplementation(JobTypeEnum.INDEX_BUILD, new IndexBuildJobUtil());
    }
}

