/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBuildJobUtil
extends ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartitionBuildJobUtil.class);

    @Override
    public void computeLayout(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        HashSet layouts = Sets.newHashSet();
        NDataSegment segment = df.getSegment(jobParam.getSegment());
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getIndexPlan(jobParam.getModel());
        if (segment.getMultiPartitions().isEmpty() || segment.getLayoutsMap().isEmpty()) {
            ExecutableManager execManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), jobParam.getProject());
            List<AbstractExecutable> executables = execManager.listMultiPartitionModelExec(jobParam.getModel(), ExecutableState::isRunning, null, null, jobParam.getTargetSegments());
            if (!executables.isEmpty()) {
                Set<Long> layoutIds = executables.get(0).getLayoutIds();
                indexPlan.getAllLayouts().forEach(layout -> {
                    if (layoutIds.contains(layout.getId())) {
                        layouts.add(layout);
                    }
                });
            } else {
                layouts.addAll(indexPlan.getAllLayouts());
            }
        } else {
            segment.getLayoutsMap().values().forEach(layout -> layouts.add(layout.getLayout()));
        }
        jobParam.setProcessLayouts(this.filterTobeDelete(layouts));
        this.checkLayoutsNotEmpty(jobParam);
    }

    @Override
    public void computePartitions(JobParam jobParam) {
        if (CollectionUtils.isEmpty(jobParam.getTargetPartitions())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_EMPTY, new Object[0]);
        }
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        NDataSegment segment = df.getSegment(jobParam.getSegment());
        segment.getMultiPartitions().forEach(partition -> {
            if (jobParam.getTargetPartitions().contains(partition.getPartitionId()) && partition.getStatus() == PartitionStatusEnum.READY) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_CHECK_MULTI_PARTITION_ABANDON, new Object[0]);
            }
        });
    }

    static {
        PartitionBuildJobUtil.registerImplementation(JobTypeEnum.SUB_PARTITION_BUILD, new PartitionBuildJobUtil());
    }
}

