/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.apache.kylin.guava30.shaded.common.collect.Multimaps;
import org.apache.kylin.job.constant.JobStatusEnum;

public enum ExecutableState {
    READY,
    PENDING,
    RUNNING,
    ERROR,
    PAUSED,
    DISCARDED,
    SUCCEED,
    SUICIDAL,
    SKIP,
    WARNING;

    private static Multimap<ExecutableState, ExecutableState> VALID_STATE_TRANSFER;

    public static ExecutableState[] getFinalStates() {
        return new ExecutableState[]{SUCCEED, DISCARDED, SUICIDAL};
    }

    public static List<ExecutableState> getNotFinalStates() {
        return Arrays.stream(ExecutableState.values()).filter(o -> !o.isFinalState()).collect(Collectors.toList());
    }

    public static List<String> getNotFinalStateNames() {
        return ExecutableState.getNotFinalStates().stream().map(Enum::name).collect(Collectors.toList());
    }

    public boolean isProgressing() {
        return this == READY || this == RUNNING || this == PENDING;
    }

    public boolean isFinalState() {
        return Lists.newArrayList((Object[])ExecutableState.getFinalStates()).contains((Object)this);
    }

    public boolean isRunning() {
        return !this.isFinalState();
    }

    public boolean isNotProgressing() {
        return this == ERROR || this == PAUSED;
    }

    public boolean isStoppedNonVoluntarily() {
        return this == DISCARDED || this == PAUSED || this == READY || this == PENDING;
    }

    public boolean isNotBad() {
        return this == SUCCEED || this == SKIP || this == WARNING;
    }

    public static boolean isValidStateTransfer(ExecutableState from, ExecutableState to) {
        return VALID_STATE_TRANSFER.containsEntry((Object)from, (Object)to);
    }

    public JobStatusEnum toJobStatus() {
        switch (this) {
            case SKIP: {
                return JobStatusEnum.SKIP;
            }
            case READY: 
            case PENDING: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
            case PAUSED: {
                return JobStatusEnum.STOPPED;
            }
            case SUICIDAL: 
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case WARNING: {
                return JobStatusEnum.WARNING;
            }
        }
        throw new RuntimeException("invalid state:" + (Object)((Object)this));
    }

    public String toStringState() {
        switch (this) {
            case SUCCEED: {
                return "Succeed";
            }
            case ERROR: {
                return "Error";
            }
            case DISCARDED: {
                return "Discard";
            }
        }
        throw new IllegalStateException("invalid Executable state:" + (Object)((Object)this));
    }

    static {
        VALID_STATE_TRANSFER = Multimaps.newSetMultimap((Map)Maps.newEnumMap(ExecutableState.class), () -> new CopyOnWriteArraySet());
        VALID_STATE_TRANSFER.put((Object)READY, (Object)PENDING);
        VALID_STATE_TRANSFER.put((Object)READY, (Object)PAUSED);
        VALID_STATE_TRANSFER.put((Object)READY, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)READY, (Object)SUICIDAL);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)RUNNING);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)ERROR);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)SUICIDAL);
        VALID_STATE_TRANSFER.put((Object)PENDING, (Object)PAUSED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)SUCCEED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)ERROR);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)SUICIDAL);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)PAUSED);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)SKIP);
        VALID_STATE_TRANSFER.put((Object)RUNNING, (Object)WARNING);
        VALID_STATE_TRANSFER.put((Object)PAUSED, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)PAUSED, (Object)SUICIDAL);
        VALID_STATE_TRANSFER.put((Object)PAUSED, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)ERROR, (Object)DISCARDED);
        VALID_STATE_TRANSFER.put((Object)ERROR, (Object)SUICIDAL);
        VALID_STATE_TRANSFER.put((Object)ERROR, (Object)READY);
        VALID_STATE_TRANSFER.put((Object)SUCCEED, (Object)READY);
    }
}

