/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.utils;

import io.substrait.proto.Type;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.NoSuchElementException;
import org.apache.gluten.backendsapi.clickhouse.CHBackendSettings$;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.row.SparkRowInfo;
import org.apache.gluten.vectorized.BlockOutputStream;
import org.apache.gluten.vectorized.BlockSplitIterator;
import org.apache.gluten.vectorized.BlockStats;
import org.apache.gluten.vectorized.CHBlockConverterJniWrapper;
import org.apache.gluten.vectorized.CHNativeBlock;
import org.apache.gluten.vectorized.CloseablePartitionedBlockIterator;
import org.apache.gluten.vectorized.NativePartitioning;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ColumnarShuffleDependency;
import org.apache.spark.shuffle.ColumnarShuffleDependency$;
import org.apache.spark.shuffle.GlutenShuffleUtils$;
import org.apache.spark.shuffle.HashPartitioningWrapper;
import org.apache.spark.shuffle.ShuffleWriteProcessor;
import org.apache.spark.shuffle.utils.RangeBoundsInfo;
import org.apache.spark.shuffle.utils.RangePartitionerBoundsGenerator;
import org.apache.spark.shuffle.utils.RangePartitionerBoundsGenerator$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.RoundRobinPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLShuffleWriteMetricsReporter$;
import org.apache.spark.sql.execution.utils.PartitionIdPassthrough;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.MutablePair;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

public final class CHExecUtil$
implements Logging {
    public static CHExecUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CHExecUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataType inferSparkDataType(byte[] substraitType) {
        Tuple2 tuple2 = ConverterUtils$.MODULE$.parseFromSubstraitType(Type.parseFrom((byte[])substraitType));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DataType datatype = (DataType)tuple2._1();
        boolean nullable = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)datatype, (Object)BoxesRunTime.boxToBoolean((boolean)nullable));
        Tuple2 tuple23 = tuple22;
        DataType datatype2 = (DataType)tuple23._1();
        boolean nullable2 = tuple23._2$mcZ$sp();
        return datatype2;
    }

    public Iterator<Tuple3<Object, byte[], Object>> toBytes(SQLMetric dataSize, Iterator<ColumnarBatch> iter, boolean isNullAware, int keyColumnIndex, Option<String> compressionCodec, Option<Object> compressionLevel, int bufferSize) {
        long count = 0L;
        boolean hasNullKeyValues = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int level = BoxesRunTime.unboxToInt((Object)compressionLevel.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MIN_VALUE));
        BlockOutputStream blockOutputStream = (BlockOutputStream)compressionCodec.map((Function1 & Serializable & scala.Serializable)x$2 -> new BlockOutputStream(bos, buffer, dataSize, true, (String)x$2, level, bufferSize)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new BlockOutputStream(bos, buffer, dataSize, false, "", level, bufferSize));
        if (isNullAware) {
            while (iter.hasNext()) {
                ColumnarBatch batch = (ColumnarBatch)iter.next();
                BlockStats blockStats = CHNativeBlock.fromColumnarBatch(batch).getBlockStats(keyColumnIndex);
                count += blockStats.getBlockRecordCount();
                hasNullKeyValues = hasNullKeyValues || blockStats.isHasNullKeyValues();
                blockOutputStream.write(batch);
            }
        } else {
            while (iter.hasNext()) {
                ColumnarBatch batch = (ColumnarBatch)iter.next();
                count += (long)batch.numRows();
                blockOutputStream.write(batch);
            }
        }
        blockOutputStream.flush();
        blockOutputStream.close();
        return scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)count), (Object)bos.toByteArray(), (Object)BoxesRunTime.boxToBoolean((boolean)hasNullKeyValues))}));
    }

    public boolean toBytes$default$3() {
        return false;
    }

    public int toBytes$default$4() {
        return 0;
    }

    public Option<String> toBytes$default$5() {
        return new Some((Object)"lz4");
    }

    public Option<Object> toBytes$default$6() {
        return None$.MODULE$;
    }

    public int toBytes$default$7() {
        return 4096;
    }

    public RDD<Tuple3<Object, byte[], Object>> buildSideRDD(SQLMetric dataSize, SparkPlan newChild, boolean isNullAware, int keyColumnIndex) {
        RDD qual$1 = newChild.executeColumnar();
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> MODULE$.toBytes(dataSize, (Iterator<ColumnarBatch>)iter, isNullAware, keyColumnIndex, MODULE$.toBytes$default$5(), MODULE$.toBytes$default$6(), MODULE$.toBytes$default$7());
        boolean x$2 = qual$1.mapPartitionsInternal$default$2();
        return qual$1.mapPartitionsInternal((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    private RDD<MutablePair<InternalRow, Null$>> buildRangePartitionSampleRDD(RDD<ColumnarBatch> rdd, RangePartitioning rangePartitioning, Seq<Attribute> outputAttributes) {
        RDD sampleRDD;
        RangePartitioning rangePartitioning2 = rangePartitioning;
        if (rangePartitioning2 == null) {
            throw new MatchError((Object)rangePartitioning2);
        }
        Seq sortingExpressions = rangePartitioning2.ordering();
        RDD rDD = sampleRDD = rdd.mapPartitionsInternal((Function1 & Serializable & scala.Serializable)iter -> iter.flatMap((Function1 & Serializable & scala.Serializable)batch -> {
            Iterator<InternalRow> rowItr = MODULE$.c2r((ColumnarBatch)batch);
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.child(), Seq$.MODULE$.canBuildFrom()), outputAttributes);
            MutablePair mutablePair = new MutablePair();
            return rowItr.map((Function1 & Serializable & scala.Serializable)row -> mutablePair.update((Object)projection.apply(row).copy(), null));
        }), rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
        return rDD;
    }

    public Iterator<InternalRow> getRowIterFromSparkRowInfo(SparkRowInfo rowInfo, int columns, int rows) {
        return new Iterator<InternalRow>(columns, rows, rowInfo){
            private int rowId;
            private final UnsafeRow row;
            private boolean closed;
            private final int rows$1;
            private final SparkRowInfo rowInfo$1;

            public Iterator<InternalRow> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<InternalRow> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<InternalRow> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<InternalRow> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<InternalRow, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<InternalRow, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<InternalRow, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<InternalRow, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<InternalRow, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<InternalRow> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<InternalRow> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<InternalRow> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<InternalRow> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<InternalRow> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<InternalRow, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<InternalRow> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<InternalRow> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<InternalRow> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<InternalRow> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<InternalRow> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<InternalRow, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private int rowId() {
                return this.rowId;
            }

            private void rowId_$eq(int x$1) {
                this.rowId = x$1;
            }

            private UnsafeRow row() {
                return this.row;
            }

            private boolean closed() {
                return this.closed;
            }

            private void closed_$eq(boolean x$1) {
                this.closed = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean hasNext() {
                void var1_1;
                block0: {
                    boolean result;
                    boolean bl = result = this.rowId() < this.rows$1;
                    if (result || this.closed()) break block0;
                    CHBlockConverterJniWrapper.freeMemory(this.rowInfo$1.memoryAddress, this.rowInfo$1.totalSize);
                    this.closed_$eq(true);
                }
                return (boolean)var1_1;
            }

            public UnsafeRow next() {
                if (this.rowId() >= this.rows$1) {
                    throw new NoSuchElementException();
                }
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(this.rowInfo$1.offsets[this.rowId()], this.rowInfo$1.lengths[this.rowId()]);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                long offset = sp2._1$mcJ$sp();
                long length = sp2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(offset, length);
                Tuple2.mcJJ.sp sp4 = sp3;
                long offset2 = sp4._1$mcJ$sp();
                long length2 = sp4._2$mcJ$sp();
                this.row().pointTo(null, this.rowInfo$1.memoryAddress + offset2, (int)length2);
                this.rowId_$eq(this.rowId() + 1);
                return this.row();
            }
            {
                this.rows$1 = rows$1;
                this.rowInfo$1 = rowInfo$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.rowId = 0;
                this.row = new UnsafeRow(columns$1);
                this.closed = false;
            }
        };
    }

    public Iterator<InternalRow> getRowIterFromSparkRowInfo(long blockAddress, int columns, int rows) {
        SparkRowInfo rowInfo = CHBlockConverterJniWrapper.convertColumnarToRow(blockAddress, null);
        Predef$.MODULE$.assert(rowInfo.fieldsNum == (long)columns);
        return this.getRowIterFromSparkRowInfo(rowInfo, columns, rows);
    }

    public Iterator<InternalRow> c2r(ColumnarBatch batch) {
        return this.getRowIterFromSparkRowInfo(CHNativeBlock.fromColumnarBatch(batch).blockAddress(), batch.numCols(), batch.numRows());
    }

    private CloseablePartitionedBlockIterator buildPartitionedBlockIterator(Iterator<ColumnarBatch> cbIter, BlockSplitIterator.IteratorOptions options, SQLMetric records_written_metric) {
        Iterator<Product2<Object, ColumnarBatch>> iter = new Iterator<Product2<Object, ColumnarBatch>>(cbIter, options, records_written_metric){
            private final BlockSplitIterator splitIterator;
            private final SQLMetric records_written_metric$1;

            public Iterator<Product2<Object, ColumnarBatch>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Product2<Object, ColumnarBatch>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Product2<Object, ColumnarBatch>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Product2<Object, ColumnarBatch>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Product2<Object, ColumnarBatch>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Product2<Object, ColumnarBatch>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Product2<Object, ColumnarBatch>, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Product2<Object, ColumnarBatch>> filter(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Product2<Object, ColumnarBatch>, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Product2<Object, ColumnarBatch>> withFilter(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Product2<Object, ColumnarBatch>> filterNot(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Product2<Object, ColumnarBatch>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Product2<Object, ColumnarBatch>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Product2<Object, ColumnarBatch>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Product2<Object, ColumnarBatch>> takeWhile(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Product2<Object, ColumnarBatch>>, Iterator<Product2<Object, ColumnarBatch>>> partition(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Product2<Object, ColumnarBatch>>, Iterator<Product2<Object, ColumnarBatch>>> span(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Product2<Object, ColumnarBatch>> dropWhile(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Product2<Object, ColumnarBatch>, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Product2<Object, ColumnarBatch>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Product2<Object, ColumnarBatch>, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Product2<Object, ColumnarBatch>> find(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Product2<Object, ColumnarBatch>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Product2<Object, ColumnarBatch>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Product2<Object, ColumnarBatch>>, Iterator<Product2<Object, ColumnarBatch>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Product2<Object, ColumnarBatch>> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Product2<Object, ColumnarBatch>> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Product2<Object, ColumnarBatch>> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Product2<Object, ColumnarBatch>> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Product2<Object, ColumnarBatch>, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Product2<Object, ColumnarBatch>, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Product2<Object, ColumnarBatch>, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Product2<Object, ColumnarBatch>, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Product2<Object, ColumnarBatch>, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Product2<Object, ColumnarBatch>, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Product2<Object, ColumnarBatch>, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Product2<Object, ColumnarBatch>, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Product2<Object, ColumnarBatch>, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Product2<Object, ColumnarBatch>, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Product2<Object, ColumnarBatch>, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Product2<Object, ColumnarBatch>> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Product2<Object, ColumnarBatch>> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Product2<Object, ColumnarBatch>> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Product2<Object, ColumnarBatch>> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Product2<Object, ColumnarBatch>> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Product2<Object, ColumnarBatch>, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Product2<Object, ColumnarBatch>, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private BlockSplitIterator splitIterator() {
                return this.splitIterator;
            }

            public boolean hasNext() {
                return this.splitIterator().hasNext();
            }

            public Product2<Object, ColumnarBatch> next() {
                ColumnarBatch nextBatch = this.splitIterator().next();
                this.records_written_metric$1.add((long)(nextBatch.numRows() - 1));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.splitIterator().nextPartitionId()), (Object)nextBatch);
            }

            public void close() {
                this.splitIterator().close();
            }
            {
                this.records_written_metric$1 = records_written_metric$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.splitIterator = new BlockSplitIterator((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(cbIter$1.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)CHNativeBlock.fromColumnarBatch(x$5).blockAddress()))).asJava(), options$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$splitIterator$1(org.apache.spark.sql.vectorized.ColumnarBatch )}, serializedLambda);
            }
        };
        return new CloseablePartitionedBlockIterator(iter);
    }

    private NativePartitioning buildHashPartitioning(HashPartitioning partitioning, Seq<Attribute> childOutput, Seq<Attribute> output) {
        Seq<Expression> seq;
        HashPartitioning hashPartitioning = partitioning;
        if (hashPartitioning instanceof HashPartitioningWrapper) {
            HashPartitioningWrapper hashPartitioningWrapper = (HashPartitioningWrapper)hashPartitioning;
            seq = hashPartitioningWrapper.getNewExpr();
        } else {
            seq = partitioning.expressions();
        }
        Seq<Expression> hashExpressions = seq;
        Seq hashFields = (Seq)hashExpressions.map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)CHExecUtil$.$anonfun$buildHashPartitioning$1(childOutput, a)), Seq$.MODULE$.canBuildFrom());
        Seq outputFields = output != null ? (Seq)output.map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)CHExecUtil$.$anonfun$buildHashPartitioning$2(childOutput, a)), Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
        return new NativePartitioning(GlutenShuffleUtils$.MODULE$.HashPartitioningShortName(), partitioning.numPartitions(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), hashFields.mkString(",").getBytes(), outputFields.mkString(",").getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private BlockSplitIterator.IteratorOptions buildPartitioningOptions(NativePartitioning nativePartitioning) {
        void var2_2;
        BlockSplitIterator.IteratorOptions options = new BlockSplitIterator.IteratorOptions();
        options.setBufferSize(GlutenConfig$.MODULE$.get().maxBatchSize());
        options.setName(nativePartitioning.getShortName());
        options.setPartitionNum(nativePartitioning.getNumPartitions());
        options.setExpr(new String(nativePartitioning.getExprList()));
        options.setHashAlgorithm(CHBackendSettings$.MODULE$.shuffleHashAlgorithm());
        options.setRequiredFields(nativePartitioning.getRequiredFields() != null ? new String(nativePartitioning.getRequiredFields()) : new String(""));
        return var2_2;
    }

    public ShuffleDependency<Object, ColumnarBatch, ColumnarBatch> genShuffleDependency(RDD<ColumnarBatch> rdd, Seq<Attribute> childOutputAttributes, Seq<Attribute> projectOutputAttributes, Partitioning newPartitioning, Serializer serializer, Map<String, SQLMetric> writeMetrics, Map<String, SQLMetric> metrics) {
        RDD rddWithPartitionKey;
        RDD rDD;
        boolean isOrderSensitive;
        NativePartitioning nativePartitioning;
        LazyRef requiredFields$lzy = new LazyRef();
        Partitioning partitioning = newPartitioning;
        if (SinglePartition$.MODULE$.equals(partitioning)) {
            nativePartitioning = new NativePartitioning(GlutenShuffleUtils$.MODULE$.SinglePartitioningShortName(), 1, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), CHExecUtil$.requiredFields$1(requiredFields$lzy, projectOutputAttributes, childOutputAttributes));
        } else if (partitioning instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning;
            int n = roundRobinPartitioning.numPartitions();
            nativePartitioning = new NativePartitioning(GlutenShuffleUtils$.MODULE$.RoundRobinPartitioningShortName(), n, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), CHExecUtil$.requiredFields$1(requiredFields$lzy, projectOutputAttributes, childOutputAttributes));
        } else if (partitioning instanceof HashPartitioning) {
            nativePartitioning = this.buildHashPartitioning((HashPartitioning)newPartitioning, childOutputAttributes, projectOutputAttributes);
        } else if (partitioning instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning;
            Seq sortingExpressions = rangePartitioning.ordering();
            int numPartitions = rangePartitioning.numPartitions();
            RDD<MutablePair<InternalRow, Null$>> rddForSampling = this.buildRangePartitionSampleRDD(rdd, new RangePartitioning(sortingExpressions, numPartitions), childOutputAttributes);
            Seq orderingAttributes = (Seq)((TraversableLike)sortingExpressions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SortOrder ord = (SortOrder)tuple2._1();
                int i = tuple2._2$mcI$sp();
                SortOrder sortOrder = ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                return sortOrder;
            }, Seq$.MODULE$.canBuildFrom());
            LazilyGeneratedOrdering ordering = new LazilyGeneratedOrdering(orderingAttributes);
            RangePartitionerBoundsGenerator<InternalRow, Null$> generator = new RangePartitionerBoundsGenerator<InternalRow, Null$>(numPartitions, (RDD<Product2<InternalRow, Null$>>)rddForSampling, (Seq<SortOrder>)sortingExpressions, childOutputAttributes, RangePartitionerBoundsGenerator$.MODULE$.$lessinit$greater$default$5(), RangePartitionerBoundsGenerator$.MODULE$.$lessinit$greater$default$6(), (Ordering<InternalRow>)ordering, (ClassTag<InternalRow>)ClassTag$.MODULE$.apply(InternalRow.class));
            RangeBoundsInfo rangeBoundsInfo = generator.getRangeBoundsJsonString();
            Seq attributePos = projectOutputAttributes != null ? (Seq)projectOutputAttributes.map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)CHExecUtil$.$anonfun$genShuffleDependency$3(childOutputAttributes, attr)), Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
            nativePartitioning = new NativePartitioning(GlutenShuffleUtils$.MODULE$.RangePartitioningShortName(), rangeBoundsInfo.boundsSize() + 1, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), rangeBoundsInfo.json().getBytes(), attributePos.mkString(",").getBytes());
        } else {
            throw new IllegalStateException(new java.lang.StringBuilder(23).append("Unknow partition type: ").append(partitioning.getClass().toString()).toString());
        }
        NativePartitioning nativePartitioning2 = nativePartitioning;
        boolean isRoundRobin = newPartitioning instanceof RoundRobinPartitioning && newPartitioning.numPartitions() > 1;
        boolean bl = isOrderSensitive = isRoundRobin && !SQLConf$.MODULE$.get().sortBeforeRepartition();
        if (GlutenConfig$.MODULE$.get().isUseColumnarShuffleManager() || GlutenConfig$.MODULE$.get().isUseCelebornShuffleManager()) {
            RDD rDD2;
            Partitioning partitioning2 = newPartitioning;
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x$6, cbIter) -> cbIter.map((Function1 & Serializable & scala.Serializable)cb -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), cb));
            boolean x$2 = isOrderSensitive;
            boolean x$3 = rdd.mapPartitionsWithIndexInternal$default$2();
            rDD = rDD2 = rdd.mapPartitionsWithIndexInternal((Function2)x$1, x$3, x$2, ClassTag$.MODULE$.apply(Product2.class));
        } else {
            BlockSplitIterator.IteratorOptions options = this.buildPartitioningOptions(nativePartitioning2);
            Function2 & Serializable & scala.Serializable x$4 = (Function2 & Serializable & scala.Serializable)(x$7, cbIter) -> CHExecUtil$.MODULE$.buildPartitionedBlockIterator((Iterator<ColumnarBatch>)cbIter, options, (SQLMetric)writeMetrics.apply((Object)SQLShuffleWriteMetricsReporter$.MODULE$.SHUFFLE_RECORDS_WRITTEN()));
            boolean x$5 = isOrderSensitive;
            boolean x$62 = rdd.mapPartitionsWithIndexInternal$default$2();
            rDD = rdd.mapPartitionsWithIndexInternal((Function2)x$4, x$62, x$5, ClassTag$.MODULE$.apply(Product2.class));
        }
        RDD x$72 = rddWithPartitionKey = rDD;
        PartitionIdPassthrough x$8 = new PartitionIdPassthrough(nativePartitioning2.getNumPartitions());
        Serializer x$9 = serializer;
        ShuffleWriteProcessor x$10 = ShuffleExchangeExec$.MODULE$.createShuffleWriteProcessor(writeMetrics);
        NativePartitioning x$11 = nativePartitioning2;
        Map<String, SQLMetric> x$12 = metrics;
        None$ x$13 = ColumnarShuffleDependency$.MODULE$.$lessinit$greater$default$4();
        None$ x$14 = ColumnarShuffleDependency$.MODULE$.$lessinit$greater$default$5();
        boolean x$15 = ColumnarShuffleDependency$.MODULE$.$lessinit$greater$default$6();
        boolean x$16 = ColumnarShuffleDependency$.MODULE$.$lessinit$greater$default$10();
        ColumnarShuffleDependency dependency = new ColumnarShuffleDependency(x$72, (Partitioner)x$8, x$9, (Option)x$13, (Option)x$14, x$15, x$10, x$11, x$12, x$16, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ColumnarBatch.class), ClassTag$.MODULE$.apply(ColumnarBatch.class));
        return dependency;
    }

    public static final /* synthetic */ int $anonfun$buildHashPartitioning$1(Seq childOutput$1, Expression a) {
        return ((BoundReference)BindReferences$.MODULE$.bindReference((Expression)ConverterUtils$.MODULE$.getAttrFromExpr(a).toAttribute(), package$.MODULE$.AttributeSeq(childOutput$1), BindReferences$.MODULE$.bindReference$default$3())).ordinal();
    }

    public static final /* synthetic */ int $anonfun$buildHashPartitioning$2(Seq childOutput$1, Attribute a) {
        return ((BoundReference)BindReferences$.MODULE$.bindReference((Expression)a, package$.MODULE$.AttributeSeq(childOutput$1), BindReferences$.MODULE$.bindReference$default$3())).ordinal();
    }

    public static final /* synthetic */ int $anonfun$genShuffleDependency$1(Seq childOutputAttributes$1, Attribute a) {
        return ((BoundReference)BindReferences$.MODULE$.bindReference((Expression)a, package$.MODULE$.AttributeSeq(childOutputAttributes$1), BindReferences$.MODULE$.bindReference$default$3())).ordinal();
    }

    private static final /* synthetic */ byte[] requiredFields$lzycompute$1(LazyRef requiredFields$lzy$1, Seq projectOutputAttributes$1, Seq childOutputAttributes$1) {
        byte[] byArray;
        LazyRef lazyRef = requiredFields$lzy$1;
        synchronized (lazyRef) {
            byte[] byArray2;
            if (requiredFields$lzy$1.initialized()) {
                byArray2 = (byte[])requiredFields$lzy$1.value();
            } else {
                Object object;
                if (projectOutputAttributes$1 != null) {
                    Seq outputFields = (Seq)projectOutputAttributes$1.map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)CHExecUtil$.$anonfun$genShuffleDependency$1(childOutputAttributes$1, a)), Seq$.MODULE$.canBuildFrom());
                    object = outputFields.mkString(",").getBytes();
                } else {
                    object = Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                }
                byArray2 = (byte[])requiredFields$lzy$1.initialize(object);
            }
            byArray = byArray2;
        }
        return byArray;
    }

    private static final byte[] requiredFields$1(LazyRef requiredFields$lzy$1, Seq projectOutputAttributes$1, Seq childOutputAttributes$1) {
        return requiredFields$lzy$1.initialized() ? (byte[])requiredFields$lzy$1.value() : CHExecUtil$.requiredFields$lzycompute$1(requiredFields$lzy$1, projectOutputAttributes$1, childOutputAttributes$1);
    }

    public static final /* synthetic */ int $anonfun$genShuffleDependency$3(Seq childOutputAttributes$1, Attribute attr) {
        return ((BoundReference)BindReferences$.MODULE$.bindReference((Expression)attr, package$.MODULE$.AttributeSeq(childOutputAttributes$1), BindReferences$.MODULE$.bindReference$default$3())).ordinal();
    }

    private CHExecUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

