/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.HashMap;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.engine.spark.job.LayoutDataOptimizeJob;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;

public class ResourceDetectBeforeOptimizeJob
extends LayoutDataOptimizeJob
implements ResourceDetect {
    public static void main(String[] args) {
        ResourceDetectBeforeOptimizeJob resourceDetectJob = new ResourceDetectBeforeOptimizeJob();
        resourceDetectJob.execute(args);
    }

    @Override
    protected void doExecute() throws Exception {
        this.infos.clearOptimizeLayoutIds();
        HashMap resourceSize = Maps.newHashMap();
        this.getLayoutDetails().foreach(layoutDetails -> {
            this.infos.recordOptimizeLayoutIds(layoutDetails.getLayoutId());
            resourceSize.put(layoutDetails.getId(), layoutDetails.getSizeInBytes());
            return null;
        });
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), this.dataFlow().getId() + "_" + ResourceDetectUtils.fileName()), (Object)resourceSize);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeOptimizeJob();
    }

    @Override
    protected void waitForResourceSuccess() {
    }
}

