/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.cleanup.HDFSResourceCheck;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HDFSUtils$
implements Logging {
    public static HDFSUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HDFSUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Configuration getActiveHadoopConf() {
        return HadoopUtil.getCurrentConfiguration();
    }

    public FileContext getFileContext(Path path) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)this.getActiveHadoopConf());
    }

    public List<FileStatus> listSortedFileFrom(Path path) {
        FileContext fc = this.getFileContext(path);
        if (!fc.util().exists(path)) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        FileStatus[] files = fc.util().listStatus(path);
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getModificationTime()), (Ordering)Ordering.Long$.MODULE$);
    }

    public FileStatus findLastFile(Path path) {
        return (FileStatus)this.listSortedFileFrom(path).last();
    }

    public boolean exists(Path path) {
        return this.getFileContext(path).util().exists(path);
    }

    public void deleteFilesWithCheck(Path path, HDFSResourceCheck HDFSResourceCheck2) {
        FileContext context = this.getFileContext(path);
        HDFSResourceCheck2.isExpired((Seq<FileStatus>)this.listSortedFileFrom(path)).foreach((Function1 & Serializable & scala.Serializable)fs -> {
            HDFSUtils$.$anonfun$deleteFilesWithCheck$1(context, fs);
            return BoxedUnit.UNIT;
        });
    }

    public FileStatus getFileStatus(Path path) {
        return this.getFileContext(path).getFileStatus(path);
    }

    public boolean isExistsMarkFile(String markFile) {
        Configuration conf = new Configuration();
        Path path = new Path(markFile);
        FileSystem fs = path.getFileSystem(conf);
        return fs.exists(path);
    }

    public void deleteMarkFile(String markFile) {
        block0: {
            Path path = new Path(markFile);
            Configuration conf = new Configuration();
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path)) break block0;
            fs.delete(path, true);
        }
    }

    public boolean touchzMarkFile(String markFile) {
        Path path = new Path(markFile);
        FileSystem fs = path.getFileSystem(new Configuration());
        Object object = !fs.exists(path.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(path.getParent())) : BoxedUnit.UNIT;
        for (int errCnt = 0; errCnt < 3; ++errCnt) {
            FSDataOutputStream output = null;
            try {
                if (!fs.exists(path)) {
                    output = fs.create(path);
                    output.writeByte(0);
                    output.close();
                }
                return fs.exists(path);
            }
            catch (Exception e) {
                this.log().warn(new StringBuilder(16).append(e.getMessage()).append(", begin to retry").toString());
                Thread.sleep(1000L);
                continue;
            }
        }
        return fs.exists(path);
    }

    public static final /* synthetic */ void $anonfun$deleteFilesWithCheck$1(FileContext context$1, FileStatus fs) {
        context$1.delete(fs.getPath(), true);
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Delete file ").append(fs.getPath()).toString());
    }

    private HDFSUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

