/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.schema.ReloadTableContext;
import org.apache.kylin.metadata.streaming.DataParserInfo;
import org.apache.kylin.metadata.streaming.DataParserManager;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.StreamingRequest;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.TableUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="streamingTableService")
public class StreamingTableService
extends TableService {
    @Autowired
    private AclEvaluate aclEvaluate;

    @Transaction(project=0, retry=1)
    public void reloadTable(String project, TableDesc tableDesc, TableExtDesc extDesc) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.innerReloadTable(project, tableDesc, extDesc);
    }

    @Transaction(project=0)
    List<String> innerReloadTable(String project, TableDesc tableDesc, TableExtDesc extDesc) {
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        String tableIdentity = tableDesc.getIdentity();
        TableDesc originTable = tableManager.getTableDesc(tableIdentity);
        Preconditions.checkNotNull((Object)originTable, (Object)String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableIdentity));
        ArrayList jobs = Lists.newArrayList();
        ReloadTableContext context = new ReloadTableContext();
        context.setTableDesc(tableDesc);
        context.setTableExtDesc(extDesc);
        this.mergeTable(project, context, false);
        return jobs;
    }

    @Transaction(project=0)
    public void createKafkaConfig(String project, KafkaConfig kafkaConfig) {
        this.aclEvaluate.checkProjectWritePermission(project);
        ((KafkaConfigManager)this.getManager(KafkaConfigManager.class, project)).createKafkaConfig(kafkaConfig);
        DataParserManager manager = (DataParserManager)this.getManager(DataParserManager.class, project);
        manager.initDefault();
        DataParserInfo info = manager.getDataParserInfo(kafkaConfig.getParserName());
        DataParserInfo copyInfo = manager.copyForWrite(info);
        copyInfo.getStreamingTables().add(kafkaConfig.resourceName());
        manager.updateDataParserInfo(copyInfo);
    }

    @Transaction(project=0)
    public void updateKafkaConfig(String project, KafkaConfig kafkaConfig) {
        this.aclEvaluate.checkProjectWritePermission(project);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        KafkaConfigManager.getInstance((KylinConfig)kylinConfig, (String)project).updateKafkaConfig(kafkaConfig);
    }

    @Transaction(project=0)
    public void decimalConvertToDouble(String project, StreamingRequest streamingRequest) {
        this.aclEvaluate.checkProjectWritePermission(project);
        Arrays.stream(streamingRequest.getTableDesc().getColumns()).forEach(column -> {
            if (StringUtils.equalsIgnoreCase((CharSequence)"decimal", (CharSequence)column.getDatatype())) {
                column.setDatatype("double");
            }
        });
    }

    public void checkColumns(StreamingRequest streamingRequest) {
        String batchTableName = streamingRequest.getKafkaConfig().getBatchTable();
        String project = streamingRequest.getProject();
        if (!StringUtils.isEmpty((CharSequence)batchTableName)) {
            TableDesc batchTableDesc = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getTableDesc(batchTableName);
            if (!this.checkColumnsMatch(batchTableDesc.getColumns(), streamingRequest.getTableDesc().getColumns())) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.RELOAD_TABLE_FAILED, String.format(Locale.ROOT, MsgPicker.getMsg().getBatchStreamTableNotMatch(), batchTableName));
            }
            TableUtils.checkTimestampColumn((TableDesc)batchTableDesc);
            streamingRequest.getTableDesc().setColumns((ColumnDesc[])batchTableDesc.getColumns().clone());
        } else {
            TableUtils.checkTimestampColumn((TableDesc)streamingRequest.getTableDesc());
        }
    }

    private boolean checkColumnsMatch(ColumnDesc[] batchColumnDescs, ColumnDesc[] streamColumnDescs) {
        if (batchColumnDescs.length != streamColumnDescs.length) {
            return false;
        }
        List batchColumns = Arrays.stream(batchColumnDescs).map(ColumnDesc::getName).sorted().collect(Collectors.toList());
        List streamColumns = Arrays.stream(streamColumnDescs).map(ColumnDesc::getName).sorted().collect(Collectors.toList());
        return batchColumns.equals(streamColumns);
    }
}

