/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.AddCredentialToSparkBroadcastEventNotifier;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.LinkedHashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.graph.Graph;
import org.apache.kylin.guava30.shaded.common.graph.Graphs;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.NSegmentConfigHelper;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.function.LikeMatchers;
import org.apache.kylin.metadata.model.AutoMergeTimeEnum;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.VolatileRange;
import org.apache.kylin.metadata.model.exception.IllegalCCExpressionException;
import org.apache.kylin.metadata.model.schema.AffectedModelContext;
import org.apache.kylin.metadata.model.schema.ReloadTableContext;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.metadata.streaming.DataParserManager;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.constant.JobInfoEnum;
import org.apache.kylin.rest.request.AutoMergeRequest;
import org.apache.kylin.rest.request.DateRangeRequest;
import org.apache.kylin.rest.request.S3TableExtInfo;
import org.apache.kylin.rest.request.TableDescRequest;
import org.apache.kylin.rest.response.AutoMergeConfigResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.response.NHiveTableNameResponse;
import org.apache.kylin.rest.response.NInitTablesResponse;
import org.apache.kylin.rest.response.OpenPreReloadTableResponse;
import org.apache.kylin.rest.response.PreReloadTableResponse;
import org.apache.kylin.rest.response.PreUnloadTableResponse;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.response.TableRefresh;
import org.apache.kylin.rest.response.TableRefreshAll;
import org.apache.kylin.rest.response.TablesAndColumnsResponse;
import org.apache.kylin.rest.security.KerberosLoginManager;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRServiceSupporter;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.InternalTableService;
import org.apache.kylin.rest.service.JobSupporter;
import org.apache.kylin.rest.service.KafkaService;
import org.apache.kylin.rest.service.TableFusionModelSupporter;
import org.apache.kylin.rest.service.TableIndexPlanSupporter;
import org.apache.kylin.rest.service.TableModelSupporter;
import org.apache.kylin.rest.service.TableSampleService;
import org.apache.kylin.rest.source.DataSourceState;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.rest.util.TableUtils;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="tableService")
public class TableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    private static final String REFRESH_SINGLE_CATALOG_PATH = "/kylin/api/query/single_catalog_cache";
    private static final String SSB_ERROR_MSG = "import ssb data error.";
    @Autowired
    private TableModelSupporter modelService;
    @Autowired
    private TableFusionModelSupporter fusionModelService;
    @Autowired
    private TableIndexPlanSupporter indexPlanService;
    @Autowired
    private TableSampleService tableSampleService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private AccessService accessService;
    @Autowired(required=false)
    @Qualifier(value="kafkaService")
    private KafkaService kafkaService;
    @Autowired(required=false)
    @Qualifier(value="aclTCRService")
    private AclTCRServiceSupporter aclTCRService;
    @Autowired(required=false)
    @Qualifier(value="jobInfoService")
    private JobSupporter jobInfoService;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private InternalTableService internalTableService;

    public Pair<List<TableDesc>, Integer> getTableDesc(String project, boolean withExt, String table, String database, boolean isFuzzy, List<Integer> sourceType, int returnTableSize) throws IOException {
        TableDescRequest internalTableDescRequest = new TableDescRequest(project, withExt, table, database, isFuzzy, sourceType);
        return this.getTableDesc(internalTableDescRequest, returnTableSize);
    }

    public Pair<List<TableDesc>, Integer> getTableDesc(TableDescRequest tableDescRequest, int returnTableSize) throws IOException {
        this.aclEvaluate.checkProjectReadPermission(tableDescRequest.getProject());
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        NTableMetadataManager nTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, tableDescRequest.getProject());
        ArrayList tables = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)tableDescRequest.getTable()) && !tableDescRequest.isFuzzy()) {
            TableDesc tableDesc2 = nTableMetadataManager.getTableDesc(tableDescRequest.getDatabase() + "." + tableDescRequest.getTable());
            if (tableDesc2 != null && tableDesc2.isAccessible(streamingEnabled)) {
                tables.add(tableDesc2);
            }
        } else {
            tables.addAll(nTableMetadataManager.listAllTables().stream().filter(tableDesc -> {
                if (StringUtils.isEmpty((CharSequence)tableDescRequest.getDatabase())) {
                    return true;
                }
                return tableDesc.getDatabase().equalsIgnoreCase(tableDescRequest.getDatabase());
            }).filter(tableDesc -> {
                if (StringUtils.isEmpty((CharSequence)tableDescRequest.getTable())) {
                    return true;
                }
                return tableDesc.getName().toLowerCase(Locale.ROOT).contains(tableDescRequest.getTable().toLowerCase(Locale.ROOT));
            }).filter(tableDesc -> {
                List sourceTypes = tableDescRequest.getSourceType();
                if (!sourceTypes.isEmpty()) {
                    return sourceTypes.contains(tableDesc.getSourceType()) || sourceTypes.stream().flatMap(st -> this.getConfig().getSourceProviderFamily(st.intValue()).stream()).collect(Collectors.toList()).contains(tableDesc.getSourceType());
                }
                return true;
            }).filter(table -> table.isAccessible(streamingEnabled)).sorted(this::compareTableDesc).collect(Collectors.toList()));
        }
        return this.getTablesResponse(tables, tableDescRequest, returnTableSize);
    }

    public int compareTableDesc(TableDesc table1, TableDesc table2) {
        if (table1.isTop() == table2.isTop()) {
            if (table1.isIncrementLoading() == table2.isIncrementLoading()) {
                return table1.getName().compareToIgnoreCase(table2.getName());
            }
            return table1.isIncrementLoading() && !table2.isIncrementLoading() ? -1 : 1;
        }
        return table1.isTop() && !table2.isTop() ? -1 : 1;
    }

    @Transaction(project=2)
    public String loadTableToProject(TableDesc tableDesc, TableExtDesc extDesc, String project) {
        NTableMetadataManager tableMetaMgr = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        HashSet<TableExtDesc.RoleCredentialInfo> broadcastConf = new HashSet<TableExtDesc.RoleCredentialInfo>();
        TableDesc origTable = tableMetaMgr.getTableDesc(tableDesc.getIdentity());
        TableDesc nTableDesc = new TableDesc(tableDesc);
        if (origTable == null || origTable.getProject() == null) {
            nTableDesc.setUuid(RandomUtil.randomUUIDStr());
            nTableDesc.setLastModified(0L);
            tableMetaMgr.saveSourceTable(nTableDesc);
        } else {
            tableMetaMgr.updateTableDesc(nTableDesc.getIdentity(), copyForWrite -> {
                nTableDesc.copyPropertiesTo((RootPersistentEntity)copyForWrite);
                copyForWrite.setUuid(origTable.getUuid());
                copyForWrite.setLastModified(origTable.getLastModified());
                copyForWrite.setIncrementLoading(origTable.isIncrementLoading());
                copyForWrite.setTableComment(tableDesc.getTableComment());
            });
        }
        if (extDesc != null) {
            Map<String, Integer> colNameMap = Stream.of(nTableDesc.getColumns()).collect(Collectors.toMap(ColumnDesc::getName, col -> {
                try {
                    return Integer.parseInt(col.getId());
                }
                catch (NumberFormatException e) {
                    return Integer.MAX_VALUE;
                }
            }));
            TableExtDesc origExt = tableMetaMgr.getTableExtIfExists(tableDesc);
            TableExtDesc nTableExtDesc = new TableExtDesc(extDesc);
            if (origExt == null || origExt.getProject() == null) {
                nTableExtDesc.setUuid(RandomUtil.randomUUIDStr());
                nTableExtDesc.setLastModified(0L);
                nTableExtDesc.getAllColumnStats().sort(Comparator.comparing(stat -> colNameMap.getOrDefault(stat.getColumnName(), -1)));
                nTableExtDesc.init(project);
                tableMetaMgr.saveTableExt(nTableExtDesc);
            } else {
                tableMetaMgr.updateTableExt(nTableExtDesc.getIdentity(), copyForWrite -> {
                    nTableExtDesc.copyPropertiesTo((RootPersistentEntity)copyForWrite);
                    copyForWrite.setUuid(origExt.getUuid());
                    copyForWrite.setLastModified(origExt.getLastModified());
                    copyForWrite.setMvcc(origExt.getMvcc());
                    copyForWrite.setOriginalSize(origExt.getOriginalSize());
                    copyForWrite.getAllColumnStats().sort(Comparator.comparing(stat -> colNameMap.getOrDefault(stat.getColumnName(), -1)));
                    copyForWrite.init(project);
                });
            }
            if (!broadcastConf.contains(extDesc.getRoleCredentialInfo())) {
                this.addAndBroadcastSparkSession(extDesc.getRoleCredentialInfo());
                broadcastConf.add(extDesc.getRoleCredentialInfo());
            }
        }
        return tableDesc.getIdentity();
    }

    public List<Pair<TableDesc, TableExtDesc>> extractTableMeta(String[] tables, String project) {
        return this.extractTableMeta(tables, project, null);
    }

    public List<Pair<TableDesc, TableExtDesc>> extractTableMeta(String[] tables, String project, LoadTableResponse tableResponse) {
        LinkedHashMultimap databaseTables = LinkedHashMultimap.create();
        for (String fullTableName : tables) {
            String[] parts = HadoopUtil.parseHiveTableName((String)fullTableName.toUpperCase(Locale.ROOT));
            Preconditions.checkArgument((!parts[1].isEmpty() && !parts[0].isEmpty() ? 1 : 0) != 0, (Object)MsgPicker.getMsg().getTableParamEmpty());
            databaseTables.put((Object)parts[0], (Object)parts[1]);
        }
        ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
        List<Pair<TableDesc, TableExtDesc>> successResults = Collections.synchronizedList(new ArrayList());
        List failedTableNames = Collections.synchronizedList(new ArrayList());
        databaseTables.entries().parallelStream().forEach(entry -> {
            try {
                Pair pair = explr.loadTableMetadata((String)entry.getKey(), (String)entry.getValue(), project);
                TableDesc tableDesc = (TableDesc)pair.getFirst();
                Preconditions.checkState((boolean)tableDesc.getDatabase().equalsIgnoreCase((String)entry.getKey()));
                Preconditions.checkState((boolean)tableDesc.getName().equalsIgnoreCase((String)entry.getValue()));
                Preconditions.checkState((boolean)tableDesc.getIdentity().equals(((String)entry.getKey()).toUpperCase(Locale.ROOT) + "." + ((String)entry.getValue()).toUpperCase(Locale.ROOT)));
                TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
                Preconditions.checkState((boolean)tableDesc.getIdentity().equals(extDesc.getIdentity()));
                successResults.add(pair);
            }
            catch (Exception e) {
                logger.error("Failed to extract meta data of table:{}.{}", new Object[]{entry.getKey(), entry.getValue(), e});
                failedTableNames.add((String)entry.getKey() + "." + (String)entry.getValue());
            }
        });
        if (!failedTableNames.isEmpty()) {
            String errorTables = StringUtils.join(failedTableNames, (String)"\n");
            String errorMessage = String.format(Locale.ROOT, MsgPicker.getMsg().getHiveTableNotFound(), errorTables);
            if (Objects.isNull(tableResponse)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, errorMessage);
            }
            tableResponse.getFailed().addAll(failedTableNames);
            logger.error("Skip load these failed tables:\n{}", (Object)errorTables);
        }
        return successResults;
    }

    public List<String> getSourceDbNames(String project) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)((NProjectManager)this.getManager(NProjectManager.class)).getProject(project)).getSourceMetadataExplorer();
        return explr.listDatabases().stream().map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public List<String> getSourceTableNames(String project, String database, String table) throws Exception {
        ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)((NProjectManager)this.getManager(NProjectManager.class)).getProject(project)).getSourceMetadataExplorer();
        return explr.listTables(database).stream().filter(s -> {
            if (StringUtils.isEmpty((CharSequence)table)) {
                return true;
            }
            return s.toLowerCase(Locale.ROOT).contains(table.toLowerCase(Locale.ROOT));
        }).map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public List<TableNameResponse> getTableNameResponses(String project, String database, String table) throws Exception {
        this.aclEvaluate.checkProjectReadPermission(project);
        ArrayList<TableNameResponse> tableNameResponses = new ArrayList<TableNameResponse>();
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        List<String> tables = this.getSourceTableNames(project, database, table);
        for (String tableName : tables) {
            TableNameResponse tableNameResponse = new TableNameResponse();
            tableNameResponse.setTableName(tableName);
            String tableNameWithDB = database + "." + tableName;
            this.checkTableExistOrLoad(tableNameResponse, tableManager.getTableDesc(tableNameWithDB));
            tableNameResponses.add(tableNameResponse);
        }
        return tableNameResponses;
    }

    private TableDescResponse getTableResponse(TableDesc table, String project, boolean withExt) {
        if (!withExt) {
            return new TableDescResponse(table);
        }
        TableDescResponse tableDescResponse = new TableDescResponse(table);
        TableExtDesc tableExtDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableExtIfExists(table);
        if (table.isKafkaTable()) {
            tableDescResponse.setKafkaBootstrapServers(table.getKafkaConfig().getKafkaBootstrapServers());
            tableDescResponse.setSubscribe(table.getKafkaConfig().getSubscribe());
            tableDescResponse.setBatchTable(table.getKafkaConfig().getBatchTable());
            tableDescResponse.setParserName(table.getKafkaConfig().getParserName());
        }
        if (tableExtDesc == null) {
            return tableDescResponse;
        }
        for (TableDescResponse.ColumnDescResponse colDescResponse : tableDescResponse.getExtColumns()) {
            TableExtDesc.ColumnStats columnStats = tableExtDesc.getColumnStatsByName(colDescResponse.getName());
            colDescResponse.setExcluded(tableExtDesc.isExcludedCol(colDescResponse.getName()));
            if (columnStats == null) continue;
            colDescResponse.setCardinality(Long.valueOf(columnStats.getCardinality()));
            colDescResponse.setMaxValue(columnStats.getMaxValue());
            colDescResponse.setMinValue(columnStats.getMinValue());
            colDescResponse.setNullCount(Long.valueOf(columnStats.getNullCount()));
        }
        tableDescResponse.setDescExd(tableExtDesc.getDataSourceProps());
        tableDescResponse.setCreateTime(tableExtDesc.getCreateTime());
        tableDescResponse.setExcluded(tableExtDesc.isExcluded());
        return tableDescResponse;
    }

    private Pair<List<TableDesc>, Integer> getTablesResponse(List<TableDesc> tables, TableDescRequest tableDescRequest, int returnTableSize) {
        String project = tableDescRequest.getProject();
        boolean withExt = tableDescRequest.isWithExt();
        List sourceTypesRequest = tableDescRequest.getSourceType();
        ArrayList<TableDescResponse> descs = new ArrayList<TableDescResponse>();
        NProjectManager projectManager = (NProjectManager)this.getManager(NProjectManager.class);
        Set groups = this.getCurrentUserGroups();
        List aclTCRS = ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAclTCRs(AclPermissionUtil.getCurrentUsername(), groups);
        boolean isAclGreen = AclPermissionUtil.canUseACLGreenChannel((String)project, (Set)groups);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        List healthyModels = projectManager.listHealthyModels(project);
        Set extPermissionSet = this.accessService.getUserNormalExtPermissions(project);
        int satisfiedTableSize = 0;
        boolean hasDataQueryPermission = extPermissionSet.contains("DATA_QUERY");
        for (TableDesc originTable : tables) {
            if (satisfiedTableSize == returnTableSize) {
                return Pair.newPair(descs, (Object)tables.size());
            }
            TableDesc table = this.getAuthorizedTableDesc(project, isAclGreen, originTable, aclTCRS);
            if (Objects.isNull(table)) continue;
            TableDescResponse tableDescResponse = this.getTableResponse(table, project, withExt);
            List<NDataModel> modelsUsingTable = healthyModels.stream().filter(model -> model.containsTable(table)).collect(Collectors.toList());
            List<NDataModel> modelsUsingRootTable = healthyModels.stream().filter(model -> model.isRootFactTable(table)).collect(Collectors.toList());
            TableExtDesc tableExtDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableExtIfExists(table);
            if (tableExtDesc != null) {
                tableDescResponse.setTotalRecords(tableExtDesc.getTotalRows());
                tableDescResponse.setJodID(tableExtDesc.getJodID());
                if (hasDataQueryPermission) {
                    tableDescResponse.setSamplingRows(tableExtDesc.getSampleRows());
                    this.filterSamplingRows(project, tableDescResponse, isAclGreen, aclTCRS);
                }
            }
            if (CollectionUtils.isNotEmpty(modelsUsingRootTable)) {
                tableDescResponse.setRootFact(true);
                tableDescResponse.setStorageSize(this.getStorageSize(project, modelsUsingRootTable, fs));
            } else if (CollectionUtils.isNotEmpty(modelsUsingTable)) {
                tableDescResponse.setLookup(true);
                tableDescResponse.setStorageSize(this.getSnapshotSize(project, table.getIdentity(), fs));
            }
            Pair<Set<String>, Set<String>> tableColumnType = this.getTableColumnType(project, table, modelsUsingTable);
            tableDescResponse.setForeignKey((Set)tableColumnType.getSecond());
            tableDescResponse.setPrimaryKey((Set)tableColumnType.getFirst());
            sourceTypesRequest.stream().filter(stq -> this.getConfig().getSourceProviderFamily(stq.intValue()).contains(originTable.getSourceType())).findFirst().ifPresent(arg_0 -> ((TableDescResponse)tableDescResponse).setSourceType(arg_0));
            descs.add(tableDescResponse);
            ++satisfiedTableSize;
        }
        return Pair.newPair(descs, (Object)descs.size());
    }

    @VisibleForTesting
    void filterSamplingRows(String project, TableDescResponse rtableDesc, boolean isAclGreen, List<AclTCR> aclTCRS) {
        if (isAclGreen) {
            return;
        }
        ArrayList result = Lists.newArrayList();
        String dbTblName = rtableDesc.getIdentity();
        AclTCRManager manager = (AclTCRManager)this.getManager(AclTCRManager.class, project);
        Map<Integer, AclTCR.ColumnRealRows> columnRows = Arrays.stream(rtableDesc.getExtColumns()).map(cdr -> {
            int id = Integer.parseInt(cdr.getId());
            AclTCR.ColumnRealRows columnRealRows = manager.getAuthorizedRows(dbTblName, cdr.getName(), aclTCRS);
            return new AbstractMap.SimpleEntry<Integer, AclTCR.ColumnRealRows>(id, columnRealRows);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (String[] row : rtableDesc.getSamplingRows()) {
            if (Objects.isNull(row)) continue;
            int i = 0;
            boolean jumpThisSample = false;
            ArrayList nlist = Lists.newArrayList();
            while (i++ < row.length) {
                if (!columnRows.containsKey(i)) continue;
                AclTCR.ColumnRealRows columnRealRows = columnRows.get(i);
                if (Objects.isNull(columnRealRows)) {
                    jumpThisSample = true;
                    break;
                }
                AclTCR.RealRow equalRows = columnRealRows.getRealRow();
                AclTCR.RealRow likeRows = columnRealRows.getRealLikeRow();
                if (CollectionUtils.isNotEmpty((Collection)equalRows) && !equalRows.contains(row[i - 1]) || CollectionUtils.isNotEmpty((Collection)likeRows) && TableService.noMatchedLikeCondition(row[i - 1], (Set<String>)likeRows)) {
                    jumpThisSample = true;
                    break;
                }
                nlist.add(row[i - 1]);
            }
            if (jumpThisSample || !CollectionUtils.isNotEmpty((Collection)nlist)) continue;
            result.add(nlist.toArray(new String[0]));
        }
        rtableDesc.setSamplingRows((List)result);
    }

    private static boolean noMatchedLikeCondition(String target, Set<String> likePatterns) {
        for (String likePattern : likePatterns) {
            LikeMatchers.DefaultLikeMatcher matcher = new LikeMatchers.DefaultLikeMatcher(likePattern, "\\");
            if (!matcher.matches(target)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    TableDesc getAuthorizedTableDesc(String project, boolean isAclGreen, TableDesc originTable, List<AclTCR> aclTCRS) {
        if (isAclGreen) {
            return originTable;
        }
        return ((AclTCRManager)this.getManager(AclTCRManager.class, project)).getAuthorizedTableDesc(originTable, aclTCRS);
    }

    public long getSnapshotSize(String project, String table, FileSystem fs) {
        TableDesc tableDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(table);
        if (tableDesc != null && tableDesc.getLastSnapshotPath() != null) {
            try {
                Path path = new Path(KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv()).getMetadataWorkingDirectory(), tableDesc.getLastSnapshotPath());
                return HadoopUtil.getContentSummary((FileSystem)fs, (Path)path).getLength();
            }
            catch (Exception e) {
                logger.warn("cannot get snapshot path {}", (Object)tableDesc.getLastSnapshotPath(), (Object)e);
            }
        }
        return 0L;
    }

    private long getStorageSize(String project, List<NDataModel> models, FileSystem fs) {
        NDataflowManager dfManger = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        long size = 0L;
        for (NDataModel model : models) {
            NDataflow df = dfManger.getDataflow(model.getUuid());
            if (df == null) {
                logger.warn("cannot get model size  {} of {}\uff08might be deleted\uff09 ", (Object)model.getAlias(), (Object)project);
                continue;
            }
            Segments readySegs = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
            if (!CollectionUtils.isNotEmpty((Collection)readySegs)) continue;
            for (NDataSegment segment : readySegs) {
                size += segment.getStorageBytesSize();
            }
        }
        return size;
    }

    private Pair<Set<String>, Set<String>> getTableColumnType(String project, TableDesc table, List<NDataModel> modelsUsingTable) {
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        HashSet<String> primaryKey = new HashSet<String>();
        HashSet<String> foreignKey = new HashSet<String>();
        block0: for (NDataModel model : modelsUsingTable) {
            NDataModel dataMode = dataModelManager.getDataModelDesc(model.getUuid());
            if (dataMode == null) continue;
            List joinTables = dataMode.getJoinTables();
            for (JoinTableDesc joinTable : joinTables) {
                if (!joinTable.getTable().equals(table.getIdentity())) continue;
                foreignKey.addAll(Arrays.asList(joinTable.getJoin().getForeignKey()));
                primaryKey.addAll(Arrays.asList(joinTable.getJoin().getPrimaryKey()));
                continue block0;
            }
        }
        Pair result = new Pair();
        result.setFirst(primaryKey);
        result.setSecond(foreignKey);
        return result;
    }

    public String normalizeHiveTableName(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        return (dbTableName[0] + "." + dbTableName[1]).toUpperCase(Locale.ROOT);
    }

    public String getPartitionColumnFormat(String project, String table, String partitionColumn, String partitionExpression) throws Exception {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableDesc tableDesc = tableManager.getTableDesc(table);
        Preconditions.checkNotNull((Object)tableDesc, (Object)String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), table));
        Set columnSet = Stream.of(tableDesc.getColumns()).map(ColumnDesc::getName).map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        if (!columnSet.contains(StringUtils.upperCase((String)partitionColumn))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, "Can not find the column:%s in table:%s, project:%s", partitionColumn, table, project));
        }
        try {
            if (tableDesc.isKafkaTable()) {
                List<ByteBuffer> messages = this.kafkaService.getMessages(tableDesc.getKafkaConfig(), project);
                this.checkMessage(table, messages);
                Map<String, Object> resp = this.kafkaService.decodeMessage(messages);
                String message = (String)((List)resp.get("message")).get(0);
                Map<String, Object> mapping = this.kafkaService.parserMessage(project, tableDesc.getKafkaConfig(), message);
                HashMap mappingAllCaps = new HashMap();
                mapping.forEach((key, value) -> mappingAllCaps.put(key.toUpperCase(Locale.ROOT), value));
                String cell = (String)mappingAllCaps.get(partitionColumn);
                return DateFormat.proposeDateFormat((String)cell);
            }
            if (partitionExpression == null) {
                List list = PushDownUtil.backtickQuote((String[])partitionColumn.split("\\."));
                String cell = PushDownUtil.probeColFormat((String)table, (String)String.join((CharSequence)".", list), (String)project);
                return DateFormat.proposeDateFormat((String)cell);
            }
            String cell = PushDownUtil.probeExpFormat((String)table, (String)partitionExpression, (String)project);
            return DateFormat.proposeDateFormat((String)cell);
        }
        catch (KylinException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to get date format.", (Throwable)e);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARTITION_COLUMN, MsgPicker.getMsg().getPushdownPartitionFormatError());
        }
    }

    private void checkMessage(String table, List<ByteBuffer> messages) {
        if (messages == null || messages.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.EMPTY_TABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getNoDataInTable(), table));
        }
    }

    @VisibleForTesting
    public SegmentRange getSegmentRangeByTable(DateRangeRequest dateRangeRequest) {
        String project = dateRangeRequest.getProject();
        String table = dateRangeRequest.getTable();
        NTableMetadataManager nProjectManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableDesc tableDesc = nProjectManager.getTableDesc(table);
        return SourceFactory.getSource((ISourceAware)tableDesc).getSegmentRange(dateRangeRequest.getStart(), dateRangeRequest.getEnd());
    }

    private List<AbstractExecutable> stopAndGetSnapshotJobs(String project, String table) {
        ExecutableManager execManager = (ExecutableManager)this.getManager(ExecutableManager.class, project);
        List jobInfoList = execManager.fetchJobsByTypesAndStates(project, (List)Lists.newArrayList((Object[])new String[]{JobTypeEnum.SNAPSHOT_BUILD.name(), JobTypeEnum.SNAPSHOT_REFRESH.name()}), (List)Lists.newArrayList((Object[])new String[]{table}), ExecutableState.getNotFinalStates());
        List conflictJobIds = jobInfoList.stream().map(jobInfo -> jobInfo.getJobId()).collect(Collectors.toList());
        JobContextUtil.remoteDiscardJob((String)project, conflictJobIds);
        return jobInfoList.stream().map(jobInfo -> execManager.fromPO(JobInfoUtil.deserializeExecutablePO((JobInfo)jobInfo))).collect(Collectors.toList());
    }

    @Transaction(project=0)
    public String unloadTable(String project, String table, Boolean cascade) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableDesc tableDesc = tableMetadataManager.getTableDesc(table);
        if (Objects.isNull(tableDesc)) {
            String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), table);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, errorMsg);
        }
        this.stopAndGetSnapshotJobs(project, table);
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        if (cascade.booleanValue()) {
            for (NDataModel tableRelatedModel : dataflowManager.getModelsUsingTable(tableDesc)) {
                this.fusionModelService.onDropModel(tableRelatedModel.getId(), project, true);
            }
            this.unloadKafkaTableUsingTable(project, tableDesc);
        } else {
            this.stopStreamingJobByTable(project, tableDesc);
            this.jobInfoService.stopBatchJob(project, tableDesc);
        }
        this.unloadTable(project, table);
        this.aclTCRService.unloadTable(project, table);
        NProjectManager npr = (NProjectManager)this.getManager(NProjectManager.class);
        ProjectInstance projectInstance = npr.getProject(project);
        Set databases = this.getLoadedDatabases(project).stream().map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        if (tableDesc.getDatabase().equals(projectInstance.getDefaultDatabase()) && !databases.contains(projectInstance.getDefaultDatabase())) {
            npr.updateProject(project, copyForWrite -> copyForWrite.setDefaultDatabase("DEFAULT"));
        }
        return tableDesc.getIdentity();
    }

    private void unloadKafkaTableUsingTable(String project, TableDesc tableDesc) {
        if (tableDesc.getSourceType() != 9) {
            return;
        }
        KafkaConfigManager kafkaConfigManger = (KafkaConfigManager)this.getManager(KafkaConfigManager.class, project);
        for (KafkaConfig kafkaConfig : kafkaConfigManger.getKafkaTablesUsingTable(tableDesc.getIdentity())) {
            this.unloadTable(project, kafkaConfig.getIdentity());
        }
    }

    private void stopStreamingJobByTable(String project, TableDesc tableDesc) {
        for (NDataModel tableRelatedModel : ((NDataflowManager)this.getManager(NDataflowManager.class, project)).getModelsUsingTable(tableDesc)) {
            this.fusionModelService.onStopStreamingJob(tableRelatedModel.getId(), project);
        }
    }

    public void unloadTable(String project, String tableIdentity) {
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        if (tableMetadataManager.getTableDesc(tableIdentity).isHasInternal()) {
            this.internalTableService.dropInternalTable(project, tableIdentity);
        }
        ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).removeTableExt(tableIdentity);
        ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).removeSourceTable(tableIdentity);
        KafkaConfigManager kafkaConfigManager = (KafkaConfigManager)this.getManager(KafkaConfigManager.class, project);
        KafkaConfig kafkaConfig = kafkaConfigManager.getKafkaConfig(tableIdentity);
        if (Objects.isNull(kafkaConfig)) {
            return;
        }
        kafkaConfigManager.removeKafkaConfig(tableIdentity);
        ((DataParserManager)this.getManager(DataParserManager.class, project)).removeUsingTable(tableIdentity, kafkaConfig.getParserName());
    }

    public PreUnloadTableResponse preUnloadTable(String project, String tableIdentity) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        PreUnloadTableResponse response = new PreUnloadTableResponse();
        NDataflowManager dataflowManager = (NDataflowManager)this.getManager(NDataflowManager.class, project);
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        ExecutableManager executableManager = (ExecutableManager)this.getManager(ExecutableManager.class, project);
        TableDesc tableDesc = tableMetadataManager.getTableDesc(tableIdentity);
        if (Objects.isNull(tableDesc)) {
            String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableIdentity);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, errorMsg);
        }
        List models = dataflowManager.getModelsUsingTable(tableDesc).stream().filter(Objects::nonNull).map(model -> model.fusionModelBatchPart() ? model.getFusionModelAlias() : model.getAlias()).collect(Collectors.toList());
        response.setHasModel(CollectionUtils.isNotEmpty(models));
        response.setModels(models);
        List rootTableModels = dataflowManager.getModelsUsingRootTable(tableDesc);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        long storageSize = 0L;
        if (CollectionUtils.isNotEmpty((Collection)rootTableModels)) {
            storageSize += this.getStorageSize(project, rootTableModels, fs);
        }
        response.setStorageSize(storageSize += this.getSnapshotSize(project, tableIdentity, fs));
        response.setHasJob(executableManager.countByModelAndStatus(tableIdentity, state -> state == ExecutableState.RUNNING) > 0L);
        response.setHasSnapshot(tableDesc.getLastSnapshotPath() != null);
        return response;
    }

    @Transaction(project=1)
    public void setTop(String table, String project, boolean top) {
        this.aclEvaluate.checkProjectWritePermission(project);
        NTableMetadataManager nTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableDesc tableDesc = nTableMetadataManager.getTableDesc(table);
        tableDesc = nTableMetadataManager.copyForWrite(tableDesc);
        tableDesc.setTop(top);
        nTableMetadataManager.updateTableDesc(tableDesc);
    }

    public List<TablesAndColumnsResponse> getTableAndColumns(String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        List tables = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).listAllTables();
        ArrayList<TablesAndColumnsResponse> result = new ArrayList<TablesAndColumnsResponse>();
        for (TableDesc table : tables) {
            TablesAndColumnsResponse response = new TablesAndColumnsResponse();
            response.setTable(table.getName());
            response.setDatabase(table.getDatabase());
            ColumnDesc[] columns = table.getColumns();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (ColumnDesc column : columns) {
                columnNames.add(column.getName());
            }
            response.setColumns(columnNames);
            result.add(response);
        }
        return result;
    }

    public AutoMergeConfigResponse getAutoMergeConfigByModel(String project, String modelId) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        AutoMergeConfigResponse mergeConfig = new AutoMergeConfigResponse();
        NDataModel model = dataModelManager.getDataModelDesc(modelId);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        SegmentConfig segmentConfig = NSegmentConfigHelper.getModelSegmentConfig((String)project, (String)modelId);
        Preconditions.checkState((segmentConfig != null ? 1 : 0) != 0);
        mergeConfig.setAutoMergeEnabled(segmentConfig.getAutoMergeEnabled().booleanValue());
        mergeConfig.setAutoMergeTimeRanges(segmentConfig.getAutoMergeTimeRanges());
        mergeConfig.setVolatileRange(segmentConfig.getVolatileRange());
        return mergeConfig;
    }

    @Transaction(project=0)
    public void setAutoMergeConfigByModel(String project, AutoMergeRequest autoMergeRequest) {
        this.aclEvaluate.checkProjectWritePermission(project);
        String modelId = autoMergeRequest.getModel();
        NDataModelManager dataModelManager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        ArrayList<AutoMergeTimeEnum> autoMergeRanges = new ArrayList<AutoMergeTimeEnum>();
        for (String range : autoMergeRequest.getAutoMergeTimeRanges()) {
            autoMergeRanges.add(AutoMergeTimeEnum.valueOf((String)range));
        }
        VolatileRange volatileRange = new VolatileRange();
        volatileRange.setVolatileRangeType(AutoMergeTimeEnum.valueOf((String)autoMergeRequest.getVolatileRangeType()));
        volatileRange.setVolatileRangeEnabled(autoMergeRequest.isVolatileRangeEnabled());
        volatileRange.setVolatileRangeNumber(autoMergeRequest.getVolatileRangeNumber());
        NDataModel model = dataModelManager.getDataModelDesc(modelId);
        if (model == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
        }
        if (ManagementType.MODEL_BASED == model.getManagementType()) {
            NDataModel modelUpdate = dataModelManager.copyForWrite(model);
            SegmentConfig segmentConfig = modelUpdate.getSegmentConfig();
            segmentConfig.setVolatileRange(volatileRange);
            segmentConfig.setAutoMergeTimeRanges(autoMergeRanges);
            segmentConfig.setAutoMergeEnabled(Boolean.valueOf(autoMergeRequest.isAutoMergeEnabled()));
            dataModelManager.updateDataModelDesc(modelUpdate);
        }
    }

    public OpenPreReloadTableResponse preProcessBeforeReloadWithoutFailFast(String project, String tableIdentity, boolean needDetails) throws Exception {
        Preconditions.checkNotNull((Object)tableIdentity, (Object)"table identity can not be null");
        this.aclEvaluate.checkProjectWritePermission(project);
        ReloadTableContext context = this.calcReloadContext(project, tableIdentity.toUpperCase(Locale.ROOT), false);
        this.removeFusionModelBatchPart(project, context);
        PreReloadTableResponse preReloadTableResponse = this.preProcessBeforeReloadWithContext(project, context, needDetails);
        OpenPreReloadTableResponse openPreReloadTableResponse = new OpenPreReloadTableResponse(preReloadTableResponse);
        openPreReloadTableResponse.setDuplicatedColumns((List)Lists.newArrayList((Iterable)context.getDuplicatedColumns()));
        openPreReloadTableResponse.setEffectedJobs((List)Lists.newArrayList((Iterable)context.getEffectedJobs()));
        boolean hasDatasourceChanged = preReloadTableResponse.getAddColumnCount() + preReloadTableResponse.getRemoveColumnCount() + preReloadTableResponse.getDataTypeChangeColumnCount() > 0L;
        openPreReloadTableResponse.setHasDatasourceChanged(hasDatasourceChanged);
        openPreReloadTableResponse.setHasEffectedJobs(!context.getEffectedJobs().isEmpty());
        openPreReloadTableResponse.setHasDuplicatedColumns(!context.getDuplicatedColumns().isEmpty());
        return openPreReloadTableResponse;
    }

    public PreReloadTableResponse preProcessBeforeReloadWithFailFast(String project, String tableIdentity) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        ReloadTableContext context = this.calcReloadContext(project, tableIdentity, true);
        this.removeFusionModelBatchPart(project, context);
        return this.preProcessBeforeReloadWithContext(project, context, false);
    }

    private void removeFusionModelBatchPart(String project, ReloadTableContext context) {
        NDataModelManager manager = (NDataModelManager)this.getManager(NDataModelManager.class, project);
        context.getRemoveAffectedModels().keySet().removeIf(modelId -> manager.getDataModelDesc(modelId).fusionModelBatchPart());
    }

    private PreReloadTableResponse preProcessBeforeReloadWithContext(String project, ReloadTableContext context, boolean needDetails) {
        PreReloadTableResponse result = new PreReloadTableResponse();
        result.setAddColumnCount((long)context.getAddColumns().size());
        result.setRemoveColumnCount((long)context.getRemoveColumns().size());
        result.setRemoveDimCount(context.getRemoveAffectedModels().values().stream().map(AffectedModelContext::getDimensions).mapToLong(Set::size).sum());
        result.setDataTypeChangeColumnCount((long)context.getChangeTypeColumns().size());
        result.setTableCommentChanged(context.isTableCommentChanged());
        boolean schemaChanged = result.getAddColumnCount() > 0L || result.getRemoveColumnCount() > 0L || result.getDataTypeChangeColumnCount() > 0L;
        TableDesc originTable = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(context.getTableDesc().getIdentity());
        result.setSnapshotDeleted(schemaChanged && originTable.getLastSnapshotPath() != null);
        HashMap affectedModels = Maps.newHashMap((Map)context.getChangeTypeAffectedModels());
        affectedModels.putAll(context.getRemoveAffectedModels());
        result.setBrokenModelCount(affectedModels.values().stream().filter(AffectedModelContext::isBroken).count());
        long removeColumnAffectMeasureSum = context.getRemoveAffectedModels().values().stream().map(AffectedModelContext::getMeasures).mapToLong(Set::size).sum();
        long changeColumnTypeAffectMeasureSum = context.getChangeTypeAffectedModels().values().stream().map(AffectedModelContext::getMeasures).mapToLong(Set::size).sum();
        result.setRemoveMeasureCount(removeColumnAffectMeasureSum + changeColumnTypeAffectMeasureSum);
        result.setRemoveLayoutsCount(context.getRemoveAffectedModels().values().stream().mapToLong(m -> m.getUpdatedLayouts().size()).sum());
        result.setAddLayoutsCount(context.getRemoveAffectedModels().values().stream().mapToLong(m -> m.getAddLayouts().size()).sum());
        result.setRefreshLayoutsCount(context.getChangeTypeAffectedModels().values().stream().mapToLong(m -> Sets.difference((Set)m.getUpdatedLayouts(), (Set)context.getRemoveAffectedModel(m.getProject(), m.getModelId()).getUpdatedLayouts()).size()).sum());
        result.setUpdateBaseIndexCount(context.getChangeTypeAffectedModels().values().stream().mapToInt(m -> {
            IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)m.getProject()).getIndexPlan(m.getModelId());
            if (!indexPlan.getConfig().isBaseIndexAutoUpdate()) {
                return 0;
            }
            HashSet updateLayouts = Sets.newHashSet();
            updateLayouts.addAll(m.getUpdatedLayouts());
            updateLayouts.addAll(context.getRemoveAffectedModel(m.getProject(), m.getModelId()).getUpdatedLayouts());
            int updateBaseIndexCount = 0;
            if (updateLayouts.contains(indexPlan.getBaseAggLayoutId())) {
                ++updateBaseIndexCount;
            }
            if (updateLayouts.contains(indexPlan.getBaseTableLayoutId())) {
                ++updateBaseIndexCount;
            }
            return updateBaseIndexCount;
        }).sum());
        this.preProcessBeforeReloadDetailWithContext(result, context, needDetails);
        return result;
    }

    private void preProcessBeforeReloadDetailWithContext(PreReloadTableResponse result, ReloadTableContext context, boolean needDetails) {
        if (!needDetails) {
            return;
        }
        result.getDetails().setAddedColumns(context.getAddColumns());
        result.getDetails().setRemovedColumns(context.getRemoveColumns());
        result.getDetails().setDataTypeChangedColumns(context.getChangeTypeColumns());
        HashMap affectedModels = Maps.newHashMap((Map)context.getChangeTypeAffectedModels());
        affectedModels.putAll(context.getRemoveAffectedModels());
        result.getDetails().setBrokenModels(affectedModels.values().stream().filter(AffectedModelContext::isBroken).map(AffectedModelContext::getModelAlias).collect(Collectors.toSet()));
        result.getDetails().setRemovedMeasures(affectedModels.values().stream().flatMap(model -> model.getMeasuresKey().stream()).collect(Collectors.toSet()));
        Collection removeAffectedModelsList = context.getRemoveAffectedModels().values();
        result.getDetails().setRemovedDimensions(removeAffectedModelsList.stream().flatMap(model -> model.getDimensionsKey().stream()).collect(Collectors.toSet()));
        result.getDetails().setRemovedLayouts(removeAffectedModelsList.stream().filter(m -> !m.getUpdatedLayouts().isEmpty()).collect(Collectors.toMap(AffectedModelContext::getModelAlias, AffectedModelContext::getUpdatedLayouts)));
        result.getDetails().setAddedLayouts(removeAffectedModelsList.stream().filter(m -> !m.getAddLayouts().isEmpty()).collect(Collectors.toMap(AffectedModelContext::getModelAlias, AffectedModelContext::getAddLayouts)));
        HashMap refreshedLayouts = Maps.newHashMap();
        context.getChangeTypeAffectedModels().values().forEach(m -> {
            Sets.SetView difference = Sets.difference((Set)m.getUpdatedLayouts(), (Set)context.getRemoveAffectedModel(m.getProject(), m.getModelId()).getUpdatedLayouts());
            if (!difference.isEmpty()) {
                refreshedLayouts.put(m.getModelAlias(), difference);
            }
        });
        result.getDetails().setRefreshedLayouts((Map)refreshedLayouts);
    }

    public Pair<String, List<String>> reloadTable(String projectName, String tableIdentity, boolean needSample, int maxRows, boolean needBuild) {
        return this.reloadTable(projectName, tableIdentity, needSample, maxRows, needBuild, 3, null);
    }

    public Pair<String, List<String>> reloadTable(String projectName, String tableIdentity, boolean needSample, int maxRows, boolean needBuild, int priority, String yarnQueue) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        UnitOfWorkParams params = UnitOfWorkParams.builder().unitName(projectName).processor(() -> {
            List<String> jobIds;
            Pair pair = new Pair();
            List<String> buildingJobs = this.innerReloadTable(projectName, tableIdentity, needBuild, null);
            pair.setSecond(buildingJobs);
            if (needSample && maxRows > 0 && CollectionUtils.isNotEmpty(jobIds = this.tableSampleService.sampling(Sets.newHashSet((Object[])new String[]{tableIdentity}), projectName, maxRows, priority, yarnQueue, null))) {
                pair.setFirst((Object)jobIds.get(0));
            }
            return pair;
        }).build();
        return (Pair)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry((UnitOfWorkParams)params);
    }

    public Pair<String, List<String>> reloadAWSTableCompatibleCrossAccount(String projectName, S3TableExtInfo tableExtInfo, boolean needSample, int maxRows, boolean needBuild, int priority, String yarnQueue) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        return (Pair)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            List<String> jobIds;
            Pair pair = new Pair();
            List<String> buildingJobs = this.innerReloadTable(projectName, tableExtInfo.getName(), needBuild, tableExtInfo);
            pair.setSecond(buildingJobs);
            if (needSample && maxRows > 0 && CollectionUtils.isNotEmpty(jobIds = this.tableSampleService.sampling(Sets.newHashSet((Object[])new String[]{tableExtInfo.getName()}), projectName, maxRows, priority, yarnQueue, null))) {
                pair.setFirst((Object)jobIds.get(0));
            }
            return pair;
        }, (String)projectName);
    }

    @Transaction(project=0)
    List<String> innerReloadTable(String projectName, String tableIdentity, boolean needBuild, S3TableExtInfo tableExtInfo) throws Exception {
        String jobId;
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, projectName);
        TableDesc originTable = tableManager.getTableDesc(tableIdentity);
        Preconditions.checkNotNull((Object)originTable, (Object)String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableIdentity));
        ArrayList jobs = Lists.newArrayList();
        ReloadTableContext context = this.calcReloadContext(projectName, tableIdentity, true);
        if (null != tableExtInfo) {
            context.getTableExtDesc().addDataSourceProp(TableExtDesc.S3_ROLE_PROPERTY_KEY, tableExtInfo.getRoleArn());
            context.getTableExtDesc().addDataSourceProp(TableExtDesc.S3_ENDPOINT_KEY, tableExtInfo.getEndpoint());
        }
        if (!context.isNeedProcess()) {
            TableExtDesc tableExtDesc = tableManager.getTableExtIfExists(originTable);
            TableExtDesc targetExtDesc = context.getTableExtDesc();
            String roleArn = (String)targetExtDesc.getDataSourceProps().get(TableExtDesc.S3_ROLE_PROPERTY_KEY);
            String endpoint = (String)targetExtDesc.getDataSourceProps().get(TableExtDesc.S3_ENDPOINT_KEY);
            if (null != tableExtDesc) {
                tableManager.updateTableExt(tableIdentity, copyForWrite -> {
                    copyForWrite.addDataSourceProp(TableExtDesc.S3_ROLE_PROPERTY_KEY, roleArn);
                    copyForWrite.addDataSourceProp(TableExtDesc.S3_ENDPOINT_KEY, endpoint);
                });
                this.addAndBroadcastSparkSession(targetExtDesc.getRoleCredentialInfo());
            }
            return jobs;
        }
        ProjectInstance project = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(projectName);
        Set<NDataModel> affectedModels = this.getAffectedModels(projectName, context);
        for (NDataModel model : affectedModels) {
            jobId = this.updateBrokenModel(project, model, context, needBuild);
            if (!StringUtils.isNotEmpty((CharSequence)jobId)) continue;
            jobs.add(jobId);
        }
        this.mergeTable(projectName, context, true);
        for (NDataModel model : affectedModels) {
            jobId = this.updateModelByReloadTable(project, model, context, needBuild);
            if (!StringUtils.isNotEmpty((CharSequence)jobId)) continue;
            jobs.add(jobId);
        }
        this.internalTableService.reloadInternalTableSchema(projectName, tableIdentity);
        this.mergeTable(projectName, context, false);
        return jobs;
    }

    public void addAndBroadcastSparkSession(TableExtDesc.RoleCredentialInfo roleCredentialInfo) {
        if (roleCredentialInfo == null) {
            return;
        }
        if (Strings.isNullOrEmpty((String)roleCredentialInfo.getEndpoint()) && Strings.isNullOrEmpty((String)roleCredentialInfo.getRole())) {
            return;
        }
        if (KylinConfig.getInstanceFromEnv().useDynamicRoleCredentialInTable()) {
            SparderEnv.addCredential((TableExtDesc.RoleCredentialInfo)roleCredentialInfo, (SparkSession)SparderEnv.getSparkSession());
            EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new AddCredentialToSparkBroadcastEventNotifier(roleCredentialInfo.getType(), roleCredentialInfo.getBucket(), roleCredentialInfo.getRole(), roleCredentialInfo.getEndpoint(), roleCredentialInfo.getRegion()));
        }
    }

    private Set<NDataModel> getAffectedModels(String project, ReloadTableContext context) {
        String tableIdentity = context.getTableDesc().getIdentity();
        return NDataModelManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project).listAllModels().stream().filter(model -> {
            if (model.isBroken()) return false;
            if (!model.getAllTables().stream().map(TableRef::getTableIdentity).anyMatch(tableIdentity::equalsIgnoreCase)) return false;
            return true;
        }).collect(Collectors.toSet());
    }

    private String updateBrokenModel(ProjectInstance project, NDataModel model, ReloadTableContext context, boolean needBuild) throws Exception {
        AffectedModelContext removeAffectedModel = context.getRemoveAffectedModel(project.getName(), model.getId());
        AffectedModelContext changeTypeAffectedModel = context.getChangeTypeAffectedModel(project.getName(), model.getId());
        if (!removeAffectedModel.isBroken()) {
            return null;
        }
        String projectName = project.getName();
        this.cleanIndexPlan(projectName, model, Lists.newArrayList((Object[])new AffectedModelContext[]{removeAffectedModel, changeTypeAffectedModel}));
        OptRecManagerV2.getInstance((String)projectName).discardAll(model.getId());
        this.modelService.onUpdateBrokenModel(model, removeAffectedModel, changeTypeAffectedModel, projectName);
        NDataModel updatedModel = ((NDataModelManager)this.getManager(NDataModelManager.class, projectName)).getDataModelDesc(model.getId());
        if (needBuild && !updatedModel.isBroken()) {
            JobParam jobParam = new JobParam(model.getId(), TableService.getUsername());
            jobParam.setProject(projectName);
            return (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(projectName, () -> ((JobManager)this.getManager(JobManager.class, projectName)).addIndexJob(jobParam));
        }
        return null;
    }

    private String updateModelByReloadTable(ProjectInstance project, NDataModel model, ReloadTableContext context, boolean needBuild) throws Exception {
        String projectName = project.getName();
        Object baseIndexUpdater = this.indexPlanService.getIndexUpdateHelper(model, false);
        AffectedModelContext removeAffected = context.getRemoveAffectedModel(project.getName(), model.getId());
        AffectedModelContext changeTypeAffected = context.getChangeTypeAffectedModel(project.getName(), model.getId());
        if (removeAffected.isBroken()) {
            return null;
        }
        if (!context.getRemoveColumns().isEmpty() || !context.getChangeTypeColumns().isEmpty()) {
            this.cleanIndexPlan(projectName, model, Lists.newArrayList((Object[])new AffectedModelContext[]{removeAffected, changeTypeAffected}));
        }
        OptRecManagerV2.getInstance((String)projectName).discardAll(model.getId());
        try {
            this.modelService.onUpdateDataModel(model, removeAffected, changeTypeAffected, projectName, context.getTableDesc());
        }
        catch (TransactionException e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e) == null ? e : ExceptionUtils.getRootCause((Throwable)e);
            String tableName = context.getTableDesc().getName();
            String columnNames = String.join((CharSequence)MsgPicker.getMsg().getCOMMA(), context.getChangeTypeColumns());
            if (root instanceof IllegalCCExpressionException) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_COMPUTED_COLUMN_EXPRESSION, String.format(Locale.ROOT, MsgPicker.getMsg().getReloadTableCcRetry(), root.getMessage(), tableName, columnNames));
            }
            if (root instanceof KylinException && ((KylinException)root).getErrorCodeProducer().getErrorCode() == ErrorCodeServer.SCD2_MODEL_UNKNOWN_EXCEPTION.getErrorCode()) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TABLE_RELOAD_MODEL_RETRY, new Object[]{tableName, columnNames, model.getAlias()});
            }
            throw e;
        }
        if (CollectionUtils.isNotEmpty((Collection)changeTypeAffected.getUpdatedLayouts())) {
            this.indexPlanService.onReloadLayouts(projectName, changeTypeAffected.getModelId(), changeTypeAffected.getUpdatedLayouts());
        }
        this.indexPlanService.onUpdateBaseIndex(baseIndexUpdater);
        if ((CollectionUtils.isNotEmpty((Collection)removeAffected.getUpdatedLayouts()) || CollectionUtils.isNotEmpty((Collection)changeTypeAffected.getUpdatedLayouts())) && needBuild) {
            JobParam jobParam = new JobParam(model.getId(), TableService.getUsername());
            jobParam.setProject(projectName);
            return (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(projectName, () -> ((JobManager)this.getManager(JobManager.class, projectName)).addIndexJob(jobParam));
        }
        return null;
    }

    void cleanIndexPlan(String projectName, NDataModel model, List<AffectedModelContext> affectedModels) {
        NIndexPlanManager indexManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, projectName);
        for (AffectedModelContext affectedContext : affectedModels) {
            if (!affectedContext.getUpdateMeasureMap().isEmpty()) {
                ((NDataModelManager)this.getManager(NDataModelManager.class, projectName)).updateDataModel(model.getId(), modelDesc -> affectedContext.getUpdateMeasureMap().forEach((originalMeasureId, newMeasure) -> {
                    int maxMeasureId = modelDesc.getAllMeasures().stream().map(NDataModel.Measure::getId).mapToInt(i -> i).max().orElse(99999);
                    Optional<NDataModel.Measure> originalMeasureOptional = modelDesc.getAllMeasures().stream().filter(measure -> measure.getId() == originalMeasureId.intValue()).findAny();
                    if (originalMeasureOptional.isPresent()) {
                        NDataModel.Measure originalMeasure = originalMeasureOptional.get();
                        originalMeasure.setTomb(true);
                        newMeasure.setId(++maxMeasureId);
                        modelDesc.getAllMeasures().add(newMeasure);
                    }
                }));
            }
            indexManager.updateIndexPlan(model.getId(), arg_0 -> ((AffectedModelContext)affectedContext).shrinkIndexPlan(arg_0));
        }
    }

    void mergeTable(String projectName, ReloadTableContext context, boolean keepTomb) {
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, projectName);
        TableDesc originTable = tableManager.getTableDesc(context.getTableDesc().getIdentity());
        TableExtDesc originTableExt = tableManager.getTableExtIfExists(originTable);
        context.getTableDesc().setMvcc(originTable.getMvcc());
        if (originTableExt != null && keepTomb) {
            List validStats = originTableExt.getAllColumnStats().stream().filter(stats -> !context.getRemoveColumns().contains(stats.getColumnName())).collect(Collectors.toList());
            context.getTableExtDesc().setColumnStats(validStats);
            context.getTableExtDesc().setOriginalSize(originTableExt.getOriginalSize());
            List originCols = originTableExt.getAllColumnStats().stream().map(TableExtDesc.ColumnStats::getColumnName).collect(Collectors.toList());
            HashMap indexMapping = Maps.newHashMap();
            int index = 0;
            for (ColumnDesc column : context.getTableDesc().getColumns()) {
                int oldIndex = originCols.indexOf(column.getName());
                indexMapping.put(index, oldIndex);
                ++index;
            }
            context.getTableExtDesc().setSampleRows(originTableExt.getSampleRows().stream().map(row -> {
                String[] result = new String[indexMapping.size()];
                indexMapping.forEach((key, value) -> {
                    result[key.intValue()] = value != -1 ? row[value] : "";
                });
                return result;
            }).collect(Collectors.toList()));
            context.getTableExtDesc().setMvcc(originTable.getMvcc());
        }
        TableDesc loadDesc = context.getTableDesc();
        if (keepTomb) {
            TableDesc copy = tableManager.copy(originTable);
            Map originColMap = Stream.of(copy.getColumns()).collect(Collectors.toMap(ColumnDesc::getName, Function.identity()));
            Map newColMap = Stream.of(context.getTableDesc().getColumns()).collect(Collectors.toMap(ColumnDesc::getName, Function.identity()));
            for (String changedColumn : context.getChangedColumns()) {
                originColMap.put(changedColumn, newColMap.get(changedColumn));
            }
            for (String addColumn : context.getAddColumns()) {
                originColMap.put(addColumn, newColMap.get(addColumn));
            }
            copy.setColumns((ColumnDesc[])originColMap.values().stream().sorted(Comparator.comparing(col -> Integer.parseInt(col.getId()))).toArray(ColumnDesc[]::new));
            loadDesc = copy;
        }
        int idx = 1;
        for (ColumnDesc column : loadDesc.getColumns()) {
            column.setId(idx + "");
            ++idx;
        }
        this.cleanSnapshot(context, loadDesc, originTable, projectName);
        this.loadTableToProject(loadDesc, context.getTableExtDesc(), projectName);
    }

    void cleanSnapshot(ReloadTableContext context, TableDesc targetTable, TableDesc originTable, String projectName) {
        if (context.isChanged(originTable)) {
            String tableIdentity = targetTable.getIdentity();
            List<AbstractExecutable> stopJobs = this.stopAndGetSnapshotJobs(projectName, tableIdentity);
            boolean snapshotBuilt = false;
            if (stopJobs.isEmpty()) {
                ExecutableManager execManager = (ExecutableManager)this.getManager(ExecutableManager.class, projectName);
                List jobInfoList = execManager.fetchJobsByTypesAndStates(projectName, (List)Lists.newArrayList((Object[])new String[]{JobTypeEnum.SNAPSHOT_BUILD.name(), JobTypeEnum.SNAPSHOT_REFRESH.name()}), (List)Lists.newArrayList((Object[])new String[]{tableIdentity}), (List)Lists.newArrayList((Object[])ExecutableState.getFinalStates()));
                boolean bl = snapshotBuilt = !jobInfoList.isEmpty();
            }
            if (!stopJobs.isEmpty() || snapshotBuilt || targetTable.getLastSnapshotPath() != null) {
                targetTable.deleteSnapshot(true);
            } else {
                targetTable.copySnapshotFrom(originTable);
            }
        } else {
            targetTable.copySnapshotFrom(originTable);
        }
    }

    private void checkNewColumn(String project, String tableName, Set<String> addColumns) {
        Multimap<String, String> duplicatedColumns = this.getDuplicatedColumns(project, tableName, addColumns);
        if (!duplicatedColumns.isEmpty()) {
            Map.Entry entry = (Map.Entry)duplicatedColumns.entries().iterator().next();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATED_COLUMN_NAME, MsgPicker.getMsg().getTableReloadAddColumnExist((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private Multimap<String, String> getDuplicatedColumns(String project, String tableName, Set<String> addColumns) {
        HashMultimap duplicatedColumns = HashMultimap.create();
        List models = NDataModelManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project).listAllModels();
        for (NDataModel model : models) {
            if (model.isBroken()) continue;
            for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
                if (!addColumns.contains(cc.getColumnName())) continue;
                duplicatedColumns.put((Object)tableName, (Object)cc.getColumnName());
            }
        }
        return duplicatedColumns;
    }

    private void checkEffectedJobs(TableDesc newTableDesc, boolean isOnlyAddCol) {
        List<String> targetSubjectList = this.getEffectedJobs(newTableDesc, JobInfoEnum.JOB_TARGET_SUBJECT);
        if (CollectionUtils.isNotEmpty(targetSubjectList) && !isOnlyAddCol) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TABLE_RELOAD_HAVING_NOT_FINAL_JOB, new Object[]{StringUtils.join(targetSubjectList.iterator(), (String)",")});
        }
    }

    private Set<String> getEffectedJobIds(TableDesc newTableDesc) {
        return Sets.newHashSet(this.getEffectedJobs(newTableDesc, JobInfoEnum.JOB_ID));
    }

    private List<String> getEffectedJobs(TableDesc newTableDesc, JobInfoEnum jobInfoType) {
        ExecutableManager executableManager = ExecutableManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)newTableDesc.getProject());
        List<AbstractExecutable> notFinalStateJobs = executableManager.getExecutablePOsByStatus(ExecutableState.getNotFinalStates()).stream().map(job -> executableManager.fromPO(job)).collect(Collectors.toList());
        ArrayList effectedJobs = Lists.newArrayList();
        notFinalStateJobs.forEach(job -> {
            if (JobTypeEnum.TABLE_SAMPLING == job.getJobType()) {
                if (newTableDesc.getIdentity().equalsIgnoreCase(job.getTargetSubject())) {
                    String jobId = JobInfoEnum.JOB_ID == jobInfoType ? job.getId() : job.getTargetSubject();
                    effectedJobs.add(jobId);
                }
            } else {
                try {
                    NDataModel model = this.modelService.onGetModelById(job.getTargetSubject(), newTableDesc.getProject());
                    if (!model.isBroken() && model.getAllTables().stream().map(TableRef::getTableIdentity).anyMatch(s -> s.equalsIgnoreCase(newTableDesc.getIdentity()))) {
                        effectedJobs.add(JobInfoEnum.JOB_ID == jobInfoType ? job.getId() : model.getAlias());
                    }
                }
                catch (KylinException e) {
                    logger.warn("Get model by Job target subject failed!", (Throwable)e);
                }
            }
        });
        return effectedJobs;
    }

    private ReloadTableContext calcReloadContext(final String project, final String tableIdentity, boolean failFast) throws Exception {
        ReloadTableContext context = new ReloadTableContext();
        UserGroupInformation ugi = KerberosLoginManager.getInstance().getProjectUGI(project);
        Pair tableMeta = (Pair)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Pair<TableDesc, TableExtDesc>>(){

            @Override
            public Pair<TableDesc, TableExtDesc> run() throws Exception {
                return TableService.this.extractTableMeta(new String[]{tableIdentity}, project).get(0);
            }
        });
        TableDesc newTableDesc = new TableDesc((TableDesc)tableMeta.getFirst());
        context.setTableDesc(newTableDesc);
        context.setTableExtDesc((TableExtDesc)tableMeta.getSecond());
        this.handleExcludedColumns(project, context, newTableDesc, tableIdentity);
        TableDesc originTableDesc = ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(tableIdentity);
        Collector<ColumnDesc, ?, Map<String, Pair>> collector = Collectors.toMap(ColumnDesc::getName, col -> Pair.newPair((Object)col.getDatatype(), (Object)col.getComment()));
        MapDifference diff = Maps.difference(Stream.of(originTableDesc.getColumns()).collect(collector), Stream.of(newTableDesc.getColumns()).collect(collector));
        Collector<ColumnDesc, ?, Map<String, String>> dataTypeCollector = Collectors.toMap(ColumnDesc::getName, ColumnDesc::getDatatype);
        Map<String, String> originCols = Stream.of(originTableDesc.getColumns()).collect(dataTypeCollector);
        Map<String, String> newCols = Stream.of(newTableDesc.getColumns()).collect(dataTypeCollector);
        MapDifference dataTypeDiff = Maps.difference(newCols, originCols);
        assert (diff.entriesDiffering().keySet().containsAll(dataTypeDiff.entriesDiffering().keySet()));
        context.setAddColumns(dataTypeDiff.entriesOnlyOnLeft().keySet());
        context.setRemoveColumns(dataTypeDiff.entriesOnlyOnRight().keySet());
        context.setChangedColumns(diff.entriesDiffering().keySet());
        context.setChangeTypeColumns(dataTypeDiff.entriesDiffering().keySet());
        context.setTableCommentChanged(!Objects.equals(originTableDesc.getTableComment(), newTableDesc.getTableComment()));
        if (!context.isNeedProcess()) {
            return context;
        }
        if (failFast) {
            this.checkNewColumn(project, newTableDesc.getIdentity(), Sets.newHashSet((Iterable)context.getAddColumns()));
            this.checkEffectedJobs(newTableDesc, context.isOnlyAddCols());
        } else {
            HashSet duplicatedColumnsSet = Sets.newHashSet();
            Multimap<String, String> duplicatedColumns = this.getDuplicatedColumns(project, newTableDesc.getIdentity(), Sets.newHashSet((Iterable)context.getAddColumns()));
            for (Map.Entry entry : duplicatedColumns.entries()) {
                duplicatedColumnsSet.add((String)entry.getKey() + "." + (String)entry.getValue());
            }
            context.setDuplicatedColumns((Set)duplicatedColumnsSet);
            context.setEffectedJobs(this.getEffectedJobIds(newTableDesc));
        }
        if (context.isOnlyAddCols()) {
            return context;
        }
        Graph dependencyGraph = SchemaUtil.dependencyGraph((String)project, (String)tableIdentity);
        Map<String, Set<Pair<NDataModel.Measure, NDataModel.Measure>>> suitableColumnTypeChangedMeasuresMap = this.getSuitableColumnTypeChangedMeasures((Graph<SchemaNode>)dependencyGraph, project, originTableDesc, dataTypeDiff.entriesDiffering());
        BiFunction<Set, Boolean, Map> toAffectedModels = (cols, isDelete) -> {
            HashSet affectedNodes = Sets.newHashSet();
            Map columnMap = Arrays.stream(originTableDesc.getColumns()).collect(Collectors.toMap(ColumnDesc::getName, Function.identity()));
            cols.forEach(colName -> {
                if (columnMap.get(colName) != null) {
                    affectedNodes.addAll(Graphs.reachableNodes((Graph)dependencyGraph, (Object)SchemaNode.ofTableColumn((ColumnDesc)((ColumnDesc)columnMap.get(colName)))));
                }
            });
            Map nodesMap = affectedNodes.stream().filter(SchemaNode::isModelNode).collect(Collectors.groupingBy(SchemaNode::getSubject, Collectors.toSet()));
            HashMap modelContexts = Maps.newHashMap();
            nodesMap.forEach((key, nodes) -> {
                IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project).getIndexPlanByModelAlias(key);
                Set updateMeasures = Sets.newHashSet();
                if (!isDelete.booleanValue()) {
                    updateMeasures = suitableColumnTypeChangedMeasuresMap.getOrDefault(key, updateMeasures);
                }
                AffectedModelContext modelContext = new AffectedModelContext(project, indexPlan, nodes, updateMeasures, isDelete.booleanValue());
                modelContexts.put(indexPlan.getUuid(), modelContext);
            });
            return modelContexts;
        };
        context.setRemoveAffectedModels(toAffectedModels.apply(context.getRemoveColumns(), true));
        context.setChangeTypeAffectedModels(toAffectedModels.apply(context.getChangeTypeColumns(), false));
        return context;
    }

    private void handleExcludedColumns(String project, ReloadTableContext context, TableDesc newTable, String tableIdentity) {
        TableDesc originTable;
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableExtDesc originExt = tableManager.getTableExtIfExists(originTable = tableManager.getTableDesc(tableIdentity));
        if (originExt == null) {
            return;
        }
        boolean excluded = originExt.isExcluded();
        context.getTableExtDesc().setExcluded(excluded);
        if (excluded) {
            context.getTableExtDesc().getExcludedColumns().clear();
        } else {
            HashSet excludedColumns = Sets.newHashSet((Iterable)originExt.getExcludedColumns());
            Set newColNameSet = Arrays.stream(newTable.getColumns()).map(ColumnDesc::getName).collect(Collectors.toSet());
            excludedColumns.removeIf(col -> !newColNameSet.contains(col));
            logger.debug("reserved excluded columns are: {}", (Object)excludedColumns);
            if (newColNameSet.equals(excludedColumns)) {
                context.getTableExtDesc().setExcluded(true);
                context.getTableExtDesc().getExcludedColumns().clear();
                logger.debug("Set the table to excluded table for all columns is excluded.");
            } else {
                context.getTableExtDesc().getExcludedColumns().addAll(excludedColumns);
            }
        }
    }

    private Map<String, Set<Pair<NDataModel.Measure, NDataModel.Measure>>> getSuitableColumnTypeChangedMeasures(Graph<SchemaNode> dependencyGraph, String project, TableDesc tableDesc, Map<String, MapDifference.ValueDifference<String>> changeTypeDifference) {
        HashMap result = Maps.newHashMap();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        Map columnMap = Arrays.stream(tableDesc.getColumns()).collect(Collectors.toMap(ColumnDesc::getName, Function.identity()));
        for (Map.Entry<String, MapDifference.ValueDifference<String>> value : changeTypeDifference.entrySet()) {
            String colName = value.getKey();
            MapDifference.ValueDifference<String> colDiff = value.getValue();
            Graphs.reachableNodes(dependencyGraph, (Object)SchemaNode.ofTableColumn((ColumnDesc)((ColumnDesc)columnMap.get(colName)))).stream().filter(node -> node.getType() == SchemaNodeType.MODEL_MEASURE).forEach(node -> {
                NDataModel.Measure measure;
                String modelAlias = node.getSubject();
                String measureId = node.getDetail();
                NDataModel modelDesc = dataModelManager.getDataModelDescByAlias(modelAlias);
                if (modelDesc != null && (measure = (NDataModel.Measure)modelDesc.getEffectiveMeasures().get((Object)Integer.parseInt(measureId))) != null) {
                    String newColumnType;
                    int originalMeasureId = measure.getId();
                    FunctionDesc originalFunction = measure.getFunction();
                    boolean datatypeSuitable = originalFunction.isDatatypeSuitable(DataType.getType((String)(newColumnType = (String)colDiff.leftValue())));
                    if (datatypeSuitable) {
                        FunctionDesc newFunction = FunctionDesc.newInstance((String)originalFunction.getExpression(), (List)Lists.newArrayList((Iterable)originalFunction.getParameters()), (String)FunctionDesc.proposeReturnType((String)originalFunction.getExpression(), (String)newColumnType));
                        NDataModel.Measure newMeasure = new NDataModel.Measure();
                        newMeasure.setFunction(newFunction);
                        newMeasure.setName(measure.getName());
                        newMeasure.setColumn(measure.getColumn());
                        newMeasure.setComment(measure.getComment());
                        Set measureList = result.getOrDefault(modelAlias, new HashSet());
                        measureList.add(Pair.newPair((Object)measure, (Object)newMeasure));
                        result.put(modelAlias, measureList);
                    }
                }
            });
        }
        return result;
    }

    boolean isSqlContainsColumns(String sql, String reloadTable, Set<String> cols) {
        if (sql == null) {
            sql = "";
        }
        sql = sql.toUpperCase(Locale.ROOT);
        if (reloadTable.contains(".")) {
            reloadTable = reloadTable.split("\\.")[1];
        }
        for (String col : cols) {
            col = col.toUpperCase(Locale.ROOT);
            String colWithTableName = reloadTable + "." + col;
            if (!sql.contains(colWithTableName) && (sql.contains("." + col) || !sql.contains(col))) continue;
            return true;
        }
        return false;
    }

    public Set<String> getLoadedDatabases(String project) {
        this.aclEvaluate.checkProjectReadPermission(project);
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        List tables = tableManager.listAllTables();
        HashSet<String> loadedDatabases = new HashSet<String>();
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        tables.stream().filter(table -> table.isAccessible(streamingEnabled)).forEach(table -> loadedDatabases.add(table.getDatabase()));
        return loadedDatabases;
    }

    public NInitTablesResponse getProjectTables(String project, String table, int offset, int limit, boolean withExcluded, boolean useHiveDatabase, List<Integer> sourceType) throws Exception {
        TableDescRequest internalTableDescRequest = new TableDescRequest(project, table, Integer.valueOf(offset), Integer.valueOf(limit), withExcluded, sourceType);
        return this.getProjectTables(internalTableDescRequest, useHiveDatabase);
    }

    public NInitTablesResponse getProjectTables(TableDescRequest tableDescRequest, boolean useHiveDatabase) throws Exception {
        String table;
        String project = tableDescRequest.getProject();
        this.aclEvaluate.checkProjectReadPermission(project);
        NInitTablesResponse response = new NInitTablesResponse();
        logger.debug("only get project tables of excluded: {}", (Object)tableDescRequest.isWithExcluded());
        Pair databaseAndTable = this.checkDatabaseAndTable(tableDescRequest.getTable());
        String exceptDatabase = (String)databaseAndTable.getFirst();
        String notAllowedModifyTableName = table = (String)databaseAndTable.getSecond();
        Collection<String> databases = useHiveDatabase ? this.getSourceDbNames(project) : this.getLoadedDatabases(project);
        ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        List tableFilterList = DataSourceState.getInstance().getHiveFilterList(projectInstance);
        for (String database : databases) {
            if (exceptDatabase != null && !exceptDatabase.equalsIgnoreCase(database) || !tableFilterList.isEmpty() && !tableFilterList.contains(database)) continue;
            if (exceptDatabase == null && database.toLowerCase(Locale.ROOT).contains(table.toLowerCase(Locale.ROOT))) {
                table = "";
            }
            tableDescRequest.setDatabase(database);
            tableDescRequest.setTable(table);
            Pair objWithActualSize = new Pair();
            if (tableDescRequest.getSourceType().isEmpty()) {
                List<TableNameResponse> hiveTableNameResponses = this.getHiveTableNameResponses(project, database, table);
                objWithActualSize.setFirst(hiveTableNameResponses);
                objWithActualSize.setSecond((Object)hiveTableNameResponses.size());
            } else {
                int returnTableSize = TableUtils.calculateTableSize((int)tableDescRequest.getOffset(), (int)tableDescRequest.getLimit());
                Pair<List<TableDesc>, Integer> tableDescWithActualSize = this.getTableDesc(tableDescRequest, returnTableSize);
                objWithActualSize.setFirst(tableDescWithActualSize.getFirst());
                objWithActualSize.setSecond(tableDescWithActualSize.getSecond());
            }
            table = notAllowedModifyTableName;
            List tablePage = PagingUtil.cutPage((List)((List)objWithActualSize.getFirst()), (int)tableDescRequest.getOffset(), (int)tableDescRequest.getLimit());
            if (tablePage.isEmpty()) continue;
            response.putDatabase(database, ((Integer)objWithActualSize.getSecond()).intValue(), tablePage);
        }
        return response;
    }

    public Pair<String[], Set<String>> classifyDbTables(String project, String[] tables) throws Exception {
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        HashSet<String> dbs = new HashSet<String>(this.getSourceDbNames(project));
        ArrayList<String> existed = new ArrayList<String>();
        HashSet<String> failed = new HashSet<String>();
        for (String str : tables) {
            String db = null;
            String table = null;
            if (str.contains(".")) {
                db = str.split("\\.", 2)[0].trim().toUpperCase(Locale.ROOT);
                table = str.split("\\.", 2)[1].trim().toUpperCase(Locale.ROOT);
            } else {
                db = str.toUpperCase(Locale.ROOT);
            }
            if (!dbs.contains(db)) {
                failed.add(str);
                continue;
            }
            if (table != null) {
                HashSet<String> tbs = (HashSet<String>)map.get(db);
                if (tbs == null) {
                    tbs = new HashSet<String>(this.getSourceTableNames(project, db, null));
                    map.put(db, tbs);
                }
                if (!tbs.contains(table)) {
                    failed.add(str);
                    continue;
                }
            }
            existed.add(str);
        }
        return new Pair((Object)existed.toArray(new String[0]), failed);
    }

    public List<TableNameResponse> getHiveTableNameResponses(String project, String database, String table) throws Exception {
        if (Boolean.TRUE.equals(KylinConfig.getInstanceFromEnv().getLoadHiveTablenameEnabled())) {
            return this.getTableNameResponsesInCache(project, database, table);
        }
        return this.getTableNameResponses(project, database, table);
    }

    public List<TableNameResponse> getTableNameResponsesInCache(String project, String database, String table) {
        this.aclEvaluate.checkProjectReadPermission(project);
        ArrayList<TableNameResponse> responses = new ArrayList<TableNameResponse>();
        NTableMetadataManager tableManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        List tables = DataSourceState.getInstance().getTables(project, database);
        for (String tableName : tables) {
            if (!StringUtils.isEmpty((CharSequence)table) && !tableName.toUpperCase(Locale.ROOT).contains(table.toUpperCase(Locale.ROOT))) continue;
            TableNameResponse response = new TableNameResponse();
            String tableNameWithDB = database + "." + tableName;
            this.checkTableExistOrLoad(response, tableManager.getTableDesc(tableNameWithDB));
            response.setTableName(tableName);
            responses.add(response);
        }
        return responses;
    }

    public void checkTableExistOrLoad(TableNameResponse response, TableDesc tableDesc) {
        if (Objects.isNull(tableDesc)) {
            return;
        }
        if (Objects.nonNull(tableDesc.getKafkaConfig())) {
            response.setExisted(true);
        } else {
            response.setLoaded(true);
        }
    }

    public void loadHiveTableNameToCache() throws Exception {
        DataSourceState.getInstance().loadAllSourceInfoToCache();
    }

    public NHiveTableNameResponse loadProjectHiveTableNameToCacheImmediately(String project, boolean force) {
        this.aclEvaluate.checkProjectWritePermission(project);
        return DataSourceState.getInstance().loadAllSourceInfoToCacheForced(project, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSSBDataBase() {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (this.checkSSBDataBase()) {
            return;
        }
        Class<TableService> clazz = TableService.class;
        synchronized (TableService.class) {
            if (this.checkSSBDataBase()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            CliCommandExecutor exec = new CliCommandExecutor();
            BufferedLogger patternedLogger = new BufferedLogger(logger);
            String sampleSh = this.checkSSBEnv();
            try {
                exec.execute(sampleSh, (org.apache.kylin.common.util.Logger)patternedLogger);
            }
            catch (ShellException e) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_IMPORT_SSB_DATA, SSB_ERROR_MSG, (Throwable)e);
            }
            if (!this.checkSSBDataBase()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_IMPORT_SSB_DATA, SSB_ERROR_MSG);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String checkSSBEnv() {
        String home = KylinConfigBase.getKylinHome();
        if (!StringUtils.isEmpty((CharSequence)home) && !home.endsWith("/")) {
            home = home + "/";
        }
        String sampleSh = String.format(Locale.ROOT, "%sbin/sample.sh", home);
        this.checkFile(sampleSh);
        String ssbSh = String.format(Locale.ROOT, "%stool/ssb/create_sample_ssb_tables.sql", home);
        this.checkFile(ssbSh);
        String customer = String.format(Locale.ROOT, "%stool/ssb/data/SSB.CUSTOMER.csv", home);
        this.checkFile(customer);
        String dates = String.format(Locale.ROOT, "%stool/ssb/data/SSB.DATES.csv", home);
        this.checkFile(dates);
        String lineorder = String.format(Locale.ROOT, "%stool/ssb/data/SSB.LINEORDER.csv", home);
        this.checkFile(lineorder);
        String part = String.format(Locale.ROOT, "%stool/ssb/data/SSB.PART.csv", home);
        this.checkFile(part);
        String supplier = String.format(Locale.ROOT, "%stool/ssb/data/SSB.SUPPLIER.csv", home);
        this.checkFile(supplier);
        return sampleSh;
    }

    private void checkFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FILE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getFileNotExist(), fileName));
        }
    }

    public boolean checkSSBDataBase() {
        this.aclEvaluate.checkIsGlobalAdmin();
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            return true;
        }
        ISourceMetadataExplorer explr = SourceFactory.getSparkSource().getSourceMetadataExplorer();
        try {
            Set result = explr.listTables("SSB").stream().map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
            return result.containsAll(Sets.newHashSet((Object[])new String[]{"CUSTOMER", "DATES", "LINEORDER", "P_LINEORDER", "PART", "SUPPLIER"}));
        }
        catch (Exception e) {
            logger.warn("check ssb error", (Throwable)e);
            return false;
        }
    }

    public TableRefresh refreshSingleCatalogCache(Map refreshRequest) {
        TableRefresh result = new TableRefresh();
        Message message = MsgPicker.getMsg();
        List tables = (List)refreshRequest.get("tables");
        ArrayList refreshed = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        tables.forEach(table -> this.refreshTable((String)table, refreshed, failed));
        if (failed.isEmpty()) {
            result.setCode("000");
        } else {
            result.setCode("999");
            result.setMsg(message.getTableRefreshNotfound());
        }
        result.setRefreshed((List)refreshed);
        result.setFailed((List)failed);
        return result;
    }

    public void refreshTable(String table, List<String> refreshed, List<String> failed) {
        try {
            PushDownUtil.trySimplyExecute((String)("REFRESH TABLE " + table), null);
            refreshed.add(table);
        }
        catch (Exception e) {
            failed.add(table);
            logger.error("fail to refresh spark cached table", (Throwable)e);
        }
    }

    public TableRefreshAll refreshAllCatalogCache(HttpServletRequest request) {
        Message message = MsgPicker.getMsg();
        List servers = this.clusterManager.getQueryServers();
        TableRefreshAll result = new TableRefreshAll();
        result.setCode("000");
        StringBuilder msg = new StringBuilder();
        ArrayList nodes = new ArrayList();
        servers.forEach(server -> {
            String host = server.getHost();
            String url = "http://" + host + REFRESH_SINGLE_CATALOG_PATH;
            try {
                EnvelopeResponse response = this.generateTaskForRemoteHost(request, url);
                if (StringUtils.isNotBlank((CharSequence)response.getMsg())) {
                    msg.append(host + ":" + response.getMsg() + ";");
                }
                if (response.getCode().equals("999")) {
                    result.setCode("999");
                }
                if (response.getData() != null) {
                    TableRefresh data = (TableRefresh)JsonUtil.convert((Object)response.getData(), TableRefresh.class);
                    data.setServer(host);
                    nodes.add(data);
                }
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_REFRESH_CATALOG_CACHE, message.getTableRefreshError(), (Throwable)e);
            }
        });
        if (!nodes.isEmpty()) {
            result.setNodes(nodes);
        }
        result.setMsg(msg.toString());
        return result;
    }

    public List<TableDesc> getTablesOfModel(String project, String modelAlias) {
        this.aclEvaluate.checkProjectReadPermission(project);
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDescByAlias(modelAlias);
        if (Objects.isNull(model)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_NOT_EXIST, new Object[]{modelAlias});
        }
        ArrayList usedTableNames = Lists.newArrayList();
        usedTableNames.add(model.getRootFactTableName());
        usedTableNames.addAll(model.getJoinTables().stream().map(JoinTableDesc::getTable).collect(Collectors.toList()));
        return usedTableNames.stream().map(arg_0 -> ((NTableMetadataManager)((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project))).getTableDesc(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public TableExtDesc getOrCreateTableExt(String project, TableDesc t) {
        return ((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getOrCreateTableExt(t);
    }
}

