/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.loader;

import com.alibaba.nacos.common.executor.NameThreadFactory;
import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExternalConfigLoader
implements IExternalConfigLoader {
    private static final long serialVersionUID = 1694879531312203159L;
    private static final Logger logger = LoggerFactory.getLogger(FileExternalConfigLoader.class);
    private static final String AUTO_REFRESH = "kylin.config.auto.refresh";
    private final File propFile;
    private final Properties properties;

    public FileExternalConfigLoader(Map<String, String> map) {
        this(new File(map.get("config-dir")));
    }

    public FileExternalConfigLoader(File file) {
        this.propFile = file;
        this.properties = this.loadProperties();
        if (this.properties.getProperty(AUTO_REFRESH) != null && Boolean.parseBoolean(this.properties.getProperty(AUTO_REFRESH))) {
            Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NameThreadFactory("file-external-config-loader")).scheduleWithFixedDelay(() -> {
                logger.debug("Reload properties from file");
                Properties reloadedProperties = this.loadProperties();
                this.properties.clear();
                this.properties.putAll((Map<?, ?>)reloadedProperties);
            }, 1L, 60L, TimeUnit.SECONDS);
        }
    }

    private Properties loadProperties() {
        Properties siteProperties = new Properties();
        try (InputStream is = Files.newInputStream(this.propFile.toPath(), new OpenOption[0]);){
            siteProperties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return siteProperties;
    }

    public String getConfig() {
        StringWriter writer = new StringWriter();
        try {
            this.properties.store(new PrintWriter(writer), "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

