/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.FileAction;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RemoveFile
implements FileAction {
    @Nonnull
    private final String path;
    @Nonnull
    private final Optional<Long> deletionTimestamp;
    private final boolean dataChange;
    private final boolean extendedFileMetadata;
    @Nullable
    private final Map<String, String> partitionValues;
    @Nonnull
    private final Optional<Long> size;
    @Nullable
    private final Map<String, String> tags;

    @Deprecated
    public RemoveFile(@Nonnull String string, @Nonnull Optional<Long> optional, boolean bl, boolean bl2, @Nullable Map<String, String> map, @Nonnull Optional<Long> optional2, @Nullable Map<String, String> map2) {
        this.path = string;
        this.deletionTimestamp = optional;
        this.dataChange = bl;
        this.extendedFileMetadata = bl2;
        this.partitionValues = map;
        this.size = optional2;
        this.tags = map2;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Optional<Long> getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public boolean isDataChange() {
        return this.dataChange;
    }

    public boolean isExtendedFileMetadata() {
        return this.extendedFileMetadata;
    }

    @Nullable
    public Map<String, String> getPartitionValues() {
        return this.partitionValues != null ? Collections.unmodifiableMap(this.partitionValues) : null;
    }

    public Optional<Long> getSize() {
        return this.size;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags != null ? Collections.unmodifiableMap(this.tags) : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RemoveFile removeFile = (RemoveFile)object;
        return Objects.equals(this.path, removeFile.path) && Objects.equals(this.deletionTimestamp, removeFile.deletionTimestamp) && Objects.equals(this.dataChange, removeFile.dataChange) && Objects.equals(this.extendedFileMetadata, removeFile.extendedFileMetadata) && Objects.equals(this.partitionValues, removeFile.partitionValues) && Objects.equals(this.size, removeFile.size) && Objects.equals(this.tags, removeFile.tags);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.deletionTimestamp, this.dataChange, this.extendedFileMetadata, this.partitionValues, this.size, this.tags);
    }
}

