/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.plugins;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelBuilderPlugin;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.SyntheticModelProviderPlugin;
import springfox.documentation.spi.schema.ViewProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
public class SchemaPluginsManager {
    private final PluginRegistry<ModelPropertyBuilderPlugin, DocumentationType> propertyEnrichers;
    private final PluginRegistry<ModelBuilderPlugin, DocumentationType> modelEnrichers;
    private final PluginRegistry<ViewProviderPlugin, DocumentationType> viewProviders;
    private final PluginRegistry<SyntheticModelProviderPlugin, ModelContext> syntheticModelProviders;

    @Autowired
    public SchemaPluginsManager(@Qualifier(value="modelPropertyBuilderPluginRegistry") PluginRegistry<ModelPropertyBuilderPlugin, DocumentationType> propertyEnrichers, @Qualifier(value="modelBuilderPluginRegistry") PluginRegistry<ModelBuilderPlugin, DocumentationType> modelEnrichers, @Qualifier(value="viewProviderPluginRegistry") PluginRegistry<ViewProviderPlugin, DocumentationType> viewProviders, @Qualifier(value="syntheticModelProviderPluginRegistry") PluginRegistry<SyntheticModelProviderPlugin, ModelContext> syntheticModelProviders) {
        this.propertyEnrichers = propertyEnrichers;
        this.modelEnrichers = modelEnrichers;
        this.viewProviders = viewProviders;
        this.syntheticModelProviders = syntheticModelProviders;
    }

    @Deprecated
    public ModelProperty property(ModelPropertyContext context) {
        for (ModelPropertyBuilderPlugin enricher : this.propertyEnrichers.getPluginsFor((Object)context.getDocumentationType())) {
            enricher.apply(context);
        }
        return context.getBuilder().build();
    }

    @Deprecated
    public Model model(ModelContext context) {
        for (ModelBuilderPlugin enricher : this.modelEnrichers.getPluginsFor((Object)context.getDocumentationType())) {
            enricher.apply(context);
        }
        return context.getBuilder().build();
    }

    public ViewProviderPlugin viewProvider(DocumentationType documentationType) {
        return (ViewProviderPlugin)this.viewProviders.getPluginFor((Object)documentationType).orElseThrow(() -> new IllegalStateException("No ViewProviderPlugin for " + documentationType.getName()));
    }

    @Deprecated
    public Optional<Model> syntheticModel(ModelContext context) {
        return this.syntheticModelProviders.getPluginFor((Object)context).map(plugin -> plugin.create(context));
    }

    public ModelSpecification modelSpecification(ModelContext context) {
        for (ModelBuilderPlugin enricher : this.modelEnrichers.getPluginsFor((Object)context.getDocumentationType())) {
            enricher.apply(context);
        }
        return context.getModelSpecificationBuilder().build();
    }

    public Optional<ModelSpecification> syntheticModelSpecification(ModelContext context) {
        return this.syntheticModelProviders.getPluginFor((Object)context).map(p -> p.createModelSpecification(context));
    }

    @Deprecated
    public List<ModelProperty> syntheticProperties(ModelContext context) {
        return this.syntheticModelProviders.getPluginFor((Object)context).map(plugin -> plugin.properties(context)).orElseGet(ArrayList::new);
    }

    public Set<ResolvedType> dependencies(ModelContext context) {
        return this.syntheticModelProviders.getPluginFor((Object)context).map(plugin -> plugin.dependencies(context)).orElseGet(HashSet::new);
    }

    public List<PropertySpecification> syntheticPropertySpecifications(ModelContext context) {
        return this.syntheticModelProviders.getPluginFor((Object)context).map(p -> p.propertySpecifications(context)).orElse(new ArrayList());
    }

    public PropertySpecification propertySpecification(ModelPropertyContext modelPropertyContext) {
        for (ModelPropertyBuilderPlugin enricher : this.propertyEnrichers.getPluginsFor((Object)modelPropertyContext.getDocumentationType())) {
            enricher.apply(modelPropertyContext);
        }
        return modelPropertyContext.getSpecificationBuilder().build();
    }
}

