/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.ResyncRunnable;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.Indexer;
import io.fabric8.kubernetes.client.informers.cache.ProcessorStore;
import io.fabric8.kubernetes.client.informers.cache.Reflector;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.client.informers.cache.Store;
import io.fabric8.kubernetes.client.utils.SerialExecutor;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<T extends HasMetadata, L extends KubernetesResourceList<T>>
implements SharedIndexInformer<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private final long defaultEventHandlerResyncPeriod;
    private final Reflector<T, L> reflector;
    private final Class<T> apiTypeClass;
    private final ProcessorStore<T> processorStore;
    private final Cache<T> indexer;
    private final SharedProcessor<T> processor;
    private final Executor informerExecutor;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile boolean stopped = false;
    private ScheduledFuture<?> resyncFuture;

    public DefaultSharedIndexInformer(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, long resyncPeriod, Executor informerExecutor) {
        if (resyncPeriod < 0L) {
            throw new IllegalArgumentException("Invalid resync period provided, It should be a non-negative value");
        }
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.apiTypeClass = apiTypeClass;
        this.informerExecutor = informerExecutor;
        this.processor = new SharedProcessor(new SerialExecutor(informerExecutor));
        this.indexer = new Cache();
        this.indexer.setIsRunning(this::isRunning);
        this.processorStore = new ProcessorStore<T>(this.indexer, this.processor);
        this.reflector = new Reflector<T, L>(apiTypeClass, listerWatcher, this.processorStore);
    }

    @Override
    public void addEventHandler(ResourceEventHandler<? super T> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
    }

    @Override
    public void addEventHandlerWithResyncPeriod(ResourceEventHandler<? super T> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to shared informer because it has stopped already");
            return;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small. Changing it to minimal allowed value of {}", (Object)resyncPeriodMillis, (Object)1000L);
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started.get()) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the informer has already started. Changing it to {}", new Object[]{resyncPeriodMillis, this.resyncCheckPeriodMillis, this.resyncCheckPeriodMillis});
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        this.processor.addProcessorListener(handler, this.determineResyncPeriod(resyncPeriodMillis, this.resyncCheckPeriodMillis), this.indexer::list);
    }

    @Override
    public String lastSyncResourceVersion() {
        return this.reflector.getLastSyncResourceVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot restart a stopped informer");
        }
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        log.debug("informer: ready to run resync and reflector for {} with resync {}", this.apiTypeClass, (Object)this.resyncCheckPeriodMillis);
        this.scheduleResync(this.processor::shouldResync);
        this.reflector.listSyncAndWatch();
        DefaultSharedIndexInformer defaultSharedIndexInformer = this;
        synchronized (defaultSharedIndexInformer) {
            if (this.stopped) {
                this.stop();
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.stopped = true;
        this.reflector.stop();
        this.stopResync();
        this.processor.stop();
    }

    private synchronized void stopResync() {
        if (this.resyncFuture != null) {
            this.resyncFuture.cancel(true);
            this.resyncFuture = null;
        }
    }

    @Override
    public void addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.indexer.addIndexers(indexers);
    }

    @Override
    public Indexer<T> getIndexer() {
        return this.indexer;
    }

    @Override
    public Store<T> getStore() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check) {
        if (desired == 0L) {
            return desired;
        }
        if (check == 0L) {
            return 0L;
        }
        return Math.max(desired, check);
    }

    @Override
    public boolean isRunning() {
        return !this.stopped && this.started.get() && this.reflector.isRunning();
    }

    @Override
    public boolean isWatching() {
        return this.reflector.isWatching();
    }

    synchronized void scheduleResync(Supplier<Boolean> resyncFunc) {
        if (this.resyncCheckPeriodMillis > 0L) {
            ResyncRunnable<T> resyncRunnable = new ResyncRunnable<T>(this.processorStore, resyncFunc);
            this.resyncFuture = Utils.scheduleAtFixedRate(this.informerExecutor, resyncRunnable, this.resyncCheckPeriodMillis, this.resyncCheckPeriodMillis, TimeUnit.MILLISECONDS);
        } else {
            log.debug("informer#Controller: resync skipped due to 0 full resync period {}", this.apiTypeClass);
        }
    }

    public long getFullResyncPeriod() {
        return this.resyncCheckPeriodMillis;
    }

    ScheduledFuture<?> getResyncFuture() {
        return this.resyncFuture;
    }

    @Override
    public Class<T> getApiTypeClass() {
        return this.apiTypeClass;
    }
}

