/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.profiler.AsyncProfilerUtils;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AsyncProfilerUtilsTest {
    String buildAsyncFileName = "ke-build-async-profiler-result-";

    private AsyncProfilerUtils init() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = AsyncProfilerUtils.getInstance();
        asyncProfilerUtils.build(new CountDownLatch(3));
        asyncProfilerUtils.build(300000L, Files.createTempDirectory(this.buildAsyncFileName, new FileAttribute[0]).toFile());
        return asyncProfilerUtils;
    }

    @Test
    public void testBuild() throws IOException {
        AsyncProfilerUtils asyncProfilerUtilsBuild = AsyncProfilerUtils.getInstance();
        asyncProfilerUtilsBuild.build(new CountDownLatch(2));
        Assert.assertEquals((long)2L, (long)asyncProfilerUtilsBuild.cachedResult.getCount());
        File testFile = Files.createTempDirectory("ke-build-async-test-profiler-", new FileAttribute[0]).toFile();
        asyncProfilerUtilsBuild.build(2L, testFile);
        Assert.assertEquals((long)2L, (long)asyncProfilerUtilsBuild.resultCollectionTimeout);
        Assert.assertEquals((Object)testFile, (Object)asyncProfilerUtilsBuild.localCacheDir);
    }

    @Test
    public void testBuildWithNewLocalCacheDir() throws IOException {
        AsyncProfilerUtils asyncProfilerUtilsBuild = AsyncProfilerUtils.getInstance();
        asyncProfilerUtilsBuild.build(new CountDownLatch(2));
        Assert.assertEquals((long)2L, (long)asyncProfilerUtilsBuild.cachedResult.getCount());
        File testFile = Files.createTempDirectory("ke-build-async-test-profiler-", new FileAttribute[0]).toFile();
        asyncProfilerUtilsBuild.build(2L, testFile);
        Assert.assertEquals((long)2L, (long)asyncProfilerUtilsBuild.resultCollectionTimeout);
        Assert.assertEquals((Object)testFile, (Object)asyncProfilerUtilsBuild.localCacheDir);
        testFile = Files.createTempDirectory("ke-build-async-test-profiler-", new FileAttribute[0]).toFile();
        asyncProfilerUtilsBuild.build(testFile);
        Assert.assertEquals((Object)testFile, (Object)asyncProfilerUtilsBuild.localCacheDir);
    }

    @Test
    public void testWaitForResultTimeout() throws IOException, InterruptedException {
        AsyncProfilerUtils asyncProfilerUtils = AsyncProfilerUtils.getInstance();
        asyncProfilerUtils.build(new CountDownLatch(3));
        asyncProfilerUtils.build(-1L, Files.createTempDirectory(this.buildAsyncFileName, new FileAttribute[0]).toFile());
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        Thread t1 = new Thread(() -> {
            Awaitility.await().pollDelay(new Duration(1L, TimeUnit.SECONDS)).until(() -> true);
            for (int i = 0; i < 3; ++i) {
                cachedThreadPool.execute(() -> asyncProfilerUtils.cachedResult.countDown());
            }
        });
        t1.start();
        asyncProfilerUtils.waitForResult((OutputStream)Mockito.mock(OutputStream.class));
        cachedThreadPool.shutdown();
        t1.interrupt();
    }

    @Test
    public void testWaitForResult() throws IOException, InterruptedException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
        Thread t1 = new Thread(() -> {
            Awaitility.await().pollDelay(new Duration(1L, TimeUnit.MILLISECONDS)).until(() -> true);
            for (int i = 0; i < 3; ++i) {
                cachedThreadPool.execute(() -> asyncProfilerUtils.cachedResult.countDown());
            }
        });
        t1.start();
        asyncProfilerUtils.waitForResult((OutputStream)Mockito.mock(OutputStream.class));
        cachedThreadPool.shutdown();
        t1.interrupt();
    }

    @Test
    public void testSuffix() {
        Assert.assertEquals((long)0L, (long)AsyncProfilerUtils.getInstance().suffix("noHtml").length());
        Assert.assertEquals((Object)".html", (Object)AsyncProfilerUtils.getInstance().suffix("<!DOCTYPE html>"));
    }

    @Test
    public void testCacheExecutorResult() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        asyncProfilerUtils.cacheExecutorResult("content", "1");
        Files.deleteIfExists(new File(asyncProfilerUtils.localCacheDir.getAbsolutePath(), "executor-1").toPath());
    }

    @Test
    public void testCacheDriverResult() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        asyncProfilerUtils.cacheDriverResult("content");
        Files.deleteIfExists(new File(asyncProfilerUtils.localCacheDir.getAbsolutePath(), "driver").toPath());
    }

    @Test
    public void testCacheResultError() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        asyncProfilerUtils.cacheResult(null, "result");
        Files.deleteIfExists(new File(asyncProfilerUtils.localCacheDir.getAbsolutePath(), "result").toPath());
    }

    @Test
    public void testCacheResult() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        asyncProfilerUtils.cacheResult("content", "result");
        Files.deleteIfExists(new File(asyncProfilerUtils.localCacheDir.getAbsolutePath(), "result").toPath());
    }

    @Test
    public void testCleanLocalCacheError() {
        AsyncProfilerUtils.getInstance().cleanLocalCache();
    }

    @Test
    public void testCleanLocalCache() throws IOException {
        AsyncProfilerUtils asyncProfilerUtils = this.init();
        asyncProfilerUtils.cleanLocalCache();
    }
}

