/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConfigChecksumCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinConfigChecksumCLI.class);

    public static void main(String[] args) {
        int ret = KylinConfigChecksumCLI.execute(args);
        Unsafe.systemExit((int)ret);
    }

    public static int execute(String[] args) {
        if (args.length < 1) {
            log.error("Please input expected checksum!");
            return -1;
        }
        try {
            String kylinConfigChecksum;
            String expectedChecksum = args[0];
            File kylinConfDir = KylinConfig.getKylinConfDir();
            File propFile = new File(kylinConfDir, "kylin.properties");
            File propOverrideFile = new File(kylinConfDir, "kylin.properties.override");
            String propContent = FileUtils.readFileToString((File)propFile, (Charset)StandardCharsets.UTF_8);
            if (propOverrideFile.exists()) {
                propContent = propContent + FileUtils.readFileToString((File)propOverrideFile, (Charset)StandardCharsets.UTF_8);
            }
            if (!(kylinConfigChecksum = DigestUtils.sha256Hex((String)propContent)).equalsIgnoreCase(expectedChecksum)) {
                log.error("Kylin config checksum [{}] is not equal to expected checksum [{}], expected checksum is from file detached_by_km!", (Object)kylinConfigChecksum, (Object)expectedChecksum);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            log.error("An exception occurred when checking kylin config checksum, ex ", (Throwable)e);
            return -1;
        }
    }
}

