/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.obf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.tool.obf.ObfCatalog;

public class MappingRecorder
implements Closeable {
    private boolean isClosed = false;
    private final File output;
    private Map<String, Map<String, String>> mapping = Maps.newConcurrentMap();

    public MappingRecorder(File output) {
        this.output = output;
    }

    public String addMapping(String catalog, String from, String to) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0);
        if (!this.mapping.containsKey(catalog)) {
            this.mapping.put(catalog, Maps.newConcurrentMap());
        }
        this.mapping.get(catalog).putIfAbsent(from, to);
        return to;
    }

    public String addMapping(ObfCatalog catalog, String from) {
        return this.addMapping(catalog.value, from, catalog.obf(from));
    }

    public Map<String, Map<String, String>> getMapping() {
        return this.mapping;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.store();
            this.isClosed = true;
            this.mapping = null;
        }
    }

    public void store() throws IOException {
        if (this.output == null) {
            return;
        }
        try (OutputStream os = Files.newOutputStream(this.output.toPath(), new OpenOption[0]);){
            JsonUtil.writeValue((OutputStream)os, this.mapping);
            os.flush();
        }
    }
}

