/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.guava30.shaded.common.cache;

import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.guava30.shaded.common.base.Equivalence;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;

public final class CustomKeyEquivalenceCacheBuilder {
    private static final Equivalence<Object> KEY_CASE_IGNORE_EQUIVALENCE = new Equivalence<Object>(){

        protected boolean doEquivalent(Object a, Object b) {
            if (a instanceof String && b instanceof String) {
                return Objects.equals(((String)a).toLowerCase(Locale.ROOT), ((String)b).toLowerCase(Locale.ROOT));
            }
            return Objects.equals(a, b);
        }

        protected int doHash(Object o) {
            if (o instanceof String) {
                return ((String)o).toLowerCase(Locale.ROOT).hashCode();
            }
            return o.hashCode();
        }
    };

    public static CacheBuilder<Object, Object> newBuilder(MetadataType type) {
        return CacheBuilder.newBuilder().keyEquivalence(MetadataType.CASE_INSENSITIVE_METADATA.contains(type) ? KEY_CASE_IGNORE_EQUIVALENCE : Equivalence.equals());
    }

    @Generated
    private CustomKeyEquivalenceCacheBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

