/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.basic;

import java.math.BigDecimal;
import org.apache.kylin.measure.MeasureAggregator;

public class BigDecimalMaxAggregator
extends MeasureAggregator<BigDecimal> {
    BigDecimal max = null;

    @Override
    public void reset() {
        this.max = null;
    }

    @Override
    public void aggregate(BigDecimal value) {
        if (this.max == null) {
            this.max = value;
        } else if (this.max.compareTo(value) < 0) {
            this.max = value;
        }
    }

    @Override
    public BigDecimal aggregate(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        if (value1.compareTo(value2) > 0) {
            return value1;
        }
        return value2;
    }

    @Override
    public BigDecimal getState() {
        return this.max;
    }

    @Override
    public int getMemBytesEstimate() {
        return BigDecimalMaxAggregator.guessBigDecimalMemBytes();
    }
}

