/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.basic;

import java.math.BigDecimal;
import org.apache.kylin.measure.MeasureAggregator;

public class BigDecimalMinAggregator
extends MeasureAggregator<BigDecimal> {
    BigDecimal min = null;

    @Override
    public void reset() {
        this.min = null;
    }

    @Override
    public void aggregate(BigDecimal value) {
        if (this.min == null) {
            this.min = value;
        } else if (this.min.compareTo(value) > 0) {
            this.min = value;
        }
    }

    @Override
    public BigDecimal aggregate(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        if (value1.compareTo(value2) > 0) {
            return value2;
        }
        return value1;
    }

    @Override
    public BigDecimal getState() {
        return this.min;
    }

    @Override
    public int getMemBytesEstimate() {
        return BigDecimalMinAggregator.guessBigDecimalMemBytes();
    }
}

