/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.sumlc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public class SumLCCounter
implements Serializable {
    private static final Map<String, BiFunction<Number, Number, Number>> MERGE_FUNC_MAP = Maps.newHashMap();
    Number sumLC;
    Long timestamp;

    public SumLCCounter() {
    }

    public SumLCCounter(Number sumLC, Long timestamp) {
        this.sumLC = SumLCCounter.numericTypeConversion(sumLC);
        this.timestamp = timestamp;
    }

    public static SumLCCounter merge(SumLCCounter current, Number sumLC, Long timestamp) {
        SumLCCounter merged = new SumLCCounter(sumLC, timestamp);
        return SumLCCounter.merge(current, merged);
    }

    public static SumLCCounter merge(SumLCCounter value1, SumLCCounter value2) {
        if (value1 == null || value1.timestamp == null) {
            return value2;
        }
        if (value2 == null || value2.timestamp == null) {
            return value1;
        }
        if (value2.timestamp > value1.timestamp) {
            return value2;
        }
        if (value1.timestamp > value2.timestamp) {
            return value1;
        }
        return SumLCCounter.mergeSum(value1, value2);
    }

    private static SumLCCounter mergeSum(SumLCCounter cnt1, SumLCCounter cnt2) {
        if (cnt1.sumLC == null) {
            return cnt2;
        }
        if (cnt2.sumLC == null) {
            return cnt1;
        }
        String sumLCTypeName = cnt1.sumLC.getClass().getSimpleName();
        Number semiSum = MERGE_FUNC_MAP.get(sumLCTypeName).apply(cnt1.sumLC, cnt2.sumLC);
        return new SumLCCounter(semiSum, cnt1.timestamp);
    }

    private static Number numericTypeConversion(Number input) {
        if (input instanceof Byte || input instanceof Short || input instanceof Integer) {
            return input.longValue();
        }
        if (input instanceof Float) {
            return input.doubleValue();
        }
        return input;
    }

    public void update(Number sumLC, Long timestamp) {
        if (timestamp == null) {
            return;
        }
        Number typeConvertInput = SumLCCounter.numericTypeConversion(sumLC);
        if (this.timestamp == null || this.timestamp < timestamp) {
            this.sumLC = typeConvertInput;
            this.timestamp = timestamp;
        } else if (this.timestamp.equals(timestamp)) {
            if (this.sumLC == null) {
                this.sumLC = typeConvertInput;
            } else if (typeConvertInput != null) {
                String sumLCTypeName = this.sumLC.getClass().getSimpleName();
                this.sumLC = MERGE_FUNC_MAP.get(sumLCTypeName).apply(this.sumLC, typeConvertInput);
            }
        }
    }

    public Number getSumLC() {
        return this.sumLC;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    static {
        MERGE_FUNC_MAP.put(Long.class.getSimpleName(), (s1, s2) -> Long.sum((Long)s1, (Long)s2));
        MERGE_FUNC_MAP.put(Double.class.getSimpleName(), (s1, s2) -> Double.sum((Double)s1, (Double)s2));
        MERGE_FUNC_MAP.put(BigDecimal.class.getSimpleName(), (s1, s2) -> ((BigDecimal)s1).add((BigDecimal)s2));
    }
}

