/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.MissingRootPersistentEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataSegmentManager;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.NSegmentConfigHelper;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.RetentionRange;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataflow
extends RootPersistentEntity
implements Serializable,
IRealization {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NDataflow.class);
    public static final String REALIZATION_TYPE = "NCUBE";
    public static final String DATAFLOW_RESOURCE_ROOT = "/dataflow";
    private static final long EXPENSIVE_DATAFLOW_INITIALIZATION = 2000L;
    @JsonIgnore
    private KylinConfigExt config;
    @JsonProperty(value="status")
    private RealizationStatusEnum status;
    @JsonProperty(value="last_status")
    private RealizationStatusEnum lastStatus;
    @JsonProperty(value="cost")
    private int cost = 50;
    @JsonProperty(value="query_hit_count")
    private int queryHitCount = 0;
    @JsonProperty(value="last_query_time")
    private long lastQueryTime = 0L;
    @JsonProperty(value="last_data_refresh_time")
    private long lastDataRefreshTime = 0L;
    @JsonProperty(value="layout_query_hit_count")
    private Map<Long, FrequencyMap> layoutHitCount = Maps.newHashMap();
    @JsonProperty(value="segment_uuids")
    private List<String> segmentUuids = new ArrayList<String>();

    public static NDataflow create(IndexPlan plan, RealizationStatusEnum realizationStatusEnum) {
        NDataflow df = new NDataflow();
        df.config = (KylinConfigExt)plan.getConfig();
        df.setUuid(plan.getUuid());
        df.setStatus(realizationStatusEnum);
        return df;
    }

    public void initAfterReload(KylinConfigExt config, String project) {
        long start = System.currentTimeMillis();
        this.project = project;
        this.config = config;
        this.setDependencies(this.calcDependencies());
        long time = System.currentTimeMillis() - start;
        if (time > 2000L) {
            log.debug("initialization finished for dataflow({}/{}) takes {}ms", new Object[]{project, this.uuid, time});
        }
    }

    public List<RootPersistentEntity> calcDependencies() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.config, this.project);
        IndexPlan indexPlan = indexPlanManager.getIndexPlan(this.getId());
        ArrayList dependencies = Lists.newArrayList((Object[])new RootPersistentEntity[]{indexPlan != null ? indexPlan : new MissingRootPersistentEntity(MetadataType.mergeKeyWithType((String)this.getId(), (MetadataType)MetadataType.INDEX_PLAN))});
        return dependencies;
    }

    public KylinConfigExt getConfig() {
        return (KylinConfigExt)this.getIndexPlan().getConfig();
    }

    public NDataflow copy() {
        return NDataflowManager.getInstance((KylinConfig)this.config, this.project).copy(this);
    }

    public String resourceName() {
        return this.uuid;
    }

    public MetadataType resourceType() {
        return MetadataType.DATAFLOW;
    }

    private NDataSegmentManager getSegmentManager() {
        return NDataSegmentManager.getInstance((KylinConfig)this.config, this.getProject());
    }

    public Segments<NDataSegment> getSegments() {
        if (this.segmentUuids.isEmpty()) {
            return new Segments<NDataSegment>();
        }
        return this.getSegmentManager().getSegmentsUnderDataflow(this);
    }

    public Set<String> collectPrecalculationResource() {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        r.add(this.getResourcePath());
        for (NDataSegment seg : this.getSegments()) {
            r.add(seg.getResourcePath());
            r.add(seg.getSegDetails().getResourcePath());
        }
        r.add(this.getIndexPlan().getResourcePath());
        r.add(this.getModel().getProjectInstance().getResourcePath());
        r.add(this.getModel().getResourcePath());
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project);
        for (TableRef t : this.getModel().getAllTables()) {
            TableExtDesc tableExtDesc;
            r.add(t.getTableDesc().getResourcePath());
            if (t.getTableDesc().isKafkaTable()) {
                r.add(t.getTableDesc().getKafkaConfig().getResourcePath());
            }
            if ((tableExtDesc = tableMetadataManager.getTableExtIfExists(t.getTableDesc())) == null) continue;
            r.add(tableExtDesc.getResourcePath());
        }
        for (ComputedColumnDesc cc : this.getModel().getComputedColumnDescs()) {
            r.add(cc.getResourcePath());
        }
        this.listAllLayoutDetails().forEach(layoutDetail -> r.add(layoutDetail.getResourcePath()));
        return r;
    }

    public IndexPlan getIndexPlan() {
        return NIndexPlanManager.getInstance((KylinConfig)this.config, this.project).getIndexPlan(this.uuid);
    }

    public List<NDataLayoutDetails> listAllLayoutDetails() {
        return NDataLayoutDetailsManager.getInstance((KylinConfig)this.config, this.project).listNDataLayoutDetailsByModel(this.uuid);
    }

    public NDataLayoutDetails getDataLayoutDetails(long layoutId) {
        return NDataLayoutDetailsManager.getInstance((KylinConfig)this.config, this.project).getNDataLayoutDetails(this.uuid, layoutId);
    }

    @Override
    public boolean isStreaming() {
        return this.getModel().isStreaming();
    }

    @Override
    public String getType() {
        return REALIZATION_TYPE;
    }

    @Override
    public NDataModel getModel() {
        return NDataModelManager.getInstance((KylinConfig)this.config, this.project).getDataModelDesc(this.uuid);
    }

    public String getModelAlias() {
        NDataModel model = this.getModel();
        return model == null ? null : model.getAlias();
    }

    public String getFusionModelAlias() {
        NDataModel model = this.getModel();
        return model == null ? null : model.getFusionModelAlias();
    }

    @Override
    public Set<TblColRef> getAllColumns() {
        return this.getIndexPlan().listAllTblColRefs();
    }

    public Set<Integer> getAllColumnsIndex() {
        return this.getIndexPlan().listAllTblColRefsIndex();
    }

    @Override
    public List<TblColRef> getAllDimensions() {
        return Lists.newArrayList((Iterable)this.getIndexPlan().getEffectiveDimCols().values());
    }

    @Override
    public List<MeasureDesc> getMeasures() {
        Set measures = this.getIndexPlan().getEffectiveMeasures().values();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)measures.size());
        result.addAll(measures);
        return result;
    }

    @Override
    public List<IRealization> getRealizations() {
        return Collections.singletonList(this);
    }

    @Override
    public FunctionDesc findAggrFunc(FunctionDesc aggrFunc) {
        for (MeasureDesc measure : this.getMeasures()) {
            if (!measure.getFunction().equals(aggrFunc)) continue;
            return measure.getFunction();
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (aggrFunc.isCountOnColumn() && kylinConfig.isReplaceColCountWithCountStar()) {
            return FunctionDesc.newCountOne();
        }
        return aggrFunc;
    }

    public List<LayoutEntity> extractReadyLayouts() {
        NDataSegment latestReadySegment = this.getLatestReadySegment();
        if (latestReadySegment == null) {
            return Lists.newArrayList();
        }
        List<LayoutEntity> allLayouts = this.getIndexPlan().getAllLayouts();
        Set readyLayoutSet = latestReadySegment.getLayoutsMap().values().stream().map(NDataLayout::getLayoutId).collect(Collectors.toSet());
        allLayouts.removeIf(layout -> !readyLayoutSet.contains(layout.getId()));
        return allLayouts;
    }

    @Override
    public boolean isOnline() {
        return this.getStatus() == RealizationStatusEnum.ONLINE || this.config.isQueryDryRunEnabled();
    }

    public boolean isOffline() {
        return this.getStatus() == RealizationStatusEnum.OFFLINE;
    }

    @Override
    public String getCanonicalName() {
        return this.getType() + "[name=" + this.getModel().getAlias() + "]";
    }

    @Override
    public long getDateRangeStart() {
        return this.getSegments().getTSStart();
    }

    @Override
    public long getDateRangeEnd() {
        return this.getSegments().getTSEnd();
    }

    public NDataSegment getSegment(String segId) {
        if (StringUtils.isBlank((CharSequence)segId)) {
            return null;
        }
        Segments<NDataSegment> segments = this.getSegments(Sets.newHashSet((Object[])new String[]{segId}));
        if (CollectionUtils.isNotEmpty(segments)) {
            Preconditions.checkState((segments.size() == 1 ? 1 : 0) != 0);
            return (NDataSegment)segments.get(0);
        }
        return null;
    }

    public Segments<NDataSegment> getSegments(Set<String> segIds) {
        return this.getSegmentManager().getSegments(this, segIds);
    }

    public NDataSegment getSegmentByName(String segName) {
        for (NDataSegment seg : this.getSegments()) {
            if (!seg.getName().equals(segName)) continue;
            return seg;
        }
        return null;
    }

    public Segments<NDataSegment> getMergingSegments(NDataSegment mergedSegment) {
        return this.getSegments().getMergingSegments(mergedSegment);
    }

    public Segments<NDataSegment> getQueryableSegments() {
        return this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
    }

    public Segments<NDataSegment> getSegments(SegmentStatusEnum ... statusLst) {
        return this.getSegments().getSegments(statusLst);
    }

    public Segments<NDataSegment> getFlatSegments() {
        return this.getSegments().getFlatSegments();
    }

    public Segments<NDataSegment> calculateToBeSegments(NDataSegment newSegment) {
        return this.getSegments().calculateToBeSegments(newSegment);
    }

    public NDataSegment getFirstSegment() {
        Segments<NDataSegment> existing = this.getSegments();
        if (existing.isEmpty()) {
            return null;
        }
        return (NDataSegment)existing.get(0);
    }

    public NDataSegment getLatestReadySegment() {
        Segments<NDataSegment> readySegment = this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        if (readySegment.isEmpty()) {
            return null;
        }
        return (NDataSegment)readySegment.get(readySegment.size() - 1);
    }

    public NDataSegment getLastSegment() {
        Segments<NDataSegment> existing = this.getSegments();
        if (existing.isEmpty()) {
            return null;
        }
        return (NDataSegment)existing.get(existing.size() - 1);
    }

    public SegmentRange getCoveredRange() {
        Segments<NDataSegment> segs = this.getFlatSegments();
        if (segs.isEmpty()) {
            return null;
        }
        return ((NDataSegment)segs.get(0)).getSegRange().coverWith(((NDataSegment)segs.get(segs.size() - 1)).getSegRange());
    }

    public String getSegmentHdfsPath(String segmentId) {
        String hdfsWorkingDir = KapConfig.wrap((KylinConfig)this.config).getMetadataWorkingDirectory();
        if (this.getModel().getStorageType().isDeltaStorage()) {
            return hdfsWorkingDir + this.getProject() + "/delta/" + this.getUuid();
        }
        return hdfsWorkingDir + this.getProject() + "/parquet/" + this.getUuid() + "/" + segmentId;
    }

    public Segments<NDataSegment> getSegmentsByRange(SegmentRange range) {
        return this.getSegments().getSegmentsByRange(range);
    }

    public List<NDataSegment> getQueryableSegmentsByRange(SegmentRange range) {
        ArrayList result = Lists.newArrayList();
        for (NDataSegment seg : this.getQueryableSegments()) {
            if (!seg.getSegRange().overlaps(range)) continue;
            result.add(seg);
        }
        return result;
    }

    @Override
    public boolean hasPrecalculatedFields() {
        return true;
    }

    @Override
    public int getStorageType() {
        return this.getModel().getStorageTypeValue();
    }

    public RealizationStatusEnum getLastStatus() {
        return this.lastStatus;
    }

    public RealizationStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(RealizationStatusEnum status) {
        this.checkIsNotCachedAndShared();
        if (RealizationStatusEnum.BROKEN == status && RealizationStatusEnum.BROKEN != this.status) {
            this.lastStatus = this.status;
        }
        this.status = status;
    }

    public void setSegmentUuids(Segments<NDataSegment> segments) {
        this.checkIsNotCachedAndShared();
        Collections.sort(segments);
        segments.validate();
        this.segmentUuids = segments.stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList());
        if (segments.isEmpty() && RealizationStatusEnum.ONLINE == this.getStatus()) {
            this.setStatus(RealizationStatusEnum.OFFLINE);
        }
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.checkIsNotCachedAndShared();
        this.cost = cost;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDataflow other = (NDataflow)obj;
        return this.uuid.equals(other.uuid);
    }

    public String toString() {
        return "NDataflow [" + this.getModelAlias() + "]";
    }

    public Segments getSegmentsToRemoveByRetention() {
        SegmentConfig segmentConfig = NSegmentConfigHelper.getModelSegmentConfig(this.project, this.getModel().getUuid());
        if (segmentConfig.canSkipHandleRetentionSegment()) {
            return null;
        }
        RetentionRange retentionRange = segmentConfig.getRetentionRange();
        return this.getSegments().getSegmentsToRemoveByRetention(retentionRange.getRetentionRangeType(), retentionRange.getRetentionRangeNumber());
    }

    public boolean checkBrokenWithRelatedInfo() {
        boolean cubeBroken;
        boolean dfBroken = this.isBroken();
        if (dfBroken) {
            return dfBroken;
        }
        NIndexPlanManager cubePlanManager = NIndexPlanManager.getInstance((KylinConfig)this.config, this.project);
        IndexPlan cubePlan = cubePlanManager.getIndexPlan(this.uuid);
        boolean bl = cubeBroken = cubePlan == null || cubePlan.isBroken();
        if (cubeBroken) {
            return cubeBroken;
        }
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)this.config, this.project);
        NDataModel model = modelManager.getDataModelDesc(this.uuid);
        return model == null || model.isBroken();
    }

    public long getStorageBytesSize() {
        long bytesSize = 0L;
        if (!this.getModel().isBroken() && this.getModel().getStorageType().isV3Storage()) {
            for (NDataLayoutDetails detail : this.listAllLayoutDetails()) {
                bytesSize += detail.getSizeInBytes();
            }
        } else {
            for (NDataSegment segment : this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING)) {
                bytesSize += segment.getStorageBytesSize();
            }
        }
        return bytesSize;
    }

    public long getSourceBytesSize() {
        long bytesSize = 0L;
        for (NDataSegment segment : this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING)) {
            bytesSize += segment.getSourceBytesSize() == -1L ? 0L : segment.getSourceBytesSize();
        }
        return bytesSize;
    }

    public long getLastBuildTime() {
        long lastBuildTime = 0L;
        for (NDataSegment segment : this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING)) {
            lastBuildTime = Math.max(lastBuildTime, segment.getLastBuildTime());
        }
        return lastBuildTime;
    }

    public long getQueryHitCount(long layoutId) {
        if (this.getLayoutHitCount().get(layoutId) != null) {
            return this.getLayoutHitCount().get(layoutId).getFrequency(this.project);
        }
        return 0L;
    }

    public long getByteSize(long layoutId) {
        long dataSize = 0L;
        for (NDataSegment segment : this.getSegments()) {
            NDataLayout dataCuboid = segment.getLayout(layoutId);
            if (dataCuboid == null) continue;
            dataSize += dataCuboid.getByteSize();
        }
        return dataSize;
    }

    public boolean hasReadySegments() {
        return this.isOnline() && CollectionUtils.isNotEmpty(this.getQueryableSegments());
    }

    public void initAllSegLayoutInfo() {
        this.getSegments().forEach(NDataSegment::getLayoutInfo);
    }

    public void initSegLayoutInfoById(Set<String> segmentIdList) {
        this.getSegments(segmentIdList).forEach(NDataSegment::getLayoutInfo);
    }

    @Generated
    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    @Generated
    public int getQueryHitCount() {
        return this.queryHitCount;
    }

    @Generated
    public void setQueryHitCount(int queryHitCount) {
        this.queryHitCount = queryHitCount;
    }

    @Generated
    public long getLastQueryTime() {
        return this.lastQueryTime;
    }

    @Generated
    public void setLastQueryTime(long lastQueryTime) {
        this.lastQueryTime = lastQueryTime;
    }

    @Generated
    public long getLastDataRefreshTime() {
        return this.lastDataRefreshTime;
    }

    @Generated
    public void setLastDataRefreshTime(long lastDataRefreshTime) {
        this.lastDataRefreshTime = lastDataRefreshTime;
    }

    @Generated
    public Map<Long, FrequencyMap> getLayoutHitCount() {
        return this.layoutHitCount;
    }

    @Generated
    public void setLayoutHitCount(Map<Long, FrequencyMap> layoutHitCount) {
        this.layoutHitCount = layoutHitCount;
    }

    @Generated
    public List<String> getSegmentUuids() {
        return this.segmentUuids;
    }
}

