/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.CuboidScheduler;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.springframework.beans.BeanUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RuleBasedIndex
implements Serializable {
    @JsonBackReference
    private IndexPlan indexPlan;
    @JsonProperty(value="dimensions")
    private List<Integer> dimensions = Lists.newArrayList();
    @JsonProperty(value="measures")
    private List<Integer> measures = Lists.newArrayList();
    @JsonProperty(value="global_dim_cap")
    private Integer globalDimCap;
    @JsonProperty(value="aggregation_groups")
    private List<NAggregationGroup> aggregationGroups = Lists.newArrayList();
    @JsonProperty(value="layout_id_mapping")
    private List<Long> layoutIdMapping = Lists.newArrayList();
    @JsonProperty(value="parent_forward")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private int parentForward = 3;
    @JsonProperty(value="index_start_id")
    private long indexStartId;
    @JsonProperty(value="last_modify_time")
    private long lastModifiedTime = System.currentTimeMillis();
    @JsonProperty(value="layout_black_list")
    private Set<Long> layoutBlackList = new HashSet<Long>();
    @JsonProperty(value="layout_cost_based_pruned_list")
    private Set<Long> layoutsOfCostBasedList = null;
    @JsonProperty(value="scheduler_version")
    private int schedulerVersion = 1;
    @JsonProperty(value="index_update_enabled")
    private boolean indexUpdateEnabled = true;
    @JsonProperty(value="base_layout_enabled")
    private Boolean baseLayoutEnabled;
    private transient BiMap<Integer, TblColRef> effectiveDimCols;
    private ImmutableBiMap<Integer, NDataModel.Measure> orderedMeasures;
    private ImmutableBitSet dimensionBitset = null;
    private ImmutableBitSet measureBitset = null;
    private ImmutableSet<TblColRef> dimensionSet = null;
    private ImmutableSet<NDataModel.Measure> measureSet = null;
    private Map<Integer, Integer> dimMea2bitIndex;
    private BigInteger fullMask = BigInteger.ZERO;
    private final AtomicReference<Object> cuboidScheduler = new AtomicReference();
    private final AtomicReference<Object> measuresBitSet = new AtomicReference();

    public void init() {
        int i;
        NDataModel model = this.getModel();
        this.dimensionBitset = ImmutableBitSet.valueOf(this.dimensions);
        this.measureBitset = ImmutableBitSet.valueOf(this.measures);
        this.effectiveDimCols = Maps.filterKeys(model.getEffectiveCols(), input -> input != null && this.dimensionBitset.get(input.intValue()));
        this.dimensionSet = ImmutableSet.copyOf((Collection)this.effectiveDimCols.values());
        ImmutableBiMap.Builder measuresBuilder = ImmutableBiMap.builder();
        for (int m : this.measures) {
            if (!model.getEffectiveMeasures().containsKey((Object)m)) continue;
            measuresBuilder.put((Object)m, model.getEffectiveMeasures().get((Object)m));
        }
        this.orderedMeasures = measuresBuilder.build();
        this.measureSet = this.orderedMeasures.values();
        this.dimMea2bitIndex = Maps.newHashMap();
        int bitSize = this.dimensions.size() + this.measures.size();
        for (i = 0; i < this.dimensions.size(); ++i) {
            this.dimMea2bitIndex.put(this.dimensions.get(i), bitSize - i - 1);
        }
        for (i = 0; i < this.measures.size(); ++i) {
            this.dimMea2bitIndex.put(this.measures.get(i), this.measures.size() - i - 1);
        }
        if (CollectionUtils.isNotEmpty(this.dimensions)) {
            for (i = 0; i < this.dimensions.size() + this.measures.size(); ++i) {
                this.fullMask = this.fullMask.setBit(i);
            }
        }
        for (NAggregationGroup nAggregationGroup : this.aggregationGroups) {
            nAggregationGroup.init(this);
        }
    }

    public CuboidScheduler initCuboidScheduler() {
        return CuboidScheduler.getInstance(this.indexPlan, this);
    }

    public int getGlobalDimCap() {
        return this.globalDimCap == null ? 0 : this.globalDimCap;
    }

    public int getColumnBitIndex(Integer colId) {
        return this.dimMea2bitIndex.get(colId);
    }

    public Set<LayoutEntity> genCuboidLayouts() {
        return this.genCuboidLayouts(Sets.newHashSet(), Sets.newHashSet(), true, false);
    }

    public Set<LayoutEntity> genCuboidLayouts(boolean useCostBasedList) {
        return this.genCuboidLayouts(Sets.newHashSet(), Sets.newHashSet(), true, useCostBasedList);
    }

    public boolean getIndexUpdateEnabled() {
        return this.indexUpdateEnabled;
    }

    public NDataModel getModel() {
        return this.indexPlan.getModel();
    }

    public void setIndexPlan(IndexPlan indexPlan) {
        this.checkIsNotCachedAndShared();
        this.indexPlan = indexPlan;
    }

    public List<Integer> getDimensions() {
        return this.isCachedAndShared() ? Lists.newArrayList(this.dimensions) : this.dimensions;
    }

    public void setDimensions(List<Integer> dimensions) {
        this.checkIsNotCachedAndShared();
        this.dimensions = dimensions;
    }

    public List<Integer> getMeasures() {
        return this.isCachedAndShared() ? Lists.newArrayList(this.measures) : this.measures;
    }

    public void setMeasures(List<Integer> measures) {
        this.checkIsNotCachedAndShared();
        this.measures = measures;
    }

    public void setAggregationGroups(List<NAggregationGroup> aggregationGroups) {
        this.checkIsNotCachedAndShared();
        this.aggregationGroups = aggregationGroups;
    }

    public Map<Integer, Integer> getColumnIdToRowKeyId() {
        int rowKeyId = 0;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Integer columnId : this.dimensions) {
            result.put(columnId, rowKeyId);
            ++rowKeyId;
        }
        return result;
    }

    public Map<Integer, Integer> getRowKeyIdToColumnId() {
        int rowKeyId = 0;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Integer columnId : this.dimensions) {
            result.put(rowKeyId, columnId);
            ++rowKeyId;
        }
        return result;
    }

    public int countOfIncludeDimension() {
        return this.dimensions.size();
    }

    public boolean isCachedAndShared() {
        return this.indexPlan != null && this.indexPlan.isCachedAndShared();
    }

    public void checkIsNotCachedAndShared() {
        if (this.indexPlan != null) {
            this.indexPlan.checkIsNotCachedAndShared();
        }
    }

    public void setParentForward(int parentForward) {
        this.checkIsNotCachedAndShared();
        this.parentForward = parentForward;
    }

    private ImmutableBitSet initMeasuresBitSet() {
        return ImmutableBitSet.valueOf(this.getMeasures());
    }

    Set<LayoutEntity> genCuboidLayouts(Set<LayoutEntity> previousLayouts) {
        return this.genCuboidLayouts(previousLayouts, Sets.newHashSet(), true, false);
    }

    Set<LayoutEntity> genCuboidLayouts(Set<LayoutEntity> previousLayouts, Set<LayoutEntity> needDelLayouts) {
        return this.genCuboidLayouts(previousLayouts, needDelLayouts, true, false);
    }

    private Set<LayoutEntity> genCuboidLayouts(Set<LayoutEntity> previousLayouts, Set<LayoutEntity> needDelLayouts, boolean excludeDel, boolean useCostBasedList) {
        HashSet genLayouts = Sets.newHashSet();
        HashMap existLayouts = Maps.newHashMap();
        previousLayouts.forEach(layout -> existLayouts.put(layout, layout.getId()));
        this.indexPlan.getWhitelistLayouts().forEach(layout -> existLayouts.put(layout, layout.getId()));
        HashMap delLayouts = Maps.newHashMap();
        needDelLayouts.forEach(layout -> delLayouts.put(layout, layout.getId()));
        HashMap toBeDeletedLayouts = Maps.newHashMap();
        HashMap toBeDeletedIndexesMap = Maps.newHashMap();
        this.indexPlan.getToBeDeletedIndexes().forEach(index -> {
            toBeDeletedIndexesMap.put(index.createIndexIdentifier(), index);
            index.getLayouts().forEach(layout -> toBeDeletedLayouts.put(layout, layout.getId()));
        });
        Map<IndexEntity.IndexIdentifier, Object> identifierIndexMap = existLayouts.keySet().stream().map(LayoutEntity::getIndex).collect(Collectors.groupingBy(IndexEntity::createIndexIdentifier, Collectors.reducing(null, (l, r) -> r)));
        List<CuboidScheduler.ColOrder> colOrders = this.getCuboidScheduler().getAllColOrders();
        boolean needAllocationId = this.layoutIdMapping.isEmpty();
        boolean isBaseCuboidValid = this.getIndexPlan().getConfig().isBaseCuboidAlwaysValid();
        CuboidScheduler.ColOrder baseColOrder = new CuboidScheduler.ColOrder(this.getDimensions(), this.getMeasures());
        long proposalId = this.indexStartId + 1L;
        for (int i = 0; i < colOrders.size(); ++i) {
            CuboidScheduler.ColOrder colOrder = colOrders.get(i);
            LayoutEntity layout2 = this.createLayout(colOrder, this.getModel().getStorageTypeValue());
            List<Integer> dimensionsInLayout = colOrder.getDimensions();
            List<Integer> measuresInLayout = colOrder.getMeasures();
            IndexEntity.IndexIdentifier indexIdentifier = new IndexEntity.IndexIdentifier(dimensionsInLayout, measuresInLayout, false);
            IndexEntity layoutIndex = identifierIndexMap.get(indexIdentifier);
            IndexEntity toBeDelLayoutIndex = (IndexEntity)toBeDeletedIndexesMap.get(indexIdentifier);
            long nextLayoutId = this.getNextLayoutId(layoutIndex, toBeDelLayoutIndex);
            if (needAllocationId) {
                Long prevId = this.getExistLayoutId(layout2, toBeDelLayoutIndex, existLayouts, toBeDeletedLayouts);
                if (prevId != null) {
                    layout2.setId(prevId);
                } else if (delLayouts.containsKey(layout2)) {
                    layout2.setId((Long)delLayouts.get(layout2));
                    this.layoutBlackList.add((Long)delLayouts.get(layout2));
                } else if (nextLayoutId > 0L) {
                    layout2.setId(nextLayoutId);
                } else {
                    layout2.setId(proposalId);
                    proposalId += 10000L;
                }
                this.layoutIdMapping.add(layout2.getId());
            } else {
                layout2.setId(this.layoutIdMapping.get(i));
            }
            if (layoutIndex == null) {
                long indexId = layout2.getIndexId();
                layoutIndex = new IndexEntity();
                layoutIndex.setId(indexId);
                layoutIndex.setDimensions(dimensionsInLayout);
                layoutIndex.setMeasures(measuresInLayout);
                layoutIndex.setIndexPlan(this.indexPlan);
                layoutIndex.setNextLayoutOffset(layout2.getId() % 10000L + 1L);
                identifierIndexMap.putIfAbsent(layoutIndex.createIndexIdentifier(), layoutIndex);
            } else {
                layoutIndex.setNextLayoutOffset(Math.max(layout2.getId() % 10000L + 1L, layoutIndex.getNextLayoutOffset()));
            }
            layout2.setIndex(layoutIndex);
            if (!isBaseCuboidValid && colOrder.equals(baseColOrder)) continue;
            genLayouts.add(layout2);
        }
        if (excludeDel) {
            genLayouts.removeIf(layout -> this.layoutBlackList.contains(layout.getId()));
        }
        return this.tryLayoutsOfCostBasedPlanner(useCostBasedList, genLayouts);
    }

    private Set<LayoutEntity> tryLayoutsOfCostBasedPlanner(boolean useCostBasedList, Set<LayoutEntity> genLayouts) {
        if (useCostBasedList && this.layoutsOfCostBasedList != null) {
            HashSet result = Sets.newHashSet();
            genLayouts.stream().forEach(layout -> {
                if (this.layoutsOfCostBasedList.contains(layout.getId())) {
                    result.add(layout);
                }
            });
            return result;
        }
        return genLayouts;
    }

    private Long getExistLayoutId(LayoutEntity layout, IndexEntity toBeDelLayoutIndex, Map<LayoutEntity, Long> existLayouts, Map<LayoutEntity, Long> toBeDeletedLayouts) {
        Long prevId = existLayouts.get(layout);
        if (prevId == null && toBeDelLayoutIndex != null && (prevId = toBeDeletedLayouts.get(layout)) != null) {
            this.indexPlan.getToBeDeletedIndexes().remove(toBeDelLayoutIndex);
            toBeDelLayoutIndex.getLayouts().remove(layout);
            if (!toBeDelLayoutIndex.getLayouts().isEmpty()) {
                this.indexPlan.getToBeDeletedIndexes().add(toBeDelLayoutIndex);
            }
        }
        return prevId;
    }

    private long getNextLayoutId(IndexEntity layoutIndex, IndexEntity toBeDelLayoutIndex) {
        long id = 0L;
        if (layoutIndex != null) {
            id = layoutIndex.getId() + layoutIndex.getNextLayoutOffset();
        }
        if (toBeDelLayoutIndex != null) {
            id = Math.max(id, toBeDelLayoutIndex.getId() + toBeDelLayoutIndex.getNextLayoutOffset());
        }
        return id;
    }

    private LayoutEntity createLayout(CuboidScheduler.ColOrder colOrder, int storageType) {
        LayoutEntity layout = new LayoutEntity();
        layout.setManual(true);
        layout.setColOrder(colOrder.toList());
        if (colOrder.getDimensions().containsAll(this.indexPlan.getAggShardByColumns())) {
            layout.setShardByColumns(this.indexPlan.getAggShardByColumns());
        }
        layout.setUpdateTime(this.lastModifiedTime);
        if (NDataModel.DataStorageType.fromValue(storageType).isV3Storage()) {
            layout.setStorageType(storageType);
        }
        return layout;
    }

    public Set<LayoutEntity> getBlacklistLayouts() {
        Set<LayoutEntity> allLayouts = this.genCuboidLayouts(Sets.newHashSet(), Sets.newHashSet(), false, false);
        Set<LayoutEntity> existLayouts = this.genCuboidLayouts();
        return allLayouts.stream().filter(layout -> !existLayouts.contains(layout)).collect(Collectors.toSet());
    }

    public static RuleBasedIndex copyAndResetAggGroups(RuleBasedIndex oldRuleBasedIndex, List<NAggregationGroup> reservedAggGroups) {
        ArrayList newAggGroups = Lists.newArrayList();
        reservedAggGroups.forEach(aggGroup -> {
            NAggregationGroup tmp = new NAggregationGroup();
            BeanUtils.copyProperties((Object)aggGroup, (Object)tmp);
            NAggregationGroup newAggGroup = new NAggregationGroup();
            newAggGroup.setSelectRule(tmp.getSelectRule());
            newAggGroup.setIncludes(tmp.getIncludes());
            newAggGroup.setMeasures(tmp.getMeasures());
            newAggGroups.add(newAggGroup);
        });
        RuleBasedIndex tmpRuleBasedIndex = new RuleBasedIndex();
        BeanUtils.copyProperties((Object)oldRuleBasedIndex, (Object)tmpRuleBasedIndex);
        RuleBasedIndex newRuleBasedIndex = new RuleBasedIndex();
        newRuleBasedIndex.setAggregationGroups(newAggGroups);
        newRuleBasedIndex.setGlobalDimCap(tmpRuleBasedIndex.getGlobalDimCap());
        newRuleBasedIndex.setSchedulerVersion(tmpRuleBasedIndex.getSchedulerVersion());
        newRuleBasedIndex.adjustDimensions();
        newRuleBasedIndex.adjustMeasures();
        newRuleBasedIndex.setLastModifiedTime(System.currentTimeMillis());
        return newRuleBasedIndex;
    }

    public void adjustMeasures() {
        if (CollectionUtils.isEmpty(this.aggregationGroups)) {
            this.getMeasures().clear();
            return;
        }
        List<Integer> measures = this.recomputeMeasures(this.getAggregationGroups());
        this.setMeasures(Lists.newArrayList(measures));
    }

    private List<Integer> recomputeMeasures(List<NAggregationGroup> aggregationGroups) {
        if (CollectionUtils.isEmpty(aggregationGroups)) {
            return Lists.newArrayList();
        }
        TreeSet measures = new TreeSet();
        for (NAggregationGroup agg : aggregationGroups) {
            Object[] aggMeasures = agg.getMeasures();
            if (aggMeasures == null || aggMeasures.length == 0) continue;
            measures.addAll(Sets.newHashSet((Object[])aggMeasures));
        }
        return Lists.newArrayList(measures);
    }

    public void adjustDimensions() {
        List<Integer> dimensions = this.recomputeSortedDimensions(this.aggregationGroups);
        this.setDimensions(dimensions);
    }

    private List<Integer> recomputeSortedDimensions(List<NAggregationGroup> aggregationGroups) {
        if (CollectionUtils.isEmpty(aggregationGroups)) {
            return Lists.newArrayList();
        }
        ArrayList mergedAndSorted = Lists.newArrayList();
        for (int aggGroupIndex = aggregationGroups.size() - 1; aggGroupIndex >= 0; --aggGroupIndex) {
            Object[] includes = aggregationGroups.get(aggGroupIndex).getIncludes();
            if (includes == null || includes.length == 0) continue;
            ArrayList currentSortedList = Lists.newArrayList((Object[])includes);
            HashMap mergedAndSortedIndexMap = Maps.newHashMap();
            int count = 0;
            Iterator iterator = mergedAndSorted.iterator();
            while (iterator.hasNext()) {
                int element = (Integer)iterator.next();
                mergedAndSortedIndexMap.put(element, count);
                ++count;
            }
            iterator = mergedAndSorted.iterator();
            while (iterator.hasNext()) {
                int dimensionId = (Integer)iterator.next();
                this.calculateCurrentSortedList(mergedAndSortedIndexMap, currentSortedList, dimensionId);
            }
            mergedAndSorted = Lists.newArrayList((Iterable)currentSortedList);
        }
        return mergedAndSorted;
    }

    private void calculateCurrentSortedList(Map<Integer, Integer> mergedAndSortedIndexMap, List<Integer> currentSortedList, int dimensionId) {
        boolean needToAppendToTail = true;
        LinkedHashSet currentSortedSet = Sets.newLinkedHashSet(currentSortedList);
        if (currentSortedSet.contains(dimensionId)) {
            return;
        }
        Integer indexOfNewDimension = mergedAndSortedIndexMap.get(dimensionId);
        Iterator iterator = currentSortedSet.iterator();
        while (iterator.hasNext()) {
            int oldDimensionId = (Integer)iterator.next();
            Integer indexOfOldDimension = mergedAndSortedIndexMap.get(oldDimensionId);
            if (indexOfOldDimension == null || indexOfNewDimension >= indexOfOldDimension) continue;
            currentSortedList.add(currentSortedList.indexOf(oldDimensionId), dimensionId);
            needToAppendToTail = false;
            break;
        }
        if (needToAppendToTail) {
            currentSortedList.add(dimensionId);
        }
    }

    @Generated
    public RuleBasedIndex() {
    }

    @Generated
    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    @Generated
    public void setGlobalDimCap(Integer globalDimCap) {
        this.globalDimCap = globalDimCap;
    }

    @Generated
    public List<NAggregationGroup> getAggregationGroups() {
        return this.aggregationGroups;
    }

    @Generated
    public void setLayoutIdMapping(List<Long> layoutIdMapping) {
        this.layoutIdMapping = layoutIdMapping;
    }

    @Generated
    public List<Long> getLayoutIdMapping() {
        return this.layoutIdMapping;
    }

    @Generated
    public int getParentForward() {
        return this.parentForward;
    }

    @Generated
    public void setIndexStartId(long indexStartId) {
        this.indexStartId = indexStartId;
    }

    @Generated
    public long getIndexStartId() {
        return this.indexStartId;
    }

    @Generated
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Generated
    public void setLayoutBlackList(Set<Long> layoutBlackList) {
        this.layoutBlackList = layoutBlackList;
    }

    @Generated
    public Set<Long> getLayoutBlackList() {
        return this.layoutBlackList;
    }

    @Generated
    public void setLayoutsOfCostBasedList(Set<Long> layoutsOfCostBasedList) {
        this.layoutsOfCostBasedList = layoutsOfCostBasedList;
    }

    @Generated
    public Set<Long> getLayoutsOfCostBasedList() {
        return this.layoutsOfCostBasedList;
    }

    @Generated
    public void setSchedulerVersion(int schedulerVersion) {
        this.schedulerVersion = schedulerVersion;
    }

    @Generated
    public int getSchedulerVersion() {
        return this.schedulerVersion;
    }

    @Generated
    public void setIndexUpdateEnabled(boolean indexUpdateEnabled) {
        this.indexUpdateEnabled = indexUpdateEnabled;
    }

    @Generated
    public void setBaseLayoutEnabled(Boolean baseLayoutEnabled) {
        this.baseLayoutEnabled = baseLayoutEnabled;
    }

    @Generated
    public Boolean getBaseLayoutEnabled() {
        return this.baseLayoutEnabled;
    }

    @Generated
    public BiMap<Integer, TblColRef> getEffectiveDimCols() {
        return this.effectiveDimCols;
    }

    @Generated
    public ImmutableBiMap<Integer, NDataModel.Measure> getOrderedMeasures() {
        return this.orderedMeasures;
    }

    @Generated
    public ImmutableBitSet getDimensionBitset() {
        return this.dimensionBitset;
    }

    @Generated
    public ImmutableBitSet getMeasureBitset() {
        return this.measureBitset;
    }

    @Generated
    public ImmutableSet<TblColRef> getDimensionSet() {
        return this.dimensionSet;
    }

    @Generated
    public ImmutableSet<NDataModel.Measure> getMeasureSet() {
        return this.measureSet;
    }

    @Generated
    public BigInteger getFullMask() {
        return this.fullMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public CuboidScheduler getCuboidScheduler() {
        Object value = this.cuboidScheduler.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.cuboidScheduler;
            synchronized (atomicReference) {
                value = this.cuboidScheduler.get();
                if (value == null) {
                    CuboidScheduler actualValue = this.initCuboidScheduler();
                    value = actualValue == null ? this.cuboidScheduler : actualValue;
                    this.cuboidScheduler.set(value);
                }
            }
        }
        return (CuboidScheduler)(value == this.cuboidScheduler ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public ImmutableBitSet getMeasuresBitSet() {
        Object value = this.measuresBitSet.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.measuresBitSet;
            synchronized (atomicReference) {
                value = this.measuresBitSet.get();
                if (value == null) {
                    ImmutableBitSet actualValue = this.initMeasuresBitSet();
                    value = actualValue == null ? this.measuresBitSet : actualValue;
                    this.measuresBitSet.set(value);
                }
            }
        }
        return (ImmutableBitSet)(value == this.measuresBitSet ? null : value);
    }
}

