/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import org.apache.kylin.metadata.cube.planner.algorithm.BPUSCalculator;
import org.apache.kylin.metadata.cube.planner.algorithm.BenefitPolicy;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;

public class PBPUSCalculator
extends BPUSCalculator {
    public PBPUSCalculator(CuboidStats cuboidStats) {
        super(cuboidStats);
    }

    protected PBPUSCalculator(CuboidStats cuboidStats, ImmutableMap<BigInteger, Long> initCuboidAggCostMap) {
        super(cuboidStats, initCuboidAggCostMap);
    }

    @Override
    protected double getCostSaving(BigInteger descendant, BigInteger cuboid) {
        return this.getCuboidHitProbability(descendant) * super.getCostSaving(descendant, cuboid);
    }

    protected double getCuboidHitProbability(BigInteger cuboid) {
        return this.cuboidStats.getCuboidHitProbability(cuboid);
    }

    @Override
    public double getMinBenefitRatio() {
        int cuboidDomainSize = this.cuboidStats.getAllCuboidsForSelection().size();
        Preconditions.checkArgument((cuboidDomainSize > 0 ? 1 : 0) != 0, (Object)"The set of cuboids for selection is empty!!!");
        return super.getMinBenefitRatio() / (double)cuboidDomainSize;
    }

    @Override
    public BenefitPolicy getInstance() {
        return new PBPUSCalculator(this.cuboidStats, (ImmutableMap<BigInteger, Long>)this.initCuboidAggCostMap);
    }
}

