/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JoinDesc
implements Serializable {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="primary_key")
    private String[] primaryKey;
    @JsonProperty(value="foreign_key")
    private String[] foreignKey;
    @JsonProperty(value="non_equi_join_condition")
    private NonEquiJoinCondition nonEquiJoinCondition;
    @JsonProperty(value="primary_table")
    private String primaryTable;
    @JsonProperty(value="foreign_table")
    private String foreignTable;
    private boolean leftOrInner = false;
    private TblColRef[] primaryKeyColumns;
    private TblColRef[] foreignKeyColumns;
    private TableRef primaryTableRef;
    private TableRef foreignTableRef;

    public boolean isInnerJoin() {
        return "INNER".equalsIgnoreCase(this.type);
    }

    public boolean isLeftJoin() {
        return "LEFT".equalsIgnoreCase(this.type);
    }

    public boolean isLeftOrInnerJoin() {
        return this.leftOrInner;
    }

    public void setPrimaryKeyColumns(TblColRef[] primaryKeyColumns) {
        this.checkSameTable(primaryKeyColumns);
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public void setForeignKeyColumns(TblColRef[] foreignKeyColumns) {
        this.checkSameTable(this.primaryKeyColumns);
        this.foreignKeyColumns = foreignKeyColumns;
    }

    private void checkSameTable(TblColRef[] cols) {
        if (cols == null || cols.length == 0) {
            return;
        }
        TableRef tableRef = cols[0].getTableRef();
        for (int i = 1; i < cols.length; ++i) {
            Preconditions.checkState((tableRef == cols[i].getTableRef() ? 1 : 0) != 0);
        }
    }

    public TableRef getPKSide() {
        return this.primaryTableRef != null ? this.primaryTableRef : this.primaryKeyColumns[0].getTableRef();
    }

    public TableRef getFKSide() {
        return this.foreignTableRef != null ? this.foreignTableRef : this.foreignKeyColumns[0].getTableRef();
    }

    public void sortByFK() {
        Preconditions.checkState((this.primaryKey.length == this.foreignKey.length && this.primaryKey.length == this.primaryKeyColumns.length && this.foreignKey.length == this.foreignKeyColumns.length ? 1 : 0) != 0);
        boolean cont = true;
        int n = this.foreignKey.length;
        for (int i = 0; i < n - 1 && cont; ++i) {
            cont = false;
            for (int j = 0; j < n - 1 - i; ++j) {
                int jj = j + 1;
                if (this.foreignKey[j].compareTo(this.foreignKey[jj]) <= 0) continue;
                this.swap(this.foreignKey, j, jj);
                this.swap(this.primaryKey, j, jj);
                this.swap(this.foreignKeyColumns, j, jj);
                this.swap(this.primaryKeyColumns, j, jj);
                cont = true;
            }
        }
    }

    private void swap(String[] arr, int j, int jj) {
        String tmp = arr[j];
        arr[j] = arr[jj];
        arr[jj] = tmp;
    }

    private void swap(TblColRef[] arr, int j, int jj) {
        TblColRef tmp = arr[j];
        arr[j] = arr[jj];
        arr[jj] = tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.primaryKeyColumns);
        result = 31 * result + Arrays.hashCode(this.foreignKeyColumns);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinDesc other = (JoinDesc)obj;
        if (!Arrays.equals(this.foreignKey, other.foreignKey)) {
            return false;
        }
        if (!Arrays.equals(this.primaryKey, other.primaryKey)) {
            return false;
        }
        if (!Arrays.equals(this.foreignKeyColumns, other.foreignKeyColumns)) {
            return false;
        }
        if (!Arrays.equals(this.primaryKeyColumns, other.primaryKeyColumns)) {
            return false;
        }
        return this.type.equalsIgnoreCase(other.getType());
    }

    public boolean matches(JoinDesc other) {
        if (other == null) {
            return false;
        }
        if (!this.type.equalsIgnoreCase(other.getType())) {
            return false;
        }
        if (!this.columnDescEquals(this.foreignKeyColumns, other.foreignKeyColumns)) {
            return false;
        }
        return this.columnDescEquals(this.primaryKeyColumns, other.primaryKeyColumns);
    }

    private boolean columnDescEquals(TblColRef[] a, TblColRef[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getColumnDesc().equals(b[i].getColumnDesc())) continue;
            return false;
        }
        return true;
    }

    public boolean isNonEquiJoin() {
        return Objects.nonNull(this.nonEquiJoinCondition);
    }

    public boolean isJoinWithFactTable(String factTable) {
        TblColRef[] foreignKeyColumns = this.getForeignKeyColumns();
        if (foreignKeyColumns.length == 0) {
            return false;
        }
        TableRef tableRef = foreignKeyColumns[0].getTableRef();
        if (tableRef == null) {
            return false;
        }
        return factTable.equalsIgnoreCase(tableRef.getTableIdentity());
    }

    public void changeFKTableAlias(String oldAlias, String newAlias) {
        ArrayList fks = Lists.newArrayList();
        for (String fk : this.foreignKey) {
            String table = fk.split("\\.")[0];
            String column = fk.split("\\.")[1];
            if (table.equalsIgnoreCase(oldAlias)) {
                fks.add(newAlias + "." + column);
                continue;
            }
            fks.add(fk);
        }
        this.foreignKey = fks.toArray(new String[0]);
    }

    public String toString() {
        return "JoinDesc [type=" + this.type + ", primary_key=" + Arrays.toString(this.primaryKey) + ", foreign_key=" + Arrays.toString(this.foreignKey) + "]";
    }

    public List<String> getJoinKey() {
        ArrayList joinKey = Lists.newArrayList();
        if (this.primaryKey != null) {
            joinKey.addAll(Arrays.stream(this.primaryKey).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (this.foreignKey != null) {
            joinKey.addAll(Arrays.stream(this.foreignKey).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return joinKey;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    @Generated
    public String[] getForeignKey() {
        return this.foreignKey;
    }

    @Generated
    public NonEquiJoinCondition getNonEquiJoinCondition() {
        return this.nonEquiJoinCondition;
    }

    @Generated
    public String getPrimaryTable() {
        return this.primaryTable;
    }

    @Generated
    public String getForeignTable() {
        return this.foreignTable;
    }

    @Generated
    public boolean isLeftOrInner() {
        return this.leftOrInner;
    }

    @Generated
    public TblColRef[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    @Generated
    public TblColRef[] getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    @Generated
    public TableRef getPrimaryTableRef() {
        return this.primaryTableRef;
    }

    @Generated
    public TableRef getForeignTableRef() {
        return this.foreignTableRef;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setPrimaryKey(String[] primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Generated
    public void setForeignKey(String[] foreignKey) {
        this.foreignKey = foreignKey;
    }

    @Generated
    public void setNonEquiJoinCondition(NonEquiJoinCondition nonEquiJoinCondition) {
        this.nonEquiJoinCondition = nonEquiJoinCondition;
    }

    @Generated
    public void setPrimaryTable(String primaryTable) {
        this.primaryTable = primaryTable;
    }

    @Generated
    public void setForeignTable(String foreignTable) {
        this.foreignTable = foreignTable;
    }

    @Generated
    public void setLeftOrInner(boolean leftOrInner) {
        this.leftOrInner = leftOrInner;
    }

    @Generated
    public void setPrimaryTableRef(TableRef primaryTableRef) {
        this.primaryTableRef = primaryTableRef;
    }

    @Generated
    public void setForeignTableRef(TableRef foreignTableRef) {
        this.foreignTableRef = foreignTableRef;
    }

    public static class NonEquivJoinDesc
    extends JoinDesc {
        @Override
        public int hashCode() {
            return super.hashCode() * 31 + Objects.hashCode(this.getNonEquiJoinCondition());
        }

        @Override
        public boolean equals(Object o2) {
            if (Objects.isNull(o2) || !(o2 instanceof NonEquivJoinDesc)) {
                return false;
            }
            NonEquivJoinDesc nonEquivJoin = (NonEquivJoinDesc)o2;
            if (!super.equals(nonEquivJoin)) {
                return false;
            }
            return Objects.equals(this.getNonEquiJoinCondition(), nonEquivJoin.getNonEquiJoinCondition());
        }
    }

    public static class JoinDescBuilder {
        private final List<String> pks = new ArrayList<String>();
        private final List<TblColRef> pkCols = new ArrayList<TblColRef>();
        private final List<String> fks = new ArrayList<String>();
        private final List<TblColRef> fkCols = new ArrayList<TblColRef>();
        private TableRef primaryTableRef;
        private TableRef foreignTableRef;
        private NonEquiJoinCondition nonEquiJoinCondition;
        private String type;
        private boolean leftOrInner = false;

        public JoinDescBuilder addPrimaryKeys(String[] pkColNames, TblColRef[] colRefs) {
            this.pks.addAll(Arrays.asList(pkColNames));
            this.pkCols.addAll(Arrays.asList(colRefs));
            return this;
        }

        public JoinDescBuilder addForeignKeys(String[] fkColNames, TblColRef[] colRefs) {
            this.fks.addAll(Arrays.asList(fkColNames));
            this.fkCols.addAll(Arrays.asList(colRefs));
            return this;
        }

        public JoinDescBuilder addPrimaryKeys(Collection<TblColRef> colRefs) {
            this.pks.addAll(colRefs.stream().map(TblColRef::getName).collect(Collectors.toList()));
            this.pkCols.addAll(colRefs);
            return this;
        }

        public JoinDescBuilder addForeignKeys(Collection<TblColRef> colRefs) {
            this.fks.addAll(colRefs.stream().map(TblColRef::getName).collect(Collectors.toList()));
            this.fkCols.addAll(colRefs);
            return this;
        }

        public JoinDescBuilder setPrimaryTableRef(TableRef primaryTableRef) {
            this.primaryTableRef = primaryTableRef;
            return this;
        }

        public JoinDescBuilder setForeignTableRef(TableRef foreignTableRef) {
            this.foreignTableRef = foreignTableRef;
            return this;
        }

        public void setNonEquiJoinCondition(NonEquiJoinCondition nonEquiJoinCondition) {
            this.nonEquiJoinCondition = nonEquiJoinCondition;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setLeftOrInner(Boolean leftOrInner) {
            this.leftOrInner = leftOrInner;
        }

        public JoinDesc build() {
            JoinDesc join = new JoinDesc();
            join.setForeignKey(this.fks.toArray(new String[0]));
            join.setForeignKeyColumns(this.fkCols.toArray(new TblColRef[0]));
            join.setPrimaryKey(this.pks.toArray(new String[0]));
            join.setPrimaryKeyColumns(this.pkCols.toArray(new TblColRef[0]));
            join.primaryTable = this.primaryTableRef.getAlias();
            join.foreignTable = this.foreignTableRef.getAlias();
            join.primaryTableRef = this.primaryTableRef;
            join.foreignTableRef = this.foreignTableRef;
            join.nonEquiJoinCondition = this.nonEquiJoinCondition;
            join.type = this.type;
            join.leftOrInner = this.leftOrInner;
            return join;
        }
    }
}

