/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.table.ATable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTableMetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(NTableMetadataManager.class);
    private final KylinConfig config;
    private final String project;
    private CachedCrudAssist<TableDesc> srcTableCrud;
    private CachedCrudAssist<TableExtDesc> srcExtCrud;

    public static NTableMetadataManager getInstance(KylinConfig config, String project) {
        return (NTableMetadataManager)config.getManager(project, NTableMetadataManager.class);
    }

    static NTableMetadataManager newInstance(KylinConfig config, String project) {
        return new NTableMetadataManager(config, project);
    }

    private NTableMetadataManager(KylinConfig cfg, String project) {
        this.config = cfg;
        this.project = project;
        this.initSrcTable();
        this.initSrcExt();
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    private void initSrcTable() {
        this.srcTableCrud = new CachedCrudAssist<TableDesc>(this.getStore(), MetadataType.TABLE_INFO, this.project, TableDesc.class){

            @Override
            protected TableDesc initEntityAfterReload(TableDesc t, String resourceName) {
                t.init(NTableMetadataManager.this.project);
                return t;
            }
        };
    }

    public void invalidCache(String resourceName) {
        this.srcTableCrud.invalidateCache(resourceName);
        this.srcExtCrud.invalidateCache(resourceName);
    }

    public List<TableDesc> listAllTables() {
        return this.srcTableCrud.listAll();
    }

    public Map<String, List<TableDesc>> listTablesGroupBySchema() {
        return this.listAllTables().stream().collect(Collectors.groupingBy(ATable::getDatabase));
    }

    public Map<String, List<TableDesc>> dbToTablesMap(boolean streamingEnabled) {
        return this.listAllTables().stream().filter(table -> table.isAccessible(streamingEnabled)).collect(Collectors.groupingBy(table -> table.getDatabase().toUpperCase(Locale.ROOT), Collectors.toList()));
    }

    public Map<String, TableDesc> getAllTablesMap() {
        LinkedHashMap<String, TableDesc> ret = new LinkedHashMap<String, TableDesc>();
        for (TableDesc table : this.listAllTables()) {
            ret.put(table.getIdentity(), table);
        }
        return ret;
    }

    public List<String> getTableNamesByFuzzyKey(String fuzzyKey) {
        String[] keys = fuzzyKey.split("\\.", -1);
        if (keys.length == 2) {
            RawResourceFilter filter = new RawResourceFilter();
            if (!keys[0].isEmpty()) {
                filter.addConditions("dbName", Collections.singletonList(keys[0]), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
            }
            if (!keys[1].isEmpty()) {
                filter.addConditions("name", Collections.singletonList(keys[1]), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
            }
            return this.srcTableCrud.listByFilter(filter).stream().map(ATable::getIdentity).filter(identity -> StringUtils.containsIgnoreCase((CharSequence)identity, (CharSequence)fuzzyKey)).collect(Collectors.toList());
        }
        RawResourceFilter dbFilter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE, (String)"dbName", (Object)fuzzyKey);
        RawResourceFilter tableFilter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE, (String)"name", (Object)fuzzyKey);
        return Stream.concat(this.srcTableCrud.listByFilter(dbFilter).stream(), this.srcTableCrud.listByFilter(tableFilter).stream()).map(ATable::getIdentity).distinct().collect(Collectors.toList());
    }

    public TableDesc getTableDesc(String identity) {
        if (StringUtils.isEmpty((CharSequence)identity)) {
            return null;
        }
        return this.srcTableCrud.get(TableDesc.generateResourceName(this.project, identity));
    }

    public TableDesc copy(TableDesc tableDesc) {
        return this.srcTableCrud.copyBySerialization(tableDesc);
    }

    public TableDesc copyForWrite(TableDesc tableDesc) {
        if (tableDesc.getProject() == null) {
            tableDesc.setProject(this.project);
        }
        return this.srcTableCrud.copyForWrite(tableDesc);
    }

    public TableExtDesc copyForWrite(TableExtDesc tableExtDesc) {
        return this.srcExtCrud.copyForWrite(tableExtDesc);
    }

    @Deprecated
    public void saveSourceTable(TableDesc srcTable) {
        if (this.srcTableCrud.contains(srcTable.resourceName())) {
            this.updateTableDesc(srcTable.getIdentity(), arg_0 -> ((TableDesc)srcTable).copyPropertiesTo(arg_0));
        } else {
            this.createTableDesc(srcTable);
        }
    }

    public void removeSourceTable(String tableIdentity) {
        TableDesc t = this.getTableDesc(tableIdentity);
        if (t == null) {
            return;
        }
        this.srcTableCrud.delete(t);
    }

    public void resetProjectSpecificTableDesc() {
        this.srcTableCrud.reloadAll();
    }

    @Deprecated
    public void updateTableDesc(TableDesc tableDesc) {
        this.updateTableDesc(tableDesc.getIdentity(), arg_0 -> ((TableDesc)tableDesc).copyPropertiesTo(arg_0));
    }

    public void updateTableDesc(String identityName, TableDescUpdater updater) {
        TableDesc cached = this.getTableDesc(identityName);
        if (cached == null) {
            throw new IllegalStateException("tableDesc " + identityName + " does not exist");
        }
        TableDesc copy = this.copyForWrite(cached);
        updater.modify(copy);
        copy.init(this.project);
        this.srcTableCrud.save(copy);
    }

    public void createTableDesc(TableDesc srcTable) {
        srcTable.init(this.project);
        TableDesc copy = this.copyForWrite(srcTable);
        this.srcTableCrud.save(copy);
    }

    private void initSrcExt() {
        this.srcExtCrud = new CachedCrudAssist<TableExtDesc>(this.getStore(), MetadataType.TABLE_EXD, this.project, TableExtDesc.class){

            @Override
            protected TableExtDesc initEntityAfterReload(TableExtDesc t, String resourceName) {
                if (t.getIdentity() == null) {
                    t = NTableMetadataManager.this.convertOldTableExtToNewer(resourceName);
                }
                t.init(NTableMetadataManager.this.project);
                return t;
            }
        };
    }

    public TableExtDesc getOrCreateTableExt(String tableName) {
        TableDesc t = this.getTableDesc(tableName);
        if (t == null) {
            return null;
        }
        return this.getOrCreateTableExt(t);
    }

    public boolean isTableExtExist(String tableIdentity) {
        return this.getTableExtIfExists(this.getTableDesc(tableIdentity)) != null;
    }

    public TableExtDesc getOrCreateTableExt(TableDesc t) {
        TableExtDesc result = this.srcExtCrud.get(TableExtDesc.generateResourceName(this.project, t.getIdentity()));
        if (null == result) {
            result = new TableExtDesc();
            result.setIdentity(t.getIdentity());
            result.setUuid(RandomUtil.randomUUIDStr());
            result.setLastModified(0L);
            result.init(t.getProject());
        }
        return result;
    }

    public TableExtDesc getTableExtIfExists(TableDesc t) {
        return this.srcExtCrud.get(TableDesc.generateResourceName(this.project, t.getIdentity()));
    }

    public boolean isHighCardinalityDim(TblColRef colRef) {
        String tableIdentity = colRef.getTableRef().getTableIdentity();
        TableDesc tableDesc = this.getTableDesc(tableIdentity);
        TableExtDesc tableExtIfExists = this.getOrCreateTableExt(tableDesc);
        TableExtDesc.ColumnStats columnStats = tableExtIfExists.getColumnStatsByName(colRef.getName());
        if (Objects.isNull(columnStats)) {
            return false;
        }
        return (double)columnStats.getCardinality() / (double)tableExtIfExists.getTotalRows() > 0.2;
    }

    public Serializer<TableDesc> getTableMetadataSerializer() {
        return this.srcTableCrud.getSerializer();
    }

    @Deprecated
    public void saveTableExt(TableExtDesc tableExt) {
        if (this.srcExtCrud.contains(tableExt.resourceName())) {
            this.updateTableExt(tableExt.getIdentity(), tableExt::copyPropertiesTo);
        } else {
            this.createTableExt(tableExt);
        }
    }

    public void mergeAndUpdateTableExt(TableExtDesc origin, TableExtDesc other) {
        this.updateTableExt(origin.getIdentity(), copyForWrite -> {
            copyForWrite.setColumnStats(other.getAllColumnStats());
            copyForWrite.setSampleRows(other.getSampleRows());
            copyForWrite.setTotalRows(other.getTotalRows());
            copyForWrite.setJodID(other.getJodID());
            copyForWrite.setExcluded(other.isExcluded());
            copyForWrite.setExcludedColumns(other.getExcludedColumns());
            if (other.getOriginalSize() != -1L) {
                copyForWrite.setOriginalSize(other.getOriginalSize());
            }
        });
    }

    public void updateTableExt(String tableName, TableExtDescUpdater updater) {
        TableExtDesc cached = this.getOrCreateTableExt(tableName);
        TableExtDesc copy = this.copyForWrite(cached);
        updater.modify(copy);
        this.srcExtCrud.save(copy);
    }

    public void createTableExt(TableExtDesc tableExt) {
        if (tableExt.getUuid() == null || tableExt.getIdentity() == null) {
            throw new IllegalArgumentException();
        }
        TableExtDesc copy = this.copyForWrite(tableExt);
        this.srcExtCrud.save(copy);
    }

    public void saveOrUpdateTableExt(boolean isUpdate, TableExtDesc tableExt) {
        if (isUpdate) {
            this.mergeAndUpdateTableExt(tableExt, tableExt);
        } else {
            this.createTableExt(tableExt);
        }
    }

    public void removeTableExt(String tableName) {
        TableExtDesc t = this.getTableExtIfExists(this.getTableDesc(tableName));
        if (t == null) {
            return;
        }
        this.srcExtCrud.delete(t);
    }

    public boolean existsSnapshotTableByName(String tableName) {
        String snapshotDir = this.getTableDesc(tableName).getLastSnapshotPath();
        return StringUtils.isNotEmpty((CharSequence)snapshotDir);
    }

    private TableExtDesc convertOldTableExtToNewer(String resourceName) {
        ResourceStore store = this.getStore();
        HashMap attrs = Maps.newHashMap();
        try {
            RawResource res = store.getResource("/table_exd/" + resourceName + ".json");
            try (InputStream is = res.getByteSource().openStream();){
                attrs.putAll((Map)JsonUtil.readValue((InputStream)is, HashMap.class));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        String cardinality = (String)attrs.get("cardinality");
        String tableIdentity = (String)TableDesc.parseResourcePath(resourceName).getFirst();
        TableExtDesc result = new TableExtDesc();
        result.setIdentity(tableIdentity);
        result.setUuid(RandomUtil.randomUUIDStr());
        result.setLastModified(0L);
        result.setCardinality(cardinality);
        return result;
    }

    public static interface TableExtDescUpdater {
        public void modify(TableExtDesc var1);
    }

    public static interface TableDescUpdater {
        public void modify(TableDesc var1);
    }
}

