/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;

public class SchemaNode {
    @NonNull
    SchemaNodeType type;
    @NonNull
    final String key;
    Map<String, Object> attributes;
    List<String> ignoreAttributes;
    Map<String, Object> keyAttributes;
    private final int hashcode;

    public SchemaNode(SchemaNodeType type, String key) {
        this(type, key, Maps.newHashMap(), new String[0]);
    }

    public SchemaNode(SchemaNodeType type, String key, Map<String, Object> attributes, String ... ignore) {
        this.type = type;
        this.key = key;
        this.attributes = attributes;
        this.ignoreAttributes = Arrays.asList(ignore);
        this.keyAttributes = attributes.keySet().stream().filter(attribute -> !this.ignoreAttributes.contains(attribute)).collect(Collectors.toMap(Function.identity(), attributes::get));
        this.hashcode = Objects.hash(key);
    }

    public static SchemaNode ofTableColumn(ColumnDesc columnDesc) {
        return new SchemaNode(SchemaNodeType.TABLE_COLUMN, columnDesc.getTable().getIdentity() + "." + columnDesc.getName(), (Map<String, Object>)ImmutableMap.of((Object)"datatype", (Object)columnDesc.getDatatype()), new String[0]);
    }

    public static SchemaNode ofTable(TableDesc tableDesc) {
        return new SchemaNode(SchemaNodeType.MODEL_TABLE, tableDesc.getIdentity());
    }

    public static SchemaNode ofTable(TableRef tableRef) {
        return new SchemaNode(SchemaNodeType.MODEL_TABLE, tableRef.getTableIdentity());
    }

    public static SchemaNode ofModelFactTable(TableRef tableRef, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_FACT, modelAlias + "/" + tableRef.getTableIdentity());
    }

    public static SchemaNode ofModelDimensionTable(TableRef tableRef, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_DIM, modelAlias + "/" + tableRef.getTableIdentity());
    }

    public static SchemaNode ofModelColumn(NDataModel.NamedColumn namedColumn, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_COLUMN, modelAlias + "/" + namedColumn.getName(), (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)String.valueOf(namedColumn.getId())), "id");
    }

    public static SchemaNode ofModelCC(ComputedColumnDesc cc, String modelAlias, String factTable) {
        return new SchemaNode(SchemaNodeType.MODEL_CC, modelAlias + "/" + cc.getColumnName(), (Map<String, Object>)ImmutableMap.of((Object)"expression", (Object)SchemaNode.transformCCExprToUpperCase(cc.getExpression()), (Object)"fact_table", (Object)factTable), "fact_table");
    }

    private static String transformCCExprToUpperCase(String expression) {
        String expr = expression.replace("\r\n", "\n");
        ArrayList retainedStrings = new ArrayList(Collections.emptyList());
        Pattern patternQuote = Pattern.compile("('[\\S]+')");
        Matcher matcher = patternQuote.matcher(expr);
        int matchEnd = 0;
        while (matcher.find(matchEnd)) {
            retainedStrings.add(matcher.group(1));
            int matchStart = matcher.start();
            expr = expr.substring(0, matchEnd).concat(StringUtils.upperCase((String)expr.substring(matchEnd, matchStart))).concat(expr.substring(matchStart));
            matchEnd = matcher.end();
        }
        expr = expr.substring(0, matchEnd).concat(StringUtils.upperCase((String)expr.substring(matchEnd)));
        if (retainedStrings.isEmpty()) {
            return StringUtils.upperCase((String)expr);
        }
        return expr;
    }

    public static SchemaNode ofDimension(NDataModel.NamedColumn namedColumn, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_DIMENSION, modelAlias + "/" + namedColumn.getName(), (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)namedColumn.getName(), (Object)"alias_dot_column", (Object)namedColumn.getAliasDotColumn(), (Object)"id", (Object)String.valueOf(namedColumn.getId())), "id");
    }

    public static SchemaNode ofMeasure(NDataModel.Measure measure, String modelAlias) {
        List<Object> parameters = new ArrayList();
        if (measure.getFunction().getParameters() != null) {
            parameters = measure.getFunction().getParameters().stream().map(parameterDesc -> new FunctionParameter(parameterDesc.getType(), parameterDesc.getValue())).collect(Collectors.toList());
        }
        return new SchemaNode(SchemaNodeType.MODEL_MEASURE, modelAlias + "/" + measure.getName(), (Map<String, Object>)ImmutableMap.of((Object)"name", (Object)measure.getName(), (Object)"expression", (Object)measure.getFunction().getExpression(), (Object)"returntype", (Object)measure.getFunction().getReturnType(), (Object)"parameters", parameters, (Object)"id", (Object)String.valueOf(measure.getId())), "id");
    }

    public static SchemaNode ofPartition(PartitionDesc partitionDesc, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_PARTITION, modelAlias, (Map<String, Object>)ImmutableMap.of((Object)"column", (Object)partitionDesc.getPartitionDateColumn(), (Object)"format", (Object)(partitionDesc.getPartitionDateFormat() != null ? partitionDesc.getPartitionDateFormat() : "")), new String[0]);
    }

    public static SchemaNode ofMultiplePartition(MultiPartitionDesc multiPartitionDesc, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_MULTIPLE_PARTITION, modelAlias, (Map<String, Object>)ImmutableMap.of((Object)"columns", multiPartitionDesc.getColumns(), (Object)"partitions", multiPartitionDesc.getPartitions().stream().map(MultiPartitionDesc.PartitionInfo::getValues).map(Arrays::asList).collect(Collectors.toList())), new String[0]);
    }

    public static SchemaNode ofJoin(JoinTableDesc joinTableDesc, TableRef fkTableRef, TableRef pkTableRef, JoinDesc joinDesc, String modelAlias) {
        return new SchemaNode(SchemaNodeType.MODEL_JOIN, modelAlias + "/" + fkTableRef.getAlias() + "-" + pkTableRef.getAlias(), (Map<String, Object>)ImmutableMap.builder().put((Object)"join_relation_type", (Object)joinTableDesc.getJoinRelationTypeEnum()).put((Object)"primary_table", (Object)pkTableRef.getAlias()).put((Object)"foreign_table", (Object)fkTableRef.getAlias()).put((Object)"join_type", (Object)joinDesc.getType()).put((Object)"primary_keys", Arrays.asList(joinDesc.getPrimaryKey())).put((Object)"foreign_keys", Arrays.asList(joinDesc.getForeignKey())).put((Object)"non_equal_join_condition", (Object)(joinDesc.getNonEquiJoinCondition() != null ? joinDesc.getNonEquiJoinCondition().getExpr() : "")).build(), new String[0]);
    }

    public static SchemaNode ofFilter(String modelAlias, String condition) {
        return new SchemaNode(SchemaNodeType.MODEL_FILTER, modelAlias, (Map<String, Object>)ImmutableMap.of((Object)"condition", (Object)condition), new String[0]);
    }

    public static SchemaNode ofIndex(SchemaNodeType type, LayoutEntity layout, NDataModel model, Map<Integer, String> modelColumnMeasureIdMap, List<Integer> aggShardByColumns) {
        List<String> colOrders = SchemaNode.getLayoutIdColumn(layout, modelColumnMeasureIdMap);
        List<String> shardBy = aggShardByColumns == null ? SchemaNode.getLayoutShardByColumn(layout, modelColumnMeasureIdMap) : SchemaNode.getColumnMeasureName(aggShardByColumns, modelColumnMeasureIdMap);
        List<String> sortBy = SchemaNode.getLayoutSortByColumn(layout, modelColumnMeasureIdMap);
        String key = model.getAlias() + "/" + String.join((CharSequence)",", colOrders) + "/" + String.join((CharSequence)",", shardBy) + "/" + String.join((CharSequence)",", sortBy);
        return new SchemaNode(type, key, (Map<String, Object>)ImmutableMap.of((Object)"col_orders", colOrders, (Object)"shard_by", shardBy, (Object)"sort_by", sortBy, (Object)"id", (Object)String.valueOf(layout.getId())), "id");
    }

    private static List<String> getLayoutIdColumn(LayoutEntity layout, Map<Integer, String> modelColumnMeasureIdMap) {
        return SchemaNode.getColumnMeasureName(layout.getColOrder(), modelColumnMeasureIdMap);
    }

    private static List<String> getLayoutShardByColumn(LayoutEntity layout, Map<Integer, String> modelColumnMeasureIdMap) {
        return SchemaNode.getColumnMeasureName(layout.getShardByColumns(), modelColumnMeasureIdMap);
    }

    private static List<String> getLayoutSortByColumn(LayoutEntity layout, Map<Integer, String> modelColumnMeasureIdMap) {
        return SchemaNode.getColumnMeasureName(layout.getSortByColumns(), modelColumnMeasureIdMap);
    }

    private static List<String> getColumnMeasureName(List<Integer> columnIds, Map<Integer, String> modelColumnMeasureIdMap) {
        if (columnIds == null) {
            return Lists.newArrayList();
        }
        return columnIds.stream().map(modelColumnMeasureIdMap::get).collect(Collectors.toList());
    }

    public String getSubject() {
        return this.type.getSubject(this.key);
    }

    public String getDetail() {
        return this.type.getDetail(this.key, this.attributes);
    }

    public SchemaNodeIdentifier getIdentifier() {
        return new SchemaNodeIdentifier(this.getType(), this.getKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaNode that = (SchemaNode)o;
        return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.keyAttributes, that.keyAttributes);
    }

    public int hashCode() {
        return this.hashcode;
    }

    @NonNull
    @Generated
    public SchemaNodeType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<String> getIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    @Generated
    public Map<String, Object> getKeyAttributes() {
        return this.keyAttributes;
    }

    @Generated
    public int getHashcode() {
        return this.hashcode;
    }

    @Generated
    public void setType(@NonNull SchemaNodeType type) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.type = type;
    }

    @Generated
    public String toString() {
        return "SchemaNode(type=" + (Object)((Object)this.getType()) + ", key=" + this.getKey() + ", attributes=" + this.getAttributes() + ", ignoreAttributes=" + this.getIgnoreAttributes() + ", keyAttributes=" + this.getKeyAttributes() + ", hashcode=" + this.getHashcode() + ")";
    }

    @Generated
    private void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    private void setIgnoreAttributes(List<String> ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
    }

    @Generated
    private void setKeyAttributes(Map<String, Object> keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    @Generated
    public SchemaNode withKey(String key) {
        return this.getType().withKey(key);
    }

    @Generated
    public boolean isModelNode() {
        return this.getType().isModelNode();
    }

    @Generated
    public String getSubject(String key) {
        return this.getType().getSubject(key);
    }

    @Generated
    public String getDetail(String key, Map<String, Object> attributes) {
        return this.getType().getDetail(key, attributes);
    }

    @Generated
    public boolean isCauseModelBroken() {
        return this.getType().isCauseModelBroken();
    }

    @Generated
    public String name() {
        return this.getType().name();
    }

    @Generated
    public int ordinal() {
        return this.getType().ordinal();
    }

    @Generated
    public int compareTo(SchemaNodeType arg0) {
        return this.getType().compareTo(arg0);
    }

    @Generated
    public Class<SchemaNodeType> getDeclaringClass() {
        return this.getType().getDeclaringClass();
    }

    public static class FunctionParameter {
        private String type;
        private String value;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionParameter)) {
                return false;
            }
            FunctionParameter other = (FunctionParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionParameter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaNode.FunctionParameter(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public FunctionParameter(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }

    public static class SchemaNodeIdentifier {
        private SchemaNodeType type;
        private String key;

        @Generated
        public SchemaNodeType getType() {
            return this.type;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public void setType(SchemaNodeType type) {
            this.type = type;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaNodeIdentifier)) {
                return false;
            }
            SchemaNodeIdentifier other = (SchemaNodeIdentifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaNodeType this$type = this.getType();
            SchemaNodeType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaNodeIdentifier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaNodeType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaNode.SchemaNodeIdentifier(type=" + (Object)((Object)this.getType()) + ", key=" + this.getKey() + ")";
        }

        @Generated
        public SchemaNodeIdentifier(SchemaNodeType type, String key) {
            this.type = type;
            this.key = key;
        }
    }
}

