/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridRealization
implements IRealization {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HybridRealization.class);
    public static final String REALIZATION_TYPE = "HYBRID";
    private String uuid;
    private final List<IRealization> realizations = new ArrayList<IRealization>();
    private volatile IRealization batchRealization;
    private volatile IRealization streamingRealization;
    private String project;
    private List<TblColRef> allDimensions = null;
    private Set<TblColRef> allColumns = null;
    private List<MeasureDesc> allMeasures = null;
    private long dateRangeStart;
    private long dateRangeEnd;
    private boolean isReady = false;
    private KylinConfigExt config;

    public HybridRealization(IRealization batchRealization, IRealization streamingRealization, String project) {
        if (batchRealization == null || streamingRealization == null) {
            return;
        }
        this.batchRealization = batchRealization;
        this.streamingRealization = streamingRealization;
        this.realizations.add(batchRealization);
        this.realizations.add(streamingRealization);
        this.project = project;
        LinkedHashSet<TblColRef> columns = new LinkedHashSet<TblColRef>();
        LinkedHashSet<TblColRef> dimensions = new LinkedHashSet<TblColRef>();
        this.allMeasures = Lists.newArrayList();
        this.dateRangeStart = 0L;
        this.dateRangeEnd = Long.MAX_VALUE;
        for (IRealization realization : this.realizations) {
            columns.addAll(realization.getAllColumns());
            dimensions.addAll(realization.getAllDimensions());
            this.allMeasures.addAll(realization.getMeasures());
            if (realization.isOnline()) {
                this.isReady = true;
            }
            if (this.dateRangeStart == 0L || realization.getDateRangeStart() < this.dateRangeStart) {
                this.dateRangeStart = realization.getDateRangeStart();
            }
            if (this.dateRangeStart != Long.MAX_VALUE && realization.getDateRangeEnd() <= this.dateRangeEnd) continue;
            this.dateRangeEnd = realization.getDateRangeEnd();
        }
        if (streamingRealization.getMeasures().isEmpty()) {
            this.allMeasures.addAll(streamingRealization.getModel().getAllMeasures());
        }
        this.allDimensions = Lists.newArrayList(dimensions);
        this.allColumns = columns;
        this.uuid = streamingRealization.getUuid();
        this.sortRealizations();
    }

    private void sortRealizations() {
        this.realizations.sort((realization1, realization2) -> {
            long dateRangeStart2;
            long dateRangeStart1 = realization1.getDateRangeStart();
            long comp = dateRangeStart1 - (dateRangeStart2 = realization2.getDateRangeStart());
            if (comp != 0L) {
                return comp > 0L ? 1 : -1;
            }
            dateRangeStart1 = realization1.getDateRangeEnd();
            comp = dateRangeStart1 - (dateRangeStart2 = realization2.getDateRangeEnd());
            if (comp != 0L) {
                return comp > 0L ? 1 : -1;
            }
            return 0;
        });
    }

    @Override
    public int getCost() {
        int c = Integer.MAX_VALUE;
        for (IRealization realization : this.getRealizations()) {
            c = Math.min(realization.getCost(), c);
        }
        return --c;
    }

    @Override
    public List<IRealization> getRealizations() {
        return this.realizations;
    }

    @Override
    public FunctionDesc findAggrFunc(FunctionDesc aggrFunc) {
        for (MeasureDesc measure : this.getMeasures()) {
            if (!measure.getFunction().equals(aggrFunc)) continue;
            return measure.getFunction();
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (aggrFunc.isCountOnColumn() && kylinConfig.isReplaceColCountWithCountStar()) {
            return FunctionDesc.newCountOne();
        }
        return aggrFunc;
    }

    public IRealization getBatchRealization() {
        return this.batchRealization;
    }

    public IRealization getStreamingRealization() {
        return this.streamingRealization;
    }

    @Override
    public String getType() {
        return REALIZATION_TYPE;
    }

    public KylinConfigExt getConfig() {
        return this.config;
    }

    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    @Override
    public NDataModel getModel() {
        return NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project).getDataModelDesc(this.uuid);
    }

    @Override
    public Set<TblColRef> getAllColumns() {
        return this.allColumns;
    }

    @Override
    public List<MeasureDesc> getMeasures() {
        return this.allMeasures;
    }

    @Override
    public List<TblColRef> getAllDimensions() {
        return this.allDimensions;
    }

    @Override
    public boolean isOnline() {
        return this.isReady;
    }

    @Override
    public String getCanonicalName() {
        return this.getType() + "[name=" + this.getModel().getAlias() + "]";
    }

    @Override
    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    @Override
    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    @Override
    public boolean hasPrecalculatedFields() {
        return true;
    }

    @Override
    public int getStorageType() {
        return 20;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    @Generated
    public String getUuid() {
        return this.uuid;
    }
}

