/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DimensionRecItemV2
extends RecItemV2
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DimensionRecItemV2.class);
    @JsonProperty(value="column")
    private NDataModel.NamedColumn column;
    @JsonProperty(value="data_type")
    private String dataType;

    public DimensionRecItemV2(NDataModel.NamedColumn column, TblColRef tblColRef, String uniqueContent) {
        this.setColumn(column);
        this.setDataType(tblColRef.getDatatype());
        this.setCreateTime(System.currentTimeMillis());
        this.setUniqueContent(uniqueContent);
        this.setUuid(String.format(Locale.ROOT, "dimension_%s", RandomUtil.randomUUIDStr()));
    }

    @Override
    public int[] genDependIds(Map<String, RawRecItem> uniqueRecItemMap, String content, NDataModel dataModel) {
        if (uniqueRecItemMap.containsKey(content)) {
            return new int[]{-1 * uniqueRecItemMap.get(content).getId()};
        }
        String[] arr = content.split("\\$");
        if (arr.length == 2) {
            try {
                Map<String, TableRef> tableAliasMap = dataModel.getAliasMap();
                Preconditions.checkArgument((boolean)tableAliasMap.containsKey(arr[0]));
                TableRef tableRef = tableAliasMap.get(arr[0]);
                ColumnDesc tableColumn = RawRecUtil.findColumn(arr[1], tableRef.getTableDesc());
                String columnName = this.column.getAliasDotColumn().split("\\.")[1];
                Preconditions.checkArgument((boolean)tableColumn.getName().equalsIgnoreCase(columnName));
            }
            catch (Exception e) {
                log.error("validate DimensionRecItemV2 dependIds error.", (Throwable)e);
                return new int[]{Integer.MAX_VALUE};
            }
        }
        return new int[]{this.getColumn().getId()};
    }

    @Generated
    public NDataModel.NamedColumn getColumn() {
        return this.column;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public void setColumn(NDataModel.NamedColumn column) {
        this.column = column;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public DimensionRecItemV2() {
    }
}

