/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class LayoutRecItemV2
extends RecItemV2
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LayoutRecItemV2.class);
    @JsonProperty(value="layout")
    private LayoutEntity layout;
    @JsonProperty(value="is_agg")
    private boolean isAgg;

    @Override
    public String getUniqueContent() {
        return this.layout.genUniqueContent();
    }

    public String getUniqueId(String modelId) {
        return modelId + "@" + this.layout.getId();
    }

    public int[] genDependIds() {
        ImmutableList<Integer> colOrder = this.layout.getColOrder();
        int[] arr = new int[colOrder.size()];
        for (int i = 0; i < colOrder.size(); ++i) {
            arr[i] = (Integer)colOrder.get(i);
        }
        return arr;
    }

    @Override
    public int[] genDependIds(Map<String, RawRecItem> nonLayoutUniqueFlagRecMap, String content, NDataModel dataModel) {
        return this.genDependIds();
    }

    public void updateLayoutContent(NDataModel dataModel, Map<String, RawRecItem> nonLayoutUniqueFlagRecMap, Set<String> newCcUuids) {
        Map<String, ComputedColumnDesc> ccMap = dataModel.getCcMap();
        HashMap uniqueContentRecMap = Maps.newHashMap();
        nonLayoutUniqueFlagRecMap.forEach((uniqueFlag, recItem) -> {
            if (recItem.getModelID().equalsIgnoreCase(dataModel.getUuid())) {
                uniqueContentRecMap.put(recItem.getRecEntity().getUniqueContent(), recItem);
            }
        });
        ImmutableList<Integer> originColOrder = this.layout.getColOrder();
        List<Integer> originShardCols = this.layout.getShardByColumns();
        List<Integer> originSortCols = this.layout.getSortByColumns();
        List<Integer> originPartitionCols = this.layout.getPartitionByColumns();
        List<Integer> colOrderInDB = this.getColIDInDB(ccMap, newCcUuids, dataModel, (List<Integer>)originColOrder, uniqueContentRecMap);
        List<Integer> shardColsInDB = this.getColIDInDB(ccMap, newCcUuids, dataModel, originShardCols, uniqueContentRecMap);
        List<Integer> sortColsInDB = this.getColIDInDB(ccMap, newCcUuids, dataModel, originSortCols, uniqueContentRecMap);
        List<Integer> partitionColsInDB = this.getColIDInDB(ccMap, newCcUuids, dataModel, originPartitionCols, uniqueContentRecMap);
        this.layout.setColOrder(colOrderInDB);
        this.layout.setShardByColumns(shardColsInDB);
        this.layout.setPartitionByColumns(partitionColsInDB);
        log.debug("Origin colOrder is {}, converted to {}", originColOrder, colOrderInDB);
        log.debug("Origin shardBy columns is {}, converted to {}", originShardCols, shardColsInDB);
        log.debug("Origin sortBy columns is {}, converted to {}", originSortCols, sortColsInDB);
        log.debug("Origin partition columns is {}, converted to {}", originPartitionCols, partitionColsInDB);
    }

    private List<Integer> getColIDInDB(Map<String, ComputedColumnDesc> ccNameMap, Set<String> newCcUuids, NDataModel model, List<Integer> columnIDs, Map<String, RawRecItem> uniqueContentToRecItemMap) {
        ArrayList colOrderInDB = Lists.newArrayListWithCapacity((int)columnIDs.size());
        columnIDs.forEach(colId -> {
            String uniqueContent;
            if (colId < 100000) {
                TblColRef tblColRef = (TblColRef)model.getEffectiveCols().get(colId);
                uniqueContent = RawRecUtil.dimensionUniqueContent(tblColRef, ccNameMap, newCcUuids);
            } else {
                NDataModel.Measure measure = (NDataModel.Measure)model.getEffectiveMeasures().get(colId);
                uniqueContent = RawRecUtil.measureUniqueContent(measure, ccNameMap, newCcUuids);
            }
            if (uniqueContentToRecItemMap.containsKey(uniqueContent)) {
                colOrderInDB.add(-((RawRecItem)uniqueContentToRecItemMap.get(uniqueContent)).getId());
            } else {
                colOrderInDB.add(colId);
            }
        });
        return colOrderInDB;
    }

    @Generated
    public LayoutEntity getLayout() {
        return this.layout;
    }

    @Generated
    public boolean isAgg() {
        return this.isAgg;
    }

    @Generated
    public void setLayout(LayoutEntity layout) {
        this.layout = layout;
    }

    @Generated
    public void setAgg(boolean isAgg) {
        this.isAgg = isAgg;
    }
}

