/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.entity;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class MeasureRecItemV2
extends RecItemV2
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeasureRecItemV2.class);
    @JsonProperty(value="measure")
    private NDataModel.Measure measure;
    @JsonProperty(value="param_order")
    private long[] paramOrder;

    @Override
    public int[] genDependIds(Map<String, RawRecItem> nonLayoutUniqueFlagRecMap, String content, NDataModel dataModel) {
        Set<TableRef> allTables = dataModel.getAllTableRefs();
        HashMap tableMap = Maps.newHashMap();
        allTables.forEach(tableRef -> tableMap.putIfAbsent(tableRef.getAlias(), tableRef));
        Map<String, NDataModel.NamedColumn> namedColumnMap = MeasureRecItemV2.getNamedColumnMap(dataModel);
        String[] params = content.split("__");
        int[] dependIDs = new int[params.length - 1];
        for (int i = 1; i < params.length; ++i) {
            if (nonLayoutUniqueFlagRecMap.containsKey(params[i])) {
                dependIDs[i - 1] = -1 * nonLayoutUniqueFlagRecMap.get(params[i]).getId();
                continue;
            }
            String[] splits = params[i].split("\\$");
            if (splits.length == 2) {
                try {
                    String alias = splits[0];
                    Preconditions.checkArgument((boolean)tableMap.containsKey(alias));
                    TableDesc tableDesc = ((TableRef)tableMap.get(alias)).getTableDesc();
                    ColumnDesc dependColumn = RawRecUtil.findColumn(splits[1], tableDesc);
                    String aliasDotName = String.format(Locale.ROOT, "%s.%s", alias, dependColumn.getName());
                    dependIDs[i - 1] = namedColumnMap.get(aliasDotName).getId();
                }
                catch (IllegalArgumentException e) {
                    log.warn("fail to find depend column due to ", (Throwable)e);
                    dependIDs[i - 1] = Integer.MAX_VALUE;
                }
                continue;
            }
            dependIDs[i - 1] = Integer.MAX_VALUE;
        }
        return dependIDs;
    }

    public static Map<String, NDataModel.NamedColumn> getNamedColumnMap(NDataModel dataModel) {
        HashMap namedColumnMap = Maps.newHashMap();
        dataModel.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).forEach(namedColumn -> {
            String aliasDotColumn = namedColumn.getAliasDotColumn();
            namedColumnMap.putIfAbsent(aliasDotColumn, namedColumn);
        });
        return namedColumnMap;
    }

    @Generated
    public NDataModel.Measure getMeasure() {
        return this.measure;
    }

    @Generated
    public long[] getParamOrder() {
        return this.paramOrder;
    }

    @Generated
    public void setMeasure(NDataModel.Measure measure) {
        this.measure = measure;
    }

    @Generated
    public void setParamOrder(long[] paramOrder) {
        this.paramOrder = paramOrder;
    }
}

