/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.state.IStateSwitch;
import org.apache.kylin.metadata.state.JdbcShareStateStore;
import org.apache.kylin.metadata.state.ShareStateInfo;

public class MetadataStateSwitch
implements IStateSwitch {
    private JdbcShareStateStore jdbcResourceStateStore = JdbcShareStateStore.getInstance();

    public void init(String instanceName, Map<String, String> initStateMap) {
        String serializeToString = MetadataStateSwitch.convertMapToString(initStateMap);
        ShareStateInfo shareStateInfo = this.jdbcResourceStateStore.selectShareStateByInstanceName(instanceName);
        if (shareStateInfo == null) {
            this.jdbcResourceStateStore.insert(instanceName, serializeToString);
        } else if (!serializeToString.equals(shareStateInfo.getShareState())) {
            Map<String, String> curStateMap = MetadataStateSwitch.convertStringToMap(shareStateInfo.getShareState());
            initStateMap.forEach(curStateMap::put);
            this.jdbcResourceStateStore.update(instanceName, MetadataStateSwitch.convertMapToString(curStateMap));
        }
    }

    public void put(String instanceName, String stateName, String stateValue) {
        ShareStateInfo shareStateInfo = this.jdbcResourceStateStore.selectShareStateByInstanceName(instanceName);
        if (shareStateInfo != null) {
            Map<String, String> stateMap = MetadataStateSwitch.convertStringToMap(shareStateInfo.getShareState());
            stateMap.put(stateName, stateValue);
            String serializeToString = MetadataStateSwitch.convertMapToString(stateMap);
            this.jdbcResourceStateStore.update(instanceName, serializeToString);
        }
    }

    public String get(String instanceName, String stateName) {
        ShareStateInfo shareStateInfo = this.jdbcResourceStateStore.selectShareStateByInstanceName(instanceName);
        String stateValue = null;
        if (shareStateInfo != null) {
            Map<String, String> stateMap = MetadataStateSwitch.convertStringToMap(shareStateInfo.getShareState());
            stateValue = stateMap.get(stateName);
        }
        return stateValue;
    }

    public static String convertMapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        map.forEach((key, val) -> stringBuilder.append((String)key).append("-").append((String)val).append(";"));
        return stringBuilder.toString().replace("\u0000", "");
    }

    public static Map<String, String> convertStringToMap(String string) {
        String[] nameAndValueArray;
        HashMap<String, String> result = new HashMap<String, String>();
        if (string == null || string.isEmpty()) {
            return result;
        }
        for (String nameAndValue : nameAndValueArray = string.split(";")) {
            String[] pair = nameAndValue.split("-");
            result.put(pair[0].trim(), pair[1].trim());
        }
        return result;
    }
}

