/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.engine.spark.utils.ComputedColumnEvalUtil;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.util.ExpandableMeasureUtil;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.ChainedProposer;
import org.apache.kylin.rec.IndexPlanOptProposer;
import org.apache.kylin.rec.IndexPlanSelectProposer;
import org.apache.kylin.rec.IndexPlanShrinkProposer;
import org.apache.kylin.rec.ModelInfoAdjustProposer;
import org.apache.kylin.rec.ModelOptProposer;
import org.apache.kylin.rec.ModelRenameProposer;
import org.apache.kylin.rec.ModelSelectProposer;
import org.apache.kylin.rec.SQLAnalysisProposer;
import org.apache.kylin.rec.model.ModelTree;

public class SmartContext
extends AbstractContext {
    private final ExpandableMeasureUtil expandableMeasureUtil = new ExpandableMeasureUtil((model, ccDesc) -> {
        String ccExpression = PushDownUtil.massageComputedColumn((NDataModel)model, (String)model.getProject(), (ComputedColumnDesc)ccDesc, null);
        ccDesc.setInnerExpression(ccExpression);
        ComputedColumnEvalUtil.evaluateExprAndType((NDataModel)model, (ComputedColumnDesc)ccDesc);
    });

    public SmartContext(KylinConfig kylinConfig, String project, String[] sqls) {
        super(kylinConfig, project, sqls);
        this.canCreateNewModel = true;
    }

    @Override
    public AbstractContext.ModelContext createModelContext(ModelTree modelTree) {
        return new AbstractContext.ModelContext(this, modelTree);
    }

    @Override
    public IndexPlan getOriginIndexPlan(String modelId) {
        return NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getIndexPlan(modelId);
    }

    @Override
    public List<NDataModel> getOriginModels() {
        return NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).listAllModels().stream().filter(model -> !model.isBroken()).collect(Collectors.toList());
    }

    @Override
    public void changeModelMainType(NDataModel model) {
        model.setManagementType(ManagementType.MODEL_BASED);
    }

    @Override
    public String getIdentifier() {
        return "Auto-Modeling";
    }

    @Override
    public void saveMetadata() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            this.saveModel();
            this.saveIndexPlan();
            return true;
        }, (String)this.getProject());
    }

    void saveModel() {
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        for (AbstractContext.ModelContext modelCtx : this.getModelContexts()) {
            if (modelCtx.skipSavingMetadata()) continue;
            NDataModel model = modelCtx.getTargetModel();
            NDataModel updated = dataModelManager.getDataModelDesc(model.getUuid()) != null ? dataModelManager.updateDataModelDesc(model) : dataModelManager.createDataModelDesc(model, model.getOwner());
            this.expandableMeasureUtil.deleteExpandableMeasureInternalMeasures(updated);
            this.expandableMeasureUtil.expandExpandableMeasure(updated);
            updated = dataModelManager.updateDataModelDesc(updated);
            IndexPlan indexPlan = modelCtx.getTargetIndexPlan();
            ExpandableMeasureUtil.expandRuleBasedIndex((RuleBasedIndex)indexPlan.getRuleBasedIndex(), (NDataModel)updated);
            ExpandableMeasureUtil.expandIndexPlanIndexes((IndexPlan)indexPlan, (NDataModel)updated);
        }
    }

    private void saveIndexPlan() {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        for (AbstractContext.ModelContext modelContext : this.getModelContexts()) {
            if (modelContext.skipSavingMetadata()) continue;
            IndexPlan indexPlan = modelContext.getTargetIndexPlan();
            if (indexPlanManager.getIndexPlan(indexPlan.getUuid()) == null) {
                indexPlanManager.createIndexPlan(indexPlan);
                NDataflow df = dataflowManager.createDataflow(indexPlan, indexPlan.getModel().getOwner());
                dataflowManager.fillDfManually(df, Collections.singletonList(SegmentRange.TimePartitionedSegmentRange.createInfinite()));
                continue;
            }
            indexPlanManager.updateIndexPlan(indexPlan);
        }
    }

    @Override
    public ChainedProposer createProposers() {
        ImmutableList proposers = ImmutableList.of((Object)new SQLAnalysisProposer(this), (Object)new ModelSelectProposer(this), (Object)new ModelOptProposer(this), (Object)new ModelInfoAdjustProposer(this), (Object)new ModelRenameProposer(this), (Object)new IndexPlanSelectProposer(this), (Object)new IndexPlanOptProposer(this), (Object)new IndexPlanShrinkProposer(this));
        return new ChainedProposer(this, (ImmutableList<AbstractProposer>)proposers);
    }

    @Generated
    public ExpandableMeasureUtil getExpandableMeasureUtil() {
        return this.expandableMeasureUtil;
    }
}

