/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query.mockup;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.guava30.shaded.common.base.Stopwatch;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.rec.query.QueryRecord;
import org.apache.kylin.rec.query.mockup.AbstractQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockupQueryExecutor
extends AbstractQueryExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockupQueryExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryRecord execute(String project, KylinConfig kylinConfig, String sql) {
        Stopwatch watch = Stopwatch.createStarted();
        ContextUtil.clearThreadLocalContexts();
        QueryContext.reset();
        BackdoorToggles.addToggle((String)"DEBUG_TOGGLE_CHECK_ALL_MODELS", (String)"true");
        BackdoorToggles.addToggle((String)"DISABLE_RAW_QUERY_HACKER", (String)"true");
        BackdoorToggles.addToggle((String)"DEBUG_TOGGLE_PREPARE_ONLY", (String)"true");
        QueryRecord record = MockupQueryExecutor.getCurrentRecord();
        QueryContext.current().setForModeling(true);
        if (!QueryUtil.isSelectStatement((String)sql)) {
            record.noteNonQueryException(project, sql, watch.elapsed(TimeUnit.MILLISECONDS));
            return record;
        }
        try {
            QueryExec queryExec = new QueryExec(project, kylinConfig);
            QueryParams queryParams = new QueryParams(kylinConfig, sql, project, 0, 0, queryExec.getDefaultSchemaName(), true);
            queryExec.executeQuery(QueryUtil.massageSql((QueryParams)queryParams));
        }
        catch (Throwable e) {
            String message;
            Throwable cause = e.getCause();
            String string = message = e.getMessage() == null ? String.format(Locale.ROOT, "%s, check kylin.log for details", e.getClass().toString()) : QueryUtil.makeErrorMsgUserFriendly((Throwable)e);
            if (!(cause instanceof NoRealizationFoundException)) {
                log.debug("Failed to run in MockupQueryExecutor. Critical stackTrace:\n{}", (Object)ThreadUtil.getKylinStackTrace());
            }
            record.noteException(message, e);
        }
        finally {
            record.noteNormal(project, sql, watch.elapsed(TimeUnit.MILLISECONDS), QueryContext.current().getQueryId());
            record.noteOlapContexts();
            record.getOlapContexts().forEach(ctx -> ctx.setAggregations(this.transformSpecialFunctions((OlapContext)ctx)));
            MockupQueryExecutor.clearCurrentRecord();
        }
        return record;
    }

    private List<FunctionDesc> transformSpecialFunctions(OlapContext ctx) {
        return ctx.getAggregations().stream().map(func -> {
            if ("INTERSECT_COUNT".equalsIgnoreCase(func.getExpression())) {
                ctx.getGroupByColumns().add(((ParameterDesc)func.getParameters().get(1)).getColRef());
                return FunctionDesc.newInstance((String)"COUNT_DISTINCT", func.getParameters().subList(0, 1), (String)"bitmap");
            }
            if ("BITMAP_UUID".equalsIgnoreCase(func.getExpression())) {
                return FunctionDesc.newInstance((String)"COUNT_DISTINCT", func.getParameters().subList(0, 1), (String)"bitmap");
            }
            return func;
        }).collect(Collectors.toList());
    }
}

