/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.SourceConnectorFactory;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownRunnerSDKImpl
implements IPushDownRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PushDownRunnerSDKImpl.class);
    private JdbcConnector dataSource;

    public void init(KylinConfig config) {
        this.dataSource = SourceConnectorFactory.getJdbcConnector(config);
    }

    public void init(KylinConfig config, String project) {
        this.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String query, List<List<String>> returnRows, List<SelectedColumnMeta> returnColumnMeta, String project) throws SQLException {
        query = this.dataSource.convertSql(query);
        ResultSet rs = null;
        String dbName = null;
        if (StringUtils.isNotBlank((CharSequence)project)) {
            dbName = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getDefaultDatabase(project);
        }
        try (Connection conn = this.dataSource.getConnectionWithDefaultDb(dbName);
             Statement state = conn.createStatement();){
            log.info("SDK push down sql is [{}]", (Object)query);
            rs = state.executeQuery(query);
            this.extractResults(rs, returnRows);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                int kylinTypeId = this.dataSource.toKylinTypeId(metaData.getColumnTypeName(i), metaData.getColumnType(i));
                String kylinTypeName = this.dataSource.toKylinTypeName(kylinTypeId);
                returnColumnMeta.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), false, metaData.isCurrency(i), metaData.isNullable(i), false, metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), null, null, null, metaData.getPrecision(i), metaData.getScale(i), kylinTypeId, kylinTypeName, metaData.isReadOnly(i), false, false));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(rs);
            throw throwable;
        }
        DBUtils.closeQuietly((ResultSet)rs);
    }

    public void executeUpdate(String sql, String project) throws SQLException {
        this.dataSource.executeUpdate(sql);
    }

    public String getName() {
        return "RDBMS";
    }

    private void extractResults(ResultSet resultSet, List<List<String>> results) throws SQLException {
        LinkedList<String> oneRow = new LinkedList<String>();
        while (resultSet.next()) {
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(new LinkedList(oneRow));
            oneRow.clear();
        }
    }
}

