/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import java.io.IOException;
import org.apache.kylin.guava30.shaded.common.net.HostAndPort;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    public HostAndPort deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_OBJECT)) {
            JsonNode root = (JsonNode)p.readValueAsTree();
            JsonNode hostNode = root.get("host");
            String host = hostNode == null ? root.path("hostText").asText() : hostNode.textValue();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString((String)host);
            }
            return HostAndPort.fromParts((String)host, (int)n.asInt());
        }
        return (HostAndPort)super.deserialize(p, ctxt);
    }

    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString((String)value);
    }
}

