/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.discovery.ConditionalOnNodeRegistryZookeeperEnabled;
import org.apache.kylin.rest.discovery.KylinServiceDiscovery;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryClient;
import org.springframework.stereotype.Component;

@ConditionalOnZookeeperEnabled
@ConditionalOnNodeRegistryZookeeperEnabled
@Component
public class KylinServiceDiscoveryClient
implements KylinServiceDiscovery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinServiceDiscoveryClient.class);
    private final Registration registration;
    private final ZookeeperDiscoveryClient discoveryClient;

    public KylinServiceDiscoveryClient(Registration registration, ZookeeperDiscoveryClient discoveryClient) {
        this.registration = registration;
        this.discoveryClient = discoveryClient;
    }

    public String getLocalServiceServer() {
        return this.registration.getHost() + ":" + this.registration.getPort();
    }

    public List<ServerInfoResponse> getServerInfoByServerMode(ClusterConstant.ServerModeEnum ... serverModeEnums) {
        ArrayList<ServerInfoResponse> serverInfoRespLists = new ArrayList<ServerInfoResponse>();
        if (ArrayUtils.isEmpty((Object[])serverModeEnums)) {
            return serverInfoRespLists;
        }
        for (ClusterConstant.ServerModeEnum nodeType : serverModeEnums) {
            for (String host : this.getServerStrByServerMode(nodeType)) {
                serverInfoRespLists.add(new ServerInfoResponse(host, nodeType.getName()));
            }
        }
        return serverInfoRespLists;
    }

    private List<String> getServerStrByServerMode(@Nonnull ClusterConstant.ServerModeEnum serverModeEnum) {
        Preconditions.checkNotNull((Object)serverModeEnum, (Object)"server mode is null");
        String serverModeName = serverModeEnum.getName();
        List list = this.discoveryClient.getInstances(serverModeName);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list.stream().map(serviceInstance -> serviceInstance.getHost() + ":" + serviceInstance.getPort()).collect(Collectors.toList());
    }
}

