/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.blacklist;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.query.blacklist.SQLBlacklist;
import org.apache.kylin.query.blacklist.SQLBlacklistItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBlacklistManager {
    private static final Logger logger = LoggerFactory.getLogger(SQLBlacklistManager.class);
    private KylinConfig config;
    private CachedCrudAssist<SQLBlacklist> crud;

    public SQLBlacklistManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing SQLBlacklistManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        logger.info("Initializing SQLBlacklistManager with config {}", (Object)config);
        this.config = config;
        this.crud = new CachedCrudAssist<SQLBlacklist>(this.getStore(), MetadataType.SQL_BLACKLIST, null, SQLBlacklist.class){

            public SQLBlacklist initEntityAfterReload(SQLBlacklist sqlBlacklist, String resourceName) {
                return sqlBlacklist;
            }
        };
        this.crud.reloadAll();
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public static SQLBlacklistManager getInstance(KylinConfig config) {
        return (SQLBlacklistManager)config.getManager(SQLBlacklistManager.class);
    }

    static SQLBlacklistManager newInstance(KylinConfig config) {
        try {
            String cls = SQLBlacklistManager.class.getName();
            Class clz = ClassUtil.forName((String)cls, SQLBlacklistManager.class);
            return (SQLBlacklistManager)clz.getConstructor(KylinConfig.class).newInstance(config);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init SQLBlacklistManager from " + config, e);
        }
    }

    public SQLBlacklistItem getSqlBlacklistItemById(String project, String id) {
        SQLBlacklist sqlBlacklist = this.getSqlBlacklist(project);
        if (null == sqlBlacklist) {
            return null;
        }
        return sqlBlacklist.getSqlBlacklistItem(id);
    }

    public SQLBlacklistItem getSqlBlacklistItemByRegex(String project, String regex) {
        SQLBlacklist sqlBlacklist = this.getSqlBlacklist(project);
        if (null == sqlBlacklist) {
            return null;
        }
        return sqlBlacklist.getSqlBlacklistItemByRegex(regex);
    }

    public SQLBlacklistItem getSqlBlacklistItemBySql(String project, String sql) {
        SQLBlacklist sqlBlacklist = this.getSqlBlacklist(project);
        if (null == sqlBlacklist) {
            return null;
        }
        return sqlBlacklist.getSqlBlacklistItemBySql(sql);
    }

    public SQLBlacklist getSqlBlacklist(String project) {
        return (SQLBlacklist)this.crud.get(project);
    }

    private SQLBlacklist copyForWrite(SQLBlacklist sqlBlacklist) {
        return (SQLBlacklist)this.crud.copyForWrite((RootPersistentEntity)sqlBlacklist);
    }

    public SQLBlacklist saveSqlBlacklist(SQLBlacklist sqlBlacklist) throws IOException {
        SQLBlacklist copy;
        SQLBlacklist savedSqlBlacklist = this.getSqlBlacklist(sqlBlacklist.getProject());
        if (null != savedSqlBlacklist) {
            copy = this.copyForWrite(savedSqlBlacklist);
            copy.setBlacklistItems(sqlBlacklist.getBlacklistItems());
        } else {
            copy = this.copyForWrite(sqlBlacklist);
        }
        this.crud.save((RootPersistentEntity)copy);
        return sqlBlacklist;
    }

    public SQLBlacklist addSqlBlacklistItem(String project, SQLBlacklistItem sqlBlacklistItem) throws IOException {
        SQLBlacklist sqlBlacklist = this.copyForWrite(this.getSqlBlacklist(project));
        if (null == sqlBlacklist) {
            sqlBlacklist = this.copyForWrite(new SQLBlacklist(project));
        }
        sqlBlacklist.addBlacklistItem(sqlBlacklistItem);
        this.crud.save((RootPersistentEntity)sqlBlacklist);
        return sqlBlacklist;
    }

    public SQLBlacklist updateSqlBlacklistItem(String project, SQLBlacklistItem sqlBlacklistItem) throws IOException {
        SQLBlacklist sqlBlacklist = this.copyForWrite(this.getSqlBlacklist(project));
        if (null == sqlBlacklist) {
            return null;
        }
        SQLBlacklistItem originItem = sqlBlacklist.getSqlBlacklistItem(sqlBlacklistItem.getId());
        if (null == originItem) {
            return sqlBlacklist;
        }
        originItem.setRegex(sqlBlacklistItem.getRegex());
        originItem.setSql(sqlBlacklistItem.getSql());
        originItem.setConcurrentLimit(sqlBlacklistItem.getConcurrentLimit());
        this.crud.save((RootPersistentEntity)sqlBlacklist);
        return sqlBlacklist;
    }

    public SQLBlacklist deleteSqlBlacklistItem(String project, String id) throws IOException {
        SQLBlacklist sqlBlacklist = this.copyForWrite(this.getSqlBlacklist(project));
        if (null == sqlBlacklist) {
            return null;
        }
        sqlBlacklist.deleteSqlBlacklistItem(id);
        this.crud.save((RootPersistentEntity)sqlBlacklist);
        return sqlBlacklist;
    }

    public SQLBlacklist clearBlacklist(String project) throws IOException {
        SQLBlacklist sqlBlacklist = this.copyForWrite(this.getSqlBlacklist(project));
        if (null == sqlBlacklist) {
            return null;
        }
        sqlBlacklist.setBlacklistItems(Lists.newArrayList());
        this.crud.save((RootPersistentEntity)sqlBlacklist);
        return sqlBlacklist;
    }

    public SQLBlacklistItem matchSqlBlacklist(String project, String sql) {
        SQLBlacklist sqlBlacklist = this.getSqlBlacklist(project);
        if (null == sqlBlacklist) {
            return null;
        }
        return sqlBlacklist.match(sql);
    }
}

