/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.filter;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFiltersCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(QueryFiltersCollector.class);
    public static final ConcurrentMap<String, Map<String, Map<String, Integer>>> currentQueryFilters = Maps.newConcurrentMap();
    public static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("query-filter-collector"));
    public static final String SERVER_HOST = AddressUtil.getLocalServerInfo();
    public static final String FILTER_STORAGE_PATH = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/_query_filter/";

    public static void increaseHit(String project, String modelId, String columnId) {
        if (!KylinConfig.getInstanceFromEnv().isBloomCollectFilterEnabled()) {
            return;
        }
        project = StringUtils.upperCase((String)project);
        Map<String, Integer> modelFilters = QueryFiltersCollector.getModelFilters(project, modelId);
        int hit = modelFilters.getOrDefault(columnId, 0);
        modelFilters.put(columnId, ++hit);
    }

    public static void initScheduler() {
        if (!KylinConfig.getInstanceFromEnv().isBloomCollectFilterEnabled()) {
            return;
        }
        executor.scheduleAtFixedRate(() -> {
            long startTime = System.currentTimeMillis();
            LOGGER.info("Start sync query filters, current query filters is " + currentQueryFilters);
            try {
                KylinConfig config = KylinConfig.getInstanceFromEnv();
                FileSystem fs = HadoopUtil.getFileSystem((String)config.getHdfsWorkingDirectory());
                currentQueryFilters.forEach((project, currentFilters) -> {
                    try {
                        Path projectFilterPath = QueryFiltersCollector.getProjectFiltersFile(SERVER_HOST, project);
                        Map<String, Map<String, Integer>> mergedHistory = !fs.exists(projectFilterPath) ? currentFilters : QueryFiltersCollector.mergeHistory(fs, currentFilters, projectFilterPath);
                        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)JsonUtil.writeValueAsString(mergedHistory), (Path)projectFilterPath);
                        currentQueryFilters.remove(project);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error when sync query filters for project : " + project, (Throwable)e);
                    }
                });
                long endTime = System.currentTimeMillis();
                LOGGER.info("Sync query filters success. cost time " + (endTime - startTime) + " ms. the failed filters maybe " + currentQueryFilters);
            }
            catch (Throwable e) {
                LOGGER.error("Error when sync query filters...", e);
            }
        }, 0L, KylinConfig.getInstanceFromEnv().getQueryFilterCollectInterval(), TimeUnit.SECONDS);
    }

    private static Map<String, Map<String, Integer>> mergeHistory(FileSystem fs, Map<String, Map<String, Integer>> currentFilters, Path projectFilterPath) throws IOException {
        Map history = (Map)JsonUtil.readValue((String)HadoopUtil.readStringFromHdfs((FileSystem)fs, (Path)projectFilterPath), Map.class);
        currentFilters.forEach((currentModel, currentColumns) -> {
            if (!history.containsKey(currentModel)) {
                history.put(currentModel, currentColumns);
            } else {
                Map historyColumns = (Map)history.get(currentModel);
                currentColumns.forEach((column, hit) -> {
                    Integer oriHit = historyColumns.getOrDefault(column, 0);
                    if (oriHit < 0) {
                        oriHit = 0x3FFFFFFF;
                    }
                    historyColumns.put(column, oriHit + hit);
                });
            }
        });
        return history;
    }

    public static void destoryScheduler() {
        executor.shutdown();
    }

    private static Map<String, Map<String, Integer>> getProjectFilters(String project) {
        project = StringUtils.upperCase((String)project);
        currentQueryFilters.computeIfAbsent(project, key -> Maps.newConcurrentMap());
        return (Map)currentQueryFilters.get(project);
    }

    private static Map<String, Integer> getModelFilters(String project, String modelId) {
        project = StringUtils.upperCase((String)project);
        Map<String, Map<String, Integer>> projectFilters = QueryFiltersCollector.getProjectFilters(project);
        projectFilters.computeIfAbsent(modelId, key -> Maps.newConcurrentMap());
        return projectFilters.get(modelId);
    }

    public static Path getProjectFiltersFile(String host, String project) {
        project = StringUtils.upperCase((String)project);
        return new Path(FILTER_STORAGE_PATH + host + "/" + project);
    }

    private QueryFiltersCollector() {
    }
}

