/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import io.delta.standalone.expressions.And;
import io.delta.standalone.expressions.EqualTo;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.GreaterThanOrEqual;
import io.delta.standalone.expressions.LessThan;
import io.delta.standalone.expressions.Literal;
import io.delta.standalone.expressions.Not;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.sources.AlwaysFalse;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkFilters$ {
    public static SparkFilters$ MODULE$;
    private final Pattern BACKTICKS_PATTERN;

    static {
        new SparkFilters$();
    }

    private Pattern BACKTICKS_PATTERN() {
        return this.BACKTICKS_PATTERN;
    }

    public Expression convert(StructType schema, Seq<Filter> filters) {
        return (Expression)filters.foldLeft((Object)Literal.True, (Function2 & Serializable & scala.Serializable)(exprs, filter) -> new And(exprs, MODULE$.convert(schema, (Filter)filter)));
    }

    public Expression convert(StructType schema, Filter filter) {
        Object object;
        Filter filter2 = filter;
        Class clazz = filter.getClass();
        Class<AlwaysTrue> clazz2 = AlwaysTrue.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            object = Literal.True;
        } else {
            Class clazz3 = filter.getClass();
            Class<AlwaysFalse> clazz4 = AlwaysFalse.class;
            if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
                object = Literal.False;
            } else if (filter2 instanceof org.apache.spark.sql.sources.EqualTo) {
                org.apache.spark.sql.sources.EqualTo equalTo = (org.apache.spark.sql.sources.EqualTo)filter2;
                object = new EqualTo((Expression)schema.column(this.unquote(equalTo.attribute())), (Expression)this.literalConvert(equalTo.value()));
            } else if (filter2 instanceof EqualNullSafe) {
                EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
                object = new EqualTo((Expression)schema.column(this.unquote(equalNullSafe.attribute())), (Expression)this.literalConvert(equalNullSafe.value()));
            } else if (filter2 instanceof IsNull) {
                IsNull isNull = (IsNull)filter2;
                object = new io.delta.standalone.expressions.IsNull((Expression)schema.column(this.unquote(isNull.attribute())));
            } else if (filter2 instanceof IsNotNull) {
                IsNotNull isNotNull = (IsNotNull)filter2;
                object = new io.delta.standalone.expressions.IsNotNull((Expression)schema.column(this.unquote(isNotNull.attribute())));
            } else if (filter2 instanceof org.apache.spark.sql.sources.LessThan) {
                org.apache.spark.sql.sources.LessThan lessThan = (org.apache.spark.sql.sources.LessThan)filter2;
                object = new LessThan((Expression)schema.column(this.unquote(lessThan.attribute())), (Expression)this.literalConvert(lessThan.value()));
            } else if (filter2 instanceof LessThanOrEqual) {
                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                object = new io.delta.standalone.expressions.LessThanOrEqual((Expression)schema.column(this.unquote(lessThanOrEqual.attribute())), (Expression)this.literalConvert(lessThanOrEqual.value()));
            } else if (filter2 instanceof GreaterThan) {
                GreaterThan greaterThan = (GreaterThan)filter2;
                object = new io.delta.standalone.expressions.GreaterThan((Expression)schema.column(this.unquote(greaterThan.attribute())), (Expression)this.literalConvert(greaterThan.value()));
            } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThanOrEqual) {
                org.apache.spark.sql.sources.GreaterThanOrEqual greaterThanOrEqual = (org.apache.spark.sql.sources.GreaterThanOrEqual)filter2;
                object = new GreaterThanOrEqual((Expression)schema.column(this.unquote(greaterThanOrEqual.attribute())), (Expression)this.literalConvert(greaterThanOrEqual.value()));
            } else if (filter2 instanceof In) {
                In in = (In)filter2;
                List inValues = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)in.values()).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.literalConvert(v), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class))))).toList()).asJava();
                object = new io.delta.standalone.expressions.In((Expression)schema.column(this.unquote(in.attribute())), inValues);
            } else if (filter2 instanceof org.apache.spark.sql.sources.And) {
                org.apache.spark.sql.sources.And and = (org.apache.spark.sql.sources.And)filter2;
                Expression left = this.convert(schema, and.left());
                Expression right = this.convert(schema, and.right());
                object = left != null && right != null ? new And(left, right) : null;
            } else if (filter2 instanceof Or) {
                Or or = (Or)filter2;
                Expression left = this.convert(schema, or.left());
                Expression right = this.convert(schema, or.right());
                object = left != null && right != null ? new io.delta.standalone.expressions.Or(left, right) : null;
            } else {
                org.apache.spark.sql.sources.Not not;
                object = filter2 instanceof org.apache.spark.sql.sources.Not ? ((not = (org.apache.spark.sql.sources.Not)filter2).child() instanceof StringContains ? Literal.True : new Not(this.convert(schema, not.child()))) : Literal.True;
            }
        }
        return object;
    }

    private String unquote(String attributeName) {
        Matcher matcher = this.BACKTICKS_PATTERN().matcher(attributeName);
        return matcher.replaceAll("$2");
    }

    private Literal literalConvert(Object value) {
        Literal literal;
        org.apache.spark.sql.catalyst.expressions.Literal literal2 = Literal$.MODULE$.apply(value);
        DataType dataType = literal2.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            literal = Literal.of((int)BoxesRunTime.unboxToInt((Object)value));
        } else if (LongType$.MODULE$.equals(dataType)) {
            literal = Literal.of((long)BoxesRunTime.unboxToLong((Object)value));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            literal = Literal.of((double)BoxesRunTime.unboxToDouble((Object)value));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            literal = Literal.of((float)BoxesRunTime.unboxToFloat((Object)value));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            literal = Literal.of((byte)BoxesRunTime.unboxToByte((Object)value));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            literal = Literal.of((short)BoxesRunTime.unboxToShort((Object)value));
        } else if (StringType$.MODULE$.equals(dataType)) {
            literal = Literal.of((String)((String)value));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            literal = Literal.of((boolean)BoxesRunTime.unboxToBoolean((Object)value));
        } else if (DateType$.MODULE$.equals(dataType)) {
            literal = Literal.of((Date)((Date)value));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            literal = Literal.of((Timestamp)((Timestamp)value));
        } else if (dataType instanceof DecimalType) {
            literal = Literal.of((BigDecimal)((BigDecimal)value));
        } else {
            throw new MatchError((Object)dataType);
        }
        return literal;
    }

    private SparkFilters$() {
        MODULE$ = this;
        this.BACKTICKS_PATTERN = Pattern.compile("([`])(.|$)");
    }
}

