/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.scheduler.AutoRefreshJob;
import org.apache.kylin.rest.scheduler.AutoRefreshSnapshotRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class AutoRefreshSnapshotScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoRefreshSnapshotScheduler.class);
    private static final Integer THREAD_POOL_TASK_SCHEDULER_DEFAULT_POOL_SIZE = 20;
    @Autowired
    @Qualifier(value="projectScheduler")
    private TaskScheduler projectScheduler;
    private final Map<String, Pair<String, ScheduledFuture<?>>> taskFutures = Maps.newConcurrentMap();
    private final AtomicInteger schedulerProjectCount = new AtomicInteger(0);

    public void startCron(String project, Runnable task, String cron) {
        this.stopCron(project);
        this.checkSchedulerThreadPoolSize();
        ScheduledFuture scheduledFuture = this.projectScheduler.schedule(task, triggerContext -> {
            CronTrigger trigger = new CronTrigger(cron);
            return trigger.nextExecutionTime(triggerContext);
        });
        log.info("Project[{}] start cron[{}]", (Object)project, (Object)cron);
        this.taskFutures.put(project, new Pair((Object)cron, (Object)scheduledFuture));
    }

    public void checkSchedulerThreadPoolSize() {
        ThreadPoolTaskScheduler projectThreadPoolScheduler = (ThreadPoolTaskScheduler)this.projectScheduler;
        int poolSize = projectThreadPoolScheduler.getPoolSize();
        int projectCount = this.schedulerProjectCount.incrementAndGet();
        if (projectCount > poolSize) {
            projectThreadPoolScheduler.setPoolSize(projectCount);
        } else if (projectCount < THREAD_POOL_TASK_SCHEDULER_DEFAULT_POOL_SIZE && poolSize > THREAD_POOL_TASK_SCHEDULER_DEFAULT_POOL_SIZE) {
            projectThreadPoolScheduler.setPoolSize(THREAD_POOL_TASK_SCHEDULER_DEFAULT_POOL_SIZE.intValue());
        }
    }

    public void stopCron(String project) {
        Pair<String, ScheduledFuture<?>> scheduledFuturePair = this.taskFutures.get(project);
        if (scheduledFuturePair != null) {
            ScheduledFuture future = (ScheduledFuture)scheduledFuturePair.getSecond();
            if (future != null) {
                log.info("Project[{}] stop cron", (Object)project);
                future.cancel(true);
            }
            this.taskFutures.remove(project);
            this.schedulerProjectCount.decrementAndGet();
        }
    }

    @Scheduled(cron="*/30 * * * * ?")
    public void schedulerAutoRefresh() {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig());
        this.schedulerProject(projectManager);
        this.cancelDeletedProject(projectManager);
    }

    private void schedulerProject(NProjectManager projectManager) {
        List projectInstances = projectManager.listAllProjects();
        for (ProjectInstance projectInstance : projectInstances) {
            this.autoRefreshSnapshot(projectInstance);
        }
    }

    public boolean autoRefreshSnapshot(ProjectInstance projectInstance) {
        KylinConfigExt projectConfig = projectInstance.getConfig();
        if (projectConfig.isSnapshotManualManagementEnabled() && projectConfig.isSnapshotAutoRefreshEnabled()) {
            ScheduledFuture future;
            String projectName = projectInstance.getName();
            Pair<String, ScheduledFuture<?>> scheduledFuturePair = this.taskFutures.get(projectName);
            String cronFromConfig = projectConfig.getSnapshotAutoRefreshCron();
            if (scheduledFuturePair != null && (future = (ScheduledFuture)scheduledFuturePair.getSecond()) != null && StringUtils.equals((CharSequence)((CharSequence)scheduledFuturePair.getFirst()), (CharSequence)cronFromConfig)) {
                log.info("Project[{}] skip schedulerAutoRefresh, because is running, cron[{}]", (Object)projectName, (Object)cronFromConfig);
                return false;
            }
            this.startCron(projectName, () -> this.submitJob(projectName), cronFromConfig);
            return true;
        }
        return false;
    }

    private void submitJob(String projectName) {
        if (JobContextUtil.getJobContext((KylinConfig)KylinConfig.getInstanceFromEnv()).getJobScheduler().isMaster()) {
            ExecutableManager manager = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)projectName);
            manager.checkAndSubmitCronJob("AUTO_REFRESH_JOB_FACTORY", JobTypeEnum.AUTO_REFRESH);
        }
    }

    public void cancelDeletedProject(NProjectManager projectManager) {
        for (String project : this.taskFutures.keySet()) {
            ProjectInstance projectInstance = projectManager.getProject(project);
            if (null == projectInstance) {
                AutoRefreshSnapshotRunner.shutdown(project);
                this.stopCron(project);
                this.deleteProjectSnapshotAutoUpdateDir(project);
                log.info("Project[{}] is deleted...", (Object)project);
                continue;
            }
            KylinConfigExt projectConfig = projectInstance.getConfig();
            if (projectConfig.isSnapshotManualManagementEnabled() && projectConfig.isSnapshotAutoRefreshEnabled()) continue;
            AutoRefreshSnapshotRunner.shutdown(project);
            this.stopCron(project);
            this.deleteProjectSnapshotAutoUpdateDir(project);
            log.info("Project[{}] stop auto fresh snapshot...", (Object)project);
        }
    }

    public void deleteProjectSnapshotAutoUpdateDir(String project) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            String projectSnapshotAutoUpdateDirStr = KylinConfig.readSystemKylinConfig().getSnapshotAutoRefreshDir(project);
            Path projectSnapshotAutoUpdateDir = new Path(projectSnapshotAutoUpdateDirStr);
            if (fs.exists(projectSnapshotAutoUpdateDir)) {
                fs.delete(projectSnapshotAutoUpdateDir, true);
                log.debug("delete project[{}] snapshot auto update dir success", (Object)project);
            }
        }
        catch (IOException e) {
            log.error("delete project[{}] snapshot auto update dir has error", (Object)project, (Object)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        log.info("AutoRefreshSnapshotScheduler init...");
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig());
        List allProject = projectManager.listAllProjects();
        for (ProjectInstance project : allProject) {
            KylinConfigExt projectConfig = project.getConfig();
            if (projectConfig.isSnapshotManualManagementEnabled() && projectConfig.isSnapshotAutoRefreshEnabled()) {
                String projectName = project.getName();
                Path markFilepath = new Path(projectConfig.getSnapshotAutoRefreshDir(projectName) + "_mark");
                if (!fs.exists(markFilepath)) continue;
                log.error("Project[{}] last cron task was stopped manually, autoRefreshSnapshotRunner doRun", (Object)projectName);
                AutoRefreshSnapshotRunner autoRefreshSnapshotRunner = AutoRefreshSnapshotRunner.getInstance(projectName);
                autoRefreshSnapshotRunner.runWhenSchedulerInit();
                continue;
            }
            this.deleteProjectSnapshotAutoUpdateDir(project.getName());
        }
    }

    @Generated
    public Map<String, Pair<String, ScheduledFuture<?>>> getTaskFutures() {
        return this.taskFutures;
    }

    @Generated
    public AtomicInteger getSchedulerProjectCount() {
        return this.schedulerProjectCount;
    }

    static {
        JobFactory.register((String)"AUTO_REFRESH_JOB_FACTORY", (JobFactory)new AutoRefreshJob.AutoRefreshJobFactory());
    }
}

