/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.scheduler;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.scheduler.AbstractSchedulerRunnable;
import org.apache.kylin.rest.scheduler.CheckSourceTableResult;
import org.apache.kylin.rest.scheduler.SnapshotSourceTableStatsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class CheckSourceTableRunnable
extends AbstractSchedulerRunnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckSourceTableRunnable.class);
    private static final String SNAPSHOT_TABLE_CHECK_ERROR_MESSAGE = "Project[%s] Snapshot source table[%s] check table stats Failed";

    @Override
    public void execute() {
        this.checkTable();
    }

    public void checkTable() {
        try {
            String[] split = this.tableIdentity.split("\\.");
            String url = String.format(Locale.ROOT, "http://%s/kylin/api/snapshots/source_table_stats", this.config.getServerAddress());
            HashMap req = Maps.newHashMap();
            req.put("project", this.project);
            int length = split.length;
            int databaseStartIndex = 0;
            if (length > 2) {
                req.put("catalog", split[0]);
                databaseStartIndex = 1;
            }
            StringBuilder databaseBuffer = new StringBuilder();
            for (int i = databaseStartIndex; i < length - 1; ++i) {
                databaseBuffer.append(".").append(split[i]);
            }
            req.put("database", databaseBuffer.substring(1));
            req.put("table", split[length - 1]);
            req.put("snapshot_partition_col", this.partitionColumn);
            log.debug("checkTableNeedRefresh request: {}", (Object)req);
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", "application/vnd.apache.kylin-v4-public+json");
            httpHeaders.add("Timeout", "");
            ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)JsonUtil.writeValueAsBytes((Object)req), (MultiValueMap)httpHeaders), String.class, new Object[0]);
            int responseStatus = exchange.getStatusCodeValue();
            if (responseStatus != 200) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, SNAPSHOT_TABLE_CHECK_ERROR_MESSAGE, this.project, this.tableIdentity));
            }
            String responseBody = (String)Optional.ofNullable(exchange.getBody()).orElse("");
            RestResponse response = (RestResponse)JsonUtil.readValue((String)responseBody, (TypeReference)new TypeReference<RestResponse<SnapshotSourceTableStatsResponse>>(){});
            if (!StringUtils.equals((CharSequence)response.getCode(), (CharSequence)"000")) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, SNAPSHOT_TABLE_CHECK_ERROR_MESSAGE, this.project, this.tableIdentity));
            }
            Set<String> needRefreshPartitionsValue = ((SnapshotSourceTableStatsResponse)response.getData()).getNeedRefreshPartitionsValue();
            Boolean needRefresh = ((SnapshotSourceTableStatsResponse)response.getData()).getNeedRefresh();
            log.info("source table[{}] needRefresh[{}], needRefreshPartitionsValue[{}]", new Object[]{this.tableIdentity, needRefresh, needRefreshPartitionsValue});
            CheckSourceTableResult result = new CheckSourceTableResult();
            result.setTableIdentity(this.tableIdentity);
            result.setNeedRefresh(needRefresh);
            result.setNeedRefreshPartitionsValue(needRefreshPartitionsValue);
            this.checkSourceTableQueue.offer(result);
        }
        catch (IOException e) {
            throw new KylinRuntimeException(String.format(Locale.ROOT, SNAPSHOT_TABLE_CHECK_ERROR_MESSAGE, this.project, this.tableIdentity), (Throwable)e);
        }
    }
}

