/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStatusUtil;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.rest.JobFilter;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableExtService;
import org.sparkproject.guava.collect.Lists;

public class JobFilterUtil {
    public static JobMapperFilter getJobMapperFilter(JobFilter jobFilter, int offset, int limit, ModelService modelService, TableExtService tableExtService, ProjectService projectService) {
        Date queryStartTime = JobFilterUtil.getQueryStartTime(jobFilter.getTimeFilter());
        HashSet<String> subjects = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)jobFilter.getSubject())) {
            subjects.add(jobFilter.getSubject().trim());
        }
        ArrayList convertKeyToSubjects = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)jobFilter.getKey())) {
            convertKeyToSubjects.addAll(modelService.getModelNamesByFuzzyName(jobFilter.getKey(), jobFilter.getProject(), jobFilter.isExactMatch()));
            convertKeyToSubjects.addAll(tableExtService.getTableNamesByFuzzyKey(jobFilter.getProject(), jobFilter.getKey(), jobFilter.isExactMatch()));
            convertKeyToSubjects.addAll(projectService.getProjectsFilterByExactMatchAndPermission(jobFilter.getKey(), jobFilter.isExactMatch(), AclPermissionEnum.READ).stream().map(ProjectInstance::getName).collect(Collectors.toList()));
            subjects.addAll(convertKeyToSubjects);
        }
        String jobId = null;
        if (StringUtils.isNotEmpty((CharSequence)jobFilter.getKey()) && convertKeyToSubjects.isEmpty()) {
            jobId = "%" + jobFilter.getKey() + "%";
        }
        String orderByField = JobFilterUtil.convertSortBy(jobFilter.getSortBy());
        String orderType = "ASC";
        if (jobFilter.isReverse()) {
            orderType = "DESC";
        }
        ArrayList scheduleStates = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)jobFilter.getStatuses())) {
            jobFilter.getStatuses().forEach(jobStatus -> scheduleStates.addAll(JobStatusUtil.mapJobStatusToScheduleState((JobStatusEnum)jobStatus)));
        }
        return new JobMapperFilter((List)scheduleStates, jobFilter.getJobNames(), queryStartTime.getTime(), (List)Lists.newArrayList(subjects), null, jobId, null, jobFilter.getProject(), orderByField, orderType, offset, limit, null, null);
    }

    private static Date getQueryStartTime(int timeFilter) {
        JobTimeFilterEnum filterEnum = JobTimeFilterEnum.getByCode((int)timeFilter);
        Preconditions.checkNotNull((Object)filterEnum, (String)"Can not find the JobTimeFilterEnum by code: %s", (int)timeFilter);
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        calendar.setTime(new Date());
        Message msg = MsgPicker.getMsg();
        switch (filterEnum) {
            case LAST_ONE_DAY: {
                calendar.add(5, -1);
                return calendar.getTime();
            }
            case LAST_ONE_WEEK: {
                calendar.add(4, -1);
                return calendar.getTime();
            }
            case LAST_ONE_MONTH: {
                calendar.add(2, -1);
                return calendar.getTime();
            }
            case LAST_ONE_YEAR: {
                calendar.add(1, -1);
                return calendar.getTime();
            }
            case ALL: {
                return new Date(0L);
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, msg.getIllegalTimeFilter());
    }

    private static String convertSortBy(String sortBy) {
        if (StringUtils.isEmpty((CharSequence)sortBy)) {
            return "update_time";
        }
        Message msg = MsgPicker.getMsg();
        switch (sortBy) {
            case "project": 
            case "create_time": 
            case "job_status": {
                return sortBy;
            }
            case "id": {
                return "job_id";
            }
            case "job_name": {
                return "job_type";
            }
            case "target_subject": {
                return "model_id";
            }
            case "duration": 
            case "total_duration": {
                return "job_duration_millis";
            }
            case "last_modified": {
                return "update_time";
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, msg.getIllegalSortByFilter(), sortBy));
    }
}

