/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.request.BatchAccessRequest;
import org.apache.kylin.rest.request.GlobalAccessRequest;
import org.apache.kylin.rest.request.GlobalBatchAccessRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.response.CompositePermissionResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.UserAccessEntryResponse;
import org.apache.kylin.rest.security.AclPermissionEnum;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.AclTCRService;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.UserAclService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.model.Permission;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/access"}, produces={"application/vnd.apache.kylin-v4+json"})
public class NAccessController
extends NBasicController {
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    @Qualifier(value="aclTCRService")
    private AclTCRService aclTCRService;
    @Autowired(required=false)
    @Qualifier(value="userAclService")
    private UserAclService userAclService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;

    @ApiOperation(value="access control APIs", tags={"MID"})
    @GetMapping(value={"/permission/project_permission"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> getUserPermissionInPrj(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        List groups = this.accessService.getGroupsOfCurrentUser();
        String permission = groups.contains("ROLE_ADMIN") ? "GLOBAL_ADMIN" : AclPermissionEnum.convertToAclPermission((String)this.accessService.getCurrentNormalUserPermissionInProject(project));
        return new EnvelopeResponse("000", (Object)permission, "");
    }

    @ApiOperation(value="access control APIs", tags={"MID"})
    @GetMapping(value={"/permission/project_ext_permission"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<CompositePermissionResponse> getUserExtPermissionInPrj(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        List groups = this.accessService.getGroupsOfCurrentUser();
        CompositePermissionResponse permissionResponse = new CompositePermissionResponse();
        String permission = groups.contains("ROLE_ADMIN") ? "GLOBAL_ADMIN" : AclPermissionEnum.convertToAclPermission((String)this.accessService.getCurrentNormalUserPermissionInProject(project));
        permissionResponse.setPermission(permission);
        permissionResponse.setExtPermissions(this.accessService.getUserNormalExtPermissions(project));
        return new EnvelopeResponse("000", (Object)permissionResponse, "");
    }

    @ApiOperation(value="getAvailableSids", tags={"MID"}, notes="Update Param: sid_type, is_case_sensitive, page_offset, page_size; Update Response: total_size")
    @GetMapping(value={"/available/{sid_type:.+}/{uuid:.+}"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<String>>> getAvailableSids(@PathVariable(value="uuid") String uuid, @PathVariable(value="sid_type") String sidType, @RequestParam(value="project", required=false) String project, @RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", uuid);
        ArrayList whole = Lists.newArrayList();
        if (sidType.equalsIgnoreCase("user")) {
            whole.addAll(this.userService.listNormalUsers());
            List users = this.accessService.getAllAclSids((AclEntity)ae, "user");
            whole.removeAll(users);
        } else {
            whole.addAll(this.getAllUserGroups());
            List groups = this.accessService.getAllAclSids((AclEntity)ae, "group");
            whole.removeAll(groups);
            whole.remove("ROLE_ADMIN");
        }
        List matchedSids = PagingUtil.getIdentifierAfterFuzzyMatching((String)nameSeg, (boolean)isCaseSensitive, (Collection)whole);
        List subList = PagingUtil.cutPage((List)matchedSids, (int)pageOffset, (int)pageSize);
        return new EnvelopeResponse("000", (Object)DataResult.get((Collection)subList, (Collection)matchedSids), "");
    }

    @ApiOperation(value="access control APIs", tags={"MID"})
    @GetMapping(value={"/available/{entity_type:.+}"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<String>>> getAvailableUsers(@PathVariable(value="entity_type") String entityType, @RequestParam(value="project") String project, @RequestParam(value="model", required=false) String modelId, @RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        this.checkProjectName(project);
        ArrayList whole = Lists.newArrayList();
        if ("ProjectInstance".equals(entityType)) {
            whole.addAll(this.accessService.getProjectAdminUsers(project));
            whole.remove(this.getProject(project).getOwner());
        } else {
            this.checkRequiredArg("model", modelId);
            whole.addAll(this.accessService.getProjectManagementUsers(project));
            NDataModel model = ((NDataModelManager)this.projectService.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
            if (Objects.isNull(model) || model.isBroken()) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelId});
            }
            whole.remove(model.getOwner());
        }
        List matchedUsers = PagingUtil.getIdentifierAfterFuzzyMatching((String)nameSeg, (boolean)isCaseSensitive, (Collection)whole);
        List subList = PagingUtil.cutPage((List)matchedUsers, (int)pageOffset, (int)pageSize);
        return new EnvelopeResponse("000", (Object)DataResult.get((Collection)subList, (Collection)matchedUsers), "");
    }

    @ApiOperation(value="getGlobalUserAccessEntities", tags={"MID"}, notes="Update Param: sid")
    @GetMapping(value={"/global/permission/{permissionType:.+}/{sid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Boolean>> getGlobalUserAccessEntities(@PathVariable(value="permissionType") String permissionType, @PathVariable(value="sid") String sid) {
        Permission permission = AclPermissionFactory.getPermission((String)permissionType.toUpperCase(Locale.ROOT));
        boolean hasAclPermission = this.userAclService.isSuperAdmin(sid) || this.userAclService.hasUserAclPermission(sid, permission);
        return new EnvelopeResponse("000", Collections.singletonMap("enabled", hasAclPermission), "");
    }

    @ApiOperation(value="addGlobalUserAccessEntities", tags={"MID"}, notes="Update Body: sid")
    @PutMapping(value={"/global/permission/{permissionType:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> addGlobalUserAccessEntities(@PathVariable(value="permissionType") String permissionType, @RequestBody GlobalAccessRequest accessRequest) {
        this.checkRequiredArg("username", accessRequest.getUsername());
        if (accessRequest.isEnabled()) {
            this.userAclService.grantUserAclPermission(accessRequest, permissionType);
        } else {
            this.userAclService.revokeUserAclPermission(accessRequest, permissionType);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/global/permission/project/{permissionType:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> addProjectToUserAcl(@PathVariable(value="permissionType") String permissionType, @RequestBody GlobalAccessRequest accessRequest) {
        this.checkRequiredArg("username", accessRequest.getUsername());
        this.checkProjectName(accessRequest.getProject());
        this.userAclService.addProjectToUserAcl(accessRequest, permissionType);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @DeleteMapping(value={"/global/permission/project/{permissionType:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> deleteProjectFromUserAcl(@PathVariable(value="permissionType") String permissionType, @RequestBody GlobalAccessRequest accessRequest) {
        this.checkRequiredArg("username", accessRequest.getUsername());
        this.checkProjectName(accessRequest.getProject());
        this.userAclService.deleteProjectFromUserAcl(accessRequest, permissionType);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="batchAddGlobalUserAccessEntities", tags={"MID"}, notes="Update Body: sid")
    @PutMapping(value={"/global/batch/permission/{permissionType:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> batchAddGlobalUserAccessEntities(@PathVariable(value="permissionType") String permissionType, @RequestBody GlobalBatchAccessRequest accessRequest) {
        this.checkRequiredArg("usernames", accessRequest.getUsernameList());
        if (accessRequest.isEnabled()) {
            this.userAclService.grantUserAclPermission(accessRequest, permissionType);
        } else {
            this.userAclService.revokeUserAclPermission(accessRequest, permissionType);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getAllGlobalUsersAccessEntities", tags={"MID"}, notes="Update Param: sid")
    @GetMapping(value={"/global/permission/user_acls"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<List<UserAccessEntryResponse>> getAllGlobalUsersAccessEntities() {
        return new EnvelopeResponse("000", (Object)this.userAclService.listUserAcl(), "");
    }

    @ApiOperation(value="getAccessEntities", tags={"MID"}, notes="Update Param: is_case_sensitive, page_offset, page_size; Update Response: total_size")
    @GetMapping(value={"/{type:.+}/{uuid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<AccessEntryResponse>>> getAccessEntities(@PathVariable(value="type") String type, @PathVariable(value="uuid") String uuid, @RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        List resultsAfterFuzzyMatching = this.accessService.generateAceResponsesByFuzzMatching((AclEntity)ae, nameSeg, isCaseSensitive);
        List sublist = PagingUtil.cutPage((List)resultsAfterFuzzyMatching, (int)pageOffset, (int)pageSize);
        return new EnvelopeResponse("000", (Object)DataResult.get((Collection)sublist, (Collection)resultsAfterFuzzyMatching), "");
    }

    @ApiOperation(value="get users and groups for project", tags={"MID"})
    @GetMapping(value={"/{uuid:.+}/all"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, List<String>>> getProjectUsersAndGroups(@PathVariable(value="uuid") String uuid) throws IOException {
        RootPersistentEntity ae = this.accessService.getAclEntity("ProjectInstance", uuid);
        Map result = this.accessService.getProjectUsersAndGroups((AclEntity)ae);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="grant", tags={"MID"}, notes="Update URL: {entity_type}; Update Body: access_entry_id")
    @PostMapping(value={"/{entity_type:.+}/{uuid:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> grant(@PathVariable(value="entity_type") String entityType, @PathVariable(value="uuid") String uuid, @RequestBody AccessRequest accessRequest) throws IOException {
        this.checkSid(accessRequest);
        if (accessRequest.isPrincipal()) {
            this.accessService.checkGlobalAdmin(accessRequest.getSid());
        }
        RootPersistentEntity ae = this.accessService.getAclEntity(entityType, uuid);
        if (StringUtils.isBlank((CharSequence)accessRequest.getProject())) {
            this.accessService.grant((AclEntity)ae, accessRequest.getSid(), Boolean.valueOf(accessRequest.isPrincipal()), accessRequest.getPermission());
        } else {
            this.accessService.grant(accessRequest.getProject(), (AclEntity)ae, accessRequest.getSid(), Boolean.valueOf(accessRequest.isPrincipal()), accessRequest.getPermission());
        }
        if ("ProjectInstance".equals(entityType)) {
            this.aclTCRService.remoteGrantACL(uuid, (List)Lists.newArrayList((Object[])new AccessRequest[]{accessRequest}));
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="batchGrant", tags={"MID"}, notes="Update URL: {entity_type}; Update Body: access_entry_id")
    @PostMapping(value={"/batch/{entity_type:.+}/{uuid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<String> batchGrant(@PathVariable(value="entity_type") String entityType, @PathVariable(value="uuid") String uuid, @RequestParam(value="project", required=false) String project, @RequestParam(value="init_acl", required=false, defaultValue="true") boolean initAcl, @RequestBody List<BatchAccessRequest> batchAccessRequests) throws IOException {
        List<AccessRequest> requests = this.transform(batchAccessRequests);
        this.accessService.checkAccessRequestList(requests);
        RootPersistentEntity ae = this.accessService.getAclEntity(entityType, uuid);
        if (StringUtils.isBlank((CharSequence)project)) {
            this.accessService.batchGrant(requests, (AclEntity)ae);
        } else {
            this.accessService.batchGrant(project, requests, (AclEntity)ae);
        }
        if ("ProjectInstance".equals(entityType) && initAcl) {
            this.aclTCRService.remoteGrantACL(uuid, requests);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="batchGrant", tags={"MID"}, notes="Update Body: access_entry_id")
    @PutMapping(value={"/{type:.+}/{uuid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> updateAcl(@PathVariable(value="type") String type, @PathVariable(value="uuid") String uuid, @RequestBody AccessRequest accessRequest) throws IOException {
        this.checkSid(accessRequest);
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Permission permission = AclPermissionFactory.getPermission((String)accessRequest.getPermission());
        if (Objects.isNull(permission)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Operation failed, unknown permission:" + accessRequest.getPermission());
        }
        if (accessRequest.isPrincipal()) {
            this.accessService.checkGlobalAdmin(accessRequest.getSid());
        }
        if (StringUtils.isBlank((CharSequence)accessRequest.getProject())) {
            this.accessService.update((AclEntity)ae, accessRequest.getAccessEntryId().intValue(), permission);
        } else {
            this.accessService.update(accessRequest.getProject(), (AclEntity)ae, accessRequest.getAccessEntryId().intValue(), permission);
        }
        boolean hasAdminProject = CollectionUtils.isNotEmpty((Collection)this.projectService.getAdminProjects());
        return new EnvelopeResponse("000", (Object)hasAdminProject, "");
    }

    @ApiOperation(value="revokeAcl", tags={"MID"}, notes="URL: entity_type; Update Param: entity_type; Update Body: access_entry_id")
    @DeleteMapping(value={"/{entity_type:.+}/{uuid:.+}"})
    @ResponseBody
    public EnvelopeResponse<Boolean> revokeAcl(@PathVariable(value="entity_type") String entityType, @PathVariable(value="uuid") String uuid, @RequestParam(value="access_entry_id") Integer accessEntryId, @RequestParam(value="sid") String sid, @RequestParam(value="principal") boolean principal, @RequestParam(value="project", required=false) String project) throws IOException {
        this.accessService.checkSidNotEmpty(sid, principal);
        if (principal) {
            this.accessService.checkGlobalAdmin(sid);
        }
        RootPersistentEntity ae = this.accessService.getAclEntity(entityType, uuid);
        if (StringUtils.isBlank((CharSequence)project)) {
            this.accessService.revoke((AclEntity)ae, accessEntryId.intValue());
        } else {
            this.accessService.revoke(project, (AclEntity)ae, accessEntryId.intValue());
        }
        if ("ProjectInstance".equals(entityType)) {
            this.aclTCRService.remoteRevokeACL(uuid, sid, principal);
        }
        boolean hasAdminProject = CollectionUtils.isNotEmpty((Collection)this.projectService.getAdminProjects());
        return new EnvelopeResponse("000", (Object)hasAdminProject, "");
    }

    @ApiOperation(value="batch revoke Acl", tags={"MID"}, notes="")
    @PostMapping(value={"/{entity_type:.+}/{uuid:.+}/deletion"}, produces={"application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> deleteAces(@PathVariable(value="entity_type") String entityType, @PathVariable(value="uuid") String uuid, @RequestBody List<AccessRequest> requests) throws IOException {
        this.accessService.checkSid(requests);
        List users = requests.stream().filter(AccessRequest::isPrincipal).map(AccessRequest::getSid).collect(Collectors.toList());
        this.accessService.checkGlobalAdmin(users);
        RootPersistentEntity ae = this.accessService.getAclEntity(entityType, uuid);
        this.accessService.batchRevoke((AclEntity)ae, requests);
        if ("ProjectInstance".equals(entityType)) {
            for (AccessRequest r : requests) {
                this.aclTCRService.remoteRevokeACL(uuid, r.getSid(), r.isPrincipal());
            }
        }
        boolean hasAdminProject = CollectionUtils.isNotEmpty((Collection)this.projectService.getAdminProjects());
        return new EnvelopeResponse("000", (Object)hasAdminProject, "");
    }

    @ApiOperation(value="updateExtensionAcl", tags={"MID"}, notes="Update Body: access_entry_id")
    @PutMapping(value={"/extension/{type:.+}/{uuid:.+}"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
    @ResponseBody
    public EnvelopeResponse<Boolean> updateExtensionAcl(@PathVariable(value="type") String type, @PathVariable(value="uuid") String uuid, @RequestBody AccessRequest accessRequest) throws IOException {
        this.checkSid(accessRequest);
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        if (accessRequest.isPrincipal()) {
            this.accessService.checkGlobalAdmin(accessRequest.getSid());
        }
        if (StringUtils.isBlank((CharSequence)accessRequest.getProject())) {
            this.accessService.updateExtensionPermission((AclEntity)ae, accessRequest);
        } else {
            this.accessService.updateExtensionPermission(accessRequest.getProject(), (AclEntity)ae, accessRequest);
        }
        boolean hasAdminProject = CollectionUtils.isNotEmpty((Collection)this.projectService.getAdminProjects());
        return new EnvelopeResponse("000", (Object)hasAdminProject, "");
    }

    private List<String> getAllUserGroups() throws IOException {
        return this.userGroupService.getAllUserGroups();
    }

    private void checkSid(AccessRequest request) throws IOException {
        this.accessService.checkSid((List)Lists.newArrayList((Object[])new AccessRequest[]{request}));
    }

    private List<AccessRequest> transform(List<BatchAccessRequest> batchAccessRequests) {
        List<AccessRequest> result = Optional.ofNullable(batchAccessRequests).map(Collection::stream).orElseGet(Stream::empty).map(b -> Optional.ofNullable(b.getSids()).map(Collection::stream).orElseGet(Stream::empty).map(sid -> {
            AccessRequest r = new AccessRequest();
            r.setAccessEntryId(Integer.valueOf(b.getAccessEntryId()));
            r.setPermission(b.getPermission());
            r.setExtPermissions(b.getExtPermissions());
            r.setPrincipal(b.isPrincipal());
            if (b.isPrincipal()) {
                r.setSid(this.makeUserNameCaseInSentive((String)sid));
            } else {
                r.setSid(sid);
            }
            return r;
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        HashSet sids = Sets.newHashSet();
        result.stream().filter(r -> !sids.add(r.getSid() + r.isPrincipal())).findAny().ifPresent(r -> {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_USER_NAME, "Operation failed, duplicated sid: " + r.getSid());
        });
        return result;
    }
}

