/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NUserGroupController;
import org.apache.kylin.rest.request.UpdateGroupRequest;
import org.apache.kylin.rest.request.UserGroupRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.UserInfoResponse;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/user_group"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenUserGroupController
extends NBasicController {
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;
    @Autowired
    private NUserGroupController userGroupController;
    @Autowired
    private UserService userService;

    @ApiOperation(value="listGroups", tags={"MID"})
    @GetMapping(value={"/groups"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<String>>> listGroups(@RequestParam(value="group_name", required=false) String groupName, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List groups = this.userGroupService.listAllAuthorities();
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            groups = groups.stream().filter(group -> isCaseSensitive ? group.contains(groupName) : StringUtils.containsIgnoreCase((CharSequence)group, (CharSequence)groupName)).collect(Collectors.toList());
        }
        return new EnvelopeResponse("000", (Object)DataResult.get((List)groups, (int)pageOffset, (int)pageSize), "");
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"})
    @GetMapping(value={"/group_members/{group_name:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<UserInfoResponse>>> getUsersByGroup(@PathVariable(value="group_name") String groupName, @RequestParam(value="username", required=false) String username, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List members = this.userGroupService.getGroupMembersByName(groupName);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            members = members.stream().filter(user -> StringUtils.containsIgnoreCase((CharSequence)user.getUsername(), (CharSequence)username)).collect(Collectors.toList());
        }
        for (ManagedUser user2 : members) {
            this.userService.completeUserInfo(user2);
        }
        List userInfoResponses = members.stream().map(UserInfoResponse::new).collect(Collectors.toList());
        return new EnvelopeResponse("000", (Object)DataResult.get(userInfoResponses, (int)pageOffset, (int)pageSize), "");
    }

    @ApiOperation(value="addUserGroup", tags={"MID"})
    @PostMapping(value={"/{group_name:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> addUserGroup(@PathVariable(value="group_name") String groupName) throws IOException {
        UserGroupRequest request = new UserGroupRequest();
        request.setGroupName(groupName);
        return this.userGroupController.addUserGroup(request);
    }

    @ApiOperation(value="addUserGroupWithBody", tags={"MID"})
    @PostMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> addUserGroupWithBody(@RequestBody UserGroupRequest request) throws IOException {
        return this.userGroupController.addUserGroup(request);
    }

    @ApiOperation(value="delUserGroup", tags={"MID"})
    @DeleteMapping(value={"/{group_name:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> delUserGroup(@PathVariable(value="group_name") String groupName) throws IOException {
        String groupUuid = this.userGroupService.getUuidByGroupName(groupName);
        return this.userGroupController.delUserGroup(groupUuid);
    }

    @ApiOperation(value="delUserGroupWithBody", tags={"MID"})
    @DeleteMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> delUserGroupWithBody(@RequestBody UserGroupRequest request) throws IOException {
        this.userGroupController.checkGroupName(request.getGroupName());
        String groupUuid = this.userGroupService.getUuidByGroupName(request.getGroupName());
        return this.userGroupController.delUserGroup(groupUuid);
    }

    @ApiOperation(value="addOrDelUsersInGroup", tags={"MID"})
    @PutMapping(value={"/users"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> addOrDelUsersInGroup(@RequestBody UpdateGroupRequest updateGroupRequest) throws IOException {
        return this.userGroupController.addOrDelUsers(updateGroupRequest);
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @PostMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchAddUserGroups(@RequestBody List<String> groups) {
        return this.userGroupController.batchAddUserGroups(groups);
    }

    @ApiOperation(value="getUsersByGroup", tags={"MID"}, notes="Update URL: group_name; Update Param: group_name")
    @DeleteMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchDelUserGroup(@RequestBody List<String> groups) throws IOException {
        return this.userGroupController.batchDelUserGroup(groups);
    }
}

